/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.filter;

import com.sun.xml.wss.MessageFilter;
import com.sun.xml.wss.SecurableSoapMessage;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.filter.FilterBase;
import com.sun.xml.wss.filter.TeeFilter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.logging.Level;
import javax.xml.rpc.soap.SOAPFaultException;
import javax.xml.transform.Source;

public class DumpFilter
extends FilterBase
implements MessageFilter {
    private Level DEFAULT_LOG_LEVEL = Level.INFO;
    private boolean useLogger;
    private boolean doPrettyPrint;
    private Source stylesheet;
    private String label;
    private OutputStream out;
    private final String lineSeparator = System.getProperty("line.separator");

    public DumpFilter(String label) {
        this.useLogger = true;
        this.doPrettyPrint = true;
        this.label = label;
    }

    public DumpFilter(OutputStream out) {
        this.useLogger = false;
        this.doPrettyPrint = false;
        this.stylesheet = null;
        this.out = out;
        this.label = null;
    }

    public DumpFilter() {
    }

    public void init() throws XWSSecurityException {
        this.label = this.getParameter("requestorresponse");
        this.useLogger = true;
        this.doPrettyPrint = true;
    }

    public void process(SecurableSoapMessage secureMessage) throws XWSSecurityException {
        String msg;
        OutputStream dest;
        ByteArrayOutputStream baos = null;
        if (this.useLogger) {
            baos = new ByteArrayOutputStream();
            dest = baos;
        } else {
            dest = this.out;
        }
        if (dest == null) {
            return;
        }
        OutputStreamWriter osw = null;
        if (this.label != null) {
            osw = new OutputStreamWriter(dest);
            msg = "==== " + this.label + " Start ====" + this.lineSeparator;
            try {
                osw.write(msg);
                osw.flush();
            }
            catch (IOException e1) {
                log.log(Level.WARNING, "dump.action.log.fail", e1);
            }
        }
        try {
            TeeFilter teeFilter = this.doPrettyPrint ? new TeeFilter(dest, true) : new TeeFilter(dest, this.stylesheet);
            teeFilter.process(secureMessage);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "unableto.dump.soapmessage", new Object[]{e.getMessage()});
            throw new SOAPFaultException(null, "Unable to dump SOAPMessage", null, null);
        }
        if (this.label != null) {
            msg = "==== " + this.label + " End ====" + this.lineSeparator;
            try {
                osw.write(msg);
                osw.flush();
            }
            catch (IOException e1) {
                log.log(Level.WARNING, "dump.action.log.fail", e1);
            }
        }
        if (this.useLogger) {
            byte[] bytes = baos.toByteArray();
            String logMsg = new String(bytes);
            log.log(this.DEFAULT_LOG_LEVEL, logMsg);
        }
    }
}

