/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss;

import com.sun.xml.wss.XMLUtil;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.impl.SecurityHeaderBlockImpl;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import org.w3c.dom.Element;

public class Timestamp
extends SecurityHeaderBlockImpl {
    private static Logger log = Logger.getLogger("javax.enterprise.resource.webservices.security", "com.sun.xml.wss.LogStrings");
    private static String XSD_DATE_TIME = "xsd:dateTime";
    private String created;
    private String timeout = null;
    private String createdValueType = XSD_DATE_TIME;
    private String expires = null;
    private String expiresValueType = XSD_DATE_TIME;
    private String wsuId = null;
    private static final SimpleDateFormat calendarFormatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");

    public Timestamp() {
    }

    public Timestamp(SOAPElement element) throws XWSSecurityException {
        if (!element.getLocalName().equals("Timestamp") || !XMLUtil.inWsuNS(element)) {
            log.log(Level.SEVERE, "WSS0385.error.creating.timestamp", element.getTagName());
            throw new XWSSecurityException("Invalid timestamp element passed");
        }
        this.setSOAPElement(element);
        Iterator children = element.getChildElements();
        while (children.hasNext()) {
            Object object = children.next();
            if (!(object instanceof SOAPElement)) continue;
            SOAPElement subElement = (SOAPElement)object;
            if ("Created".equals(subElement.getLocalName()) && XMLUtil.inWsuNS(subElement)) {
                this.created = subElement.getValue();
                this.createdValueType = subElement.getAttribute("ValueType");
                if ("".equalsIgnoreCase(this.createdValueType)) {
                    this.createdValueType = null;
                }
            }
            if (!"Expires".equals(subElement.getLocalName()) || !XMLUtil.inWsuNS(subElement)) continue;
            this.expires = subElement.getValue();
            this.expiresValueType = subElement.getAttribute("ValueType");
            if (!"".equalsIgnoreCase(this.expiresValueType)) continue;
            this.expiresValueType = null;
        }
        this.wsuId = element.getAttribute("wsu:Id");
        if ("".equalsIgnoreCase(this.wsuId)) {
            this.wsuId = null;
        }
    }

    public String getCreated() {
        return this.created;
    }

    public void setCreated(String created) {
        this.created = created;
    }

    public String getCreatedValueType() {
        return this.createdValueType;
    }

    public void setCreatedValueType(String createdValueType) {
        this.createdValueType = createdValueType;
    }

    public void setTimeout(String timeout) {
        this.timeout = timeout;
    }

    public String getExpires() {
        return this.expires;
    }

    public void setExpires(String expires) {
        this.expires = expires;
    }

    public String getExpiresValueType() {
        return this.expiresValueType;
    }

    public void setExpiresValueType(String expiresValueType) {
        this.expiresValueType = expiresValueType;
    }

    public String getId() {
        return this.wsuId;
    }

    public void setId(String wsuId) {
        this.wsuId = wsuId;
    }

    public SOAPElement getAsSoapElement() throws XWSSecurityException {
        SOAPElement timestamp;
        this.createDateTime();
        try {
            timestamp = Timestamp.getSoapFactory().createElement("Timestamp", "wsu", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd");
            timestamp.addNamespaceDeclaration("wsu", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd");
            SOAPElement createdElement = timestamp.addChildElement("Created", "wsu").addTextNode(this.created);
            if (this.createdValueType != null && !XSD_DATE_TIME.equalsIgnoreCase(this.createdValueType)) {
                createdElement.setAttribute("ValueType", this.createdValueType);
            }
            if (this.expires != null) {
                SOAPElement expiresElement = timestamp.addChildElement("Expires", "wsu").addTextNode(this.expires);
                if (this.expiresValueType != null && !XSD_DATE_TIME.equalsIgnoreCase(this.expiresValueType)) {
                    expiresElement.setAttribute("ValueType", this.expiresValueType);
                }
            }
            if (this.wsuId != null) {
                this.setWsuIdAttr((Element)timestamp, this.getId());
            }
        }
        catch (SOAPException se) {
            log.log(Level.SEVERE, "WSS0386.error.creating.timestamp", se.getMessage());
            throw new XWSSecurityException("There was an error creating  Timestamp " + se.getMessage());
        }
        this.setSOAPElement(timestamp);
        return timestamp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createDateTime() throws XWSSecurityException {
        if (this.created == null) {
            GregorianCalendar c = new GregorianCalendar();
            int offset = c.get(15);
            if (((Calendar)c).getTimeZone().inDaylightTime(c.getTime())) {
                offset += ((Calendar)c).getTimeZone().getDSTSavings();
            }
            SimpleDateFormat simpleDateFormat = calendarFormatter;
            synchronized (simpleDateFormat) {
                calendarFormatter.setTimeZone(((Calendar)c).getTimeZone());
                long beforeTime = c.getTimeInMillis();
                long currentTime = 0L;
                currentTime = beforeTime - (long)offset;
                c.setTimeInMillis(currentTime);
                this.setCreated(calendarFormatter.format(c.getTime()));
                if (this.timeout != null) {
                    int intTimeout;
                    try {
                        intTimeout = Integer.parseInt(this.timeout);
                    }
                    catch (NumberFormatException nfe) {
                        throw new XWSSecurityException(nfe);
                    }
                    c.setTimeInMillis(currentTime + (long)(intTimeout * 1000));
                    this.setExpires(calendarFormatter.format(c.getTime()));
                }
            }
        }
    }
}

