/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss;

import com.sun.org.apache.xml.security.Init;
import com.sun.org.apache.xpath.internal.XPathAPI;
import com.sun.xml.wss.MessageConstants;
import com.sun.xml.wss.SecurityEnvironment;
import com.sun.xml.wss.SecurityHeader;
import com.sun.xml.wss.SecurityHeaderException;
import com.sun.xml.wss.SecurityToken;
import com.sun.xml.wss.Target;
import com.sun.xml.wss.WssSoapFaultException;
import com.sun.xml.wss.XMLUtil;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.XWSSecurityRuntimeException;
import com.sun.xml.wss.configuration.UsernamePasswordRequirement;
import java.io.IOException;
import java.io.OutputStream;
import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Random;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.activation.DataHandler;
import javax.security.auth.Subject;
import javax.xml.namespace.QName;
import javax.xml.rpc.soap.SOAPFaultException;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class SecurableSoapMessage
extends SOAPMessage {
    private static boolean providerAdded = false;
    private static boolean strTransformAdded = false;
    private static boolean wsuIdResolverAdded = false;
    private SOAPPart soapPart;
    private SOAPEnvelope envelope;
    private String soapNamespace;
    private String soapPrefix;
    private Element nsContext;
    private HashMap namespaceMap;
    private static HashMap spSsmMap = new HashMap();
    private static Logger log = Logger.getLogger("javax.enterprise.resource.webservices.security", "com.sun.xml.wss.LogStrings");
    private SOAPElement wsseSecurity;
    private SOAPMessage soapMessage;
    private boolean faultHasBeenThrown = false;
    private SecurityEnvironment SecurityEnvironment;
    private Subject currentSubject = null;
    private Hashtable filterParameterBlock = new Hashtable();
    private Hashtable tokenCache = new Hashtable();
    private ArrayList operationsLog = new ArrayList();

    public SecurableSoapMessage(SOAPMessage soapMessage) throws XWSSecurityException {
        this.soapMessage = soapMessage;
        this.soapPart = soapMessage.getSOAPPart();
        try {
            this.envelope = this.soapPart.getEnvelope();
        }
        catch (SOAPException e) {
            log.log(Level.SEVERE, "WSS0368.soap.exception", e.getMessage());
            throw new XWSSecurityException(e);
        }
        this.soapNamespace = this.envelope.getNamespaceURI();
        this.soapPrefix = this.envelope.getPrefix();
        this.addXPathNamespace("env", this.soapNamespace);
        this.addXPathNamespace("S", this.soapNamespace);
        this.addXPathNamespace("SOAP-ENV", this.soapNamespace);
        this.addXPathNamespace("ds", "http://www.w3.org/2000/09/xmldsig#");
        this.addXPathNamespace("xenc", "http://www.w3.org/2001/04/xmlenc#");
        this.addXPathNamespace("wsse", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd");
        this.addXPathNamespace("wsu", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd");
        this.addXPathNamespace("saml", "urn:oasis:names:tc:SAML:1.0:assertion");
        log.log(Level.CONFIG, "WSS0100.createFor.creating.impl", ((Object)((Object)this)).getClass().getName());
    }

    public static SecurableSoapMessage createFor(Document domDoc) throws XWSSecurityException {
        return null;
    }

    public SOAPEnvelope getEnvelope() {
        return this.envelope;
    }

    private SOAPHeader findSoapHeader(boolean doCreate) throws XWSSecurityException {
        try {
            SOAPHeader header = this.envelope.getHeader();
            if (header != null) {
                return header;
            }
            if (doCreate) {
                return this.envelope.addHeader();
            }
        }
        catch (SOAPException e) {
            log.log(Level.SEVERE, "WSS0369.soap.exception", e.getMessage());
            throw new XWSSecurityException(e);
        }
        return null;
    }

    public SecurityHeader findWsseSecurityHeaderBlock(boolean doCreate, boolean mustUnderstand) throws XWSSecurityException {
        SOAPHeader header;
        if (this.wsseSecurity != null) {
            if (this.wsseSecurity.getParentNode() == null) {
                this.wsseSecurity = null;
            } else {
                return (SecurityHeader)this.wsseSecurity;
            }
        }
        if (null == (header = this.findSoapHeader(doCreate))) {
            return null;
        }
        NodeList headerChildNodes = header.getChildNodes();
        if (headerChildNodes != null) {
            Node currentNode = null;
            for (int i = 0; i < headerChildNodes.getLength(); ++i) {
                currentNode = headerChildNodes.item(i);
                if (!"Security".equals(currentNode.getLocalName()) || !"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd".equals(currentNode.getNamespaceURI())) continue;
                this.wsseSecurity = (SOAPElement)currentNode;
                break;
            }
        }
        if (this.wsseSecurity == null && !doCreate) {
            return null;
        }
        if (this.wsseSecurity == null && doCreate) {
            this.wsseSecurity = (SOAPElement)this.soapPart.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "wsse:Security");
            this.wsseSecurity.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:wsse", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd");
            if (mustUnderstand) {
                this.wsseSecurity.setAttributeNS(this.soapNamespace, this.soapPrefix + ":mustUnderstand", "1");
            }
        }
        XMLUtil.prependChildElement((Element)header, (Element)this.wsseSecurity, (Document)this.soapPart);
        this.wsseSecurity = new SecurityHeader(this.wsseSecurity);
        return (SecurityHeader)this.wsseSecurity;
    }

    public SecurityHeader findSecurityHeader() throws XWSSecurityException {
        return this.findWsseSecurityHeaderBlock(false, false);
    }

    public SecurityHeader findOrCreateSecurityHeader() throws XWSSecurityException {
        return this.findWsseSecurityHeaderBlock(true, true);
    }

    public void deleteSecurityHeader() {
        try {
            this.findSecurityHeader();
            if (null != this.wsseSecurity) {
                this.wsseSecurity.detachNode();
                this.wsseSecurity = null;
            }
        }
        catch (XWSSecurityException e) {
            log.log(Level.SEVERE, "WSS0370.error.deleting.secheader", e.getMessage());
        }
    }

    public void addXPathNamespace(String prefix, String nsName) {
        if (this.nsContext == null) {
            this.nsContext = this.soapPart.createElementNS(null, "namespaceContext");
            this.namespaceMap = new HashMap();
        }
        this.nsContext.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + prefix, nsName);
        this.namespaceMap.put(prefix, nsName);
    }

    public void generateSecurityHeaderException(String exceptionMessage) throws SecurityHeaderException, XWSSecurityException {
        SecurityHeaderException she = new SecurityHeaderException(exceptionMessage);
        this.generateFault(SecurableSoapMessage.newSOAPFaultException(MessageConstants.WSSE_INVALID_SECURITY, "Error while processing Security Header", she));
        throw she;
    }

    public static WssSoapFaultException newSOAPFaultException(String faultstring, Throwable th) {
        WssSoapFaultException sfe = new WssSoapFaultException(null, faultstring, null, null);
        sfe.initCause(th);
        return sfe;
    }

    public static WssSoapFaultException newSOAPFaultException(QName faultCode, String faultstring, Throwable th) {
        WssSoapFaultException sfe = new WssSoapFaultException(faultCode, faultstring, null, null);
        sfe.initCause(th);
        return sfe;
    }

    public void generateFault(SOAPFaultException sfe) throws XWSSecurityException {
        this.faultHasBeenThrown = true;
        try {
            this.deleteSecurityHeader();
            SOAPBody body = this.soapMessage.getSOAPBody();
            body.removeContents();
            QName faultCode = sfe.getFaultCode();
            Name faultCodeName = null;
            faultCodeName = faultCode == null ? SOAPFactory.newInstance().createName("Client", null, "http://schemas.xmlsoap.org/soap/envelope/") : SOAPFactory.newInstance().createName(faultCode.getLocalPart(), faultCode.getPrefix(), faultCode.getNamespaceURI());
            body.addFault(faultCodeName, sfe.getFaultString());
        }
        catch (SOAPException e) {
            log.log(Level.SEVERE, "WSS0371.error.generate.fault", e.getMessage());
            throw new XWSSecurityException(e);
        }
    }

    public void generateFault(WssSoapFaultException sfe) throws XWSSecurityException {
        this.faultHasBeenThrown = true;
        try {
            SOAPBody body = this.soapMessage.getSOAPBody();
            body.removeContents();
            QName faultCode = sfe.getFaultCode();
            Name faultCodeName = null;
            faultCodeName = faultCode == null ? SOAPFactory.newInstance().createName("Client", null, "http://schemas.xmlsoap.org/soap/envelope/") : SOAPFactory.newInstance().createName(faultCode.getLocalPart(), faultCode.getPrefix(), faultCode.getNamespaceURI());
            body.addFault(faultCodeName, sfe.getFaultString());
        }
        catch (SOAPException e) {
            log.log(Level.SEVERE, "WSS0371.error.generate.fault", e.getMessage());
            throw new XWSSecurityException(e);
        }
    }

    public boolean isInFaultState() {
        return this.faultHasBeenThrown;
    }

    public SOAPPart getSOAPPart() {
        return this.soapPart;
    }

    public SOAPBody getSOAPBody() throws SOAPException {
        return this.soapPart.getEnvelope().getBody();
    }

    public SOAPMessage getSOAPMessage() {
        return this.soapMessage;
    }

    public void setSecurityEnvironment(SecurityEnvironment domain) {
        this.SecurityEnvironment = domain;
    }

    public SecurityEnvironment getSecurityEnvironment() {
        return this.SecurityEnvironment;
    }

    public void setSubject(Subject subject) {
        this.currentSubject = subject;
    }

    public Subject getSubject() {
        return this.currentSubject;
    }

    public Object getFilterParameter(String name) {
        return this.filterParameterBlock.get(name);
    }

    public void setFilterParameter(String name, Object value) {
        this.filterParameterBlock.put(name, value);
    }

    public void setToken(String id, SecurityToken token) {
        this.tokenCache.put(id, token);
    }

    public SecurityToken getToken(String id) {
        return (SecurityToken)this.tokenCache.get(id);
    }

    public SecurityToken removeToken(String id) {
        return (SecurityToken)this.tokenCache.remove(id);
    }

    public void addAttachmentPart(AttachmentPart AttachmentPart2) {
        this.soapMessage.addAttachmentPart(AttachmentPart2);
    }

    public int countAttachments() {
        return this.soapMessage.countAttachments();
    }

    public AttachmentPart createAttachmentPart() {
        return this.soapMessage.createAttachmentPart();
    }

    public AttachmentPart createAttachmentPart(Object content, String contentType) {
        return this.soapMessage.createAttachmentPart(content, contentType);
    }

    public AttachmentPart createAttachmentPart(DataHandler dataHandler) {
        return this.soapMessage.createAttachmentPart(dataHandler);
    }

    public boolean equals(Object obj) {
        return this.soapMessage.equals(obj);
    }

    public Iterator getAttachments() {
        return this.soapMessage.getAttachments();
    }

    public Iterator getAttachments(MimeHeaders headers) {
        return this.soapMessage.getAttachments(headers);
    }

    public String getContentDescription() {
        return this.soapMessage.getContentDescription();
    }

    public MimeHeaders getMimeHeaders() {
        return this.soapMessage.getMimeHeaders();
    }

    public Object getProperty(String property) throws SOAPException {
        return this.soapMessage.getProperty(property);
    }

    public SOAPHeader getSOAPHeader() throws SOAPException {
        return this.soapMessage.getSOAPHeader();
    }

    public int hashCode() {
        return this.soapMessage.hashCode();
    }

    public void removeAllAttachments() {
        this.soapMessage.removeAllAttachments();
    }

    public boolean saveRequired() {
        return this.soapMessage.saveRequired();
    }

    public void setContentDescription(String description) {
        this.soapMessage.setContentDescription(description);
    }

    public void setProperty(String property, Object value) throws SOAPException {
        this.soapMessage.setProperty(property, value);
    }

    public String toString() {
        return this.soapMessage.toString();
    }

    public void writeTo(OutputStream out) throws SOAPException, IOException {
        this.soapMessage.writeTo(out);
    }

    public void saveChanges() throws SOAPException {
        this.soapMessage.saveChanges();
    }

    public Element getNSContext() {
        return this.nsContext;
    }

    public HashMap getNamespaceMap() {
        return this.namespaceMap;
    }

    public static void setDocMessageAssociation(Document document, SecurableSoapMessage secureMessage) {
        spSsmMap.put(document, secureMessage);
    }

    public static SecurableSoapMessage getDocMessageAssociation(Document document) {
        return (SecurableSoapMessage)((Object)spSsmMap.get(document));
    }

    public static void removeDocMessageAssociation(Document document) {
        spSsmMap.remove(document);
    }

    public static void setStrTransformAdded(boolean flag) {
        strTransformAdded = flag;
    }

    public static boolean isStrTransformAdded() {
        return strTransformAdded;
    }

    public static void setWsuIdResolverAdded(boolean flag) {
        wsuIdResolverAdded = flag;
    }

    public static boolean isWsuIdResolverAdded() {
        return wsuIdResolverAdded;
    }

    public String generateId() throws XWSSecurityException {
        Random rnd = new Random();
        long longRandom = rnd.nextLong();
        String id = "Id" + String.valueOf(longRandom);
        NodeList wsuIdElements = this.getWsuIdElements((Document)this.soapPart);
        NodeList idElements = this.getIdElements((Document)this.soapPart);
        if (!this.wsuIdIsUnique(wsuIdElements, id) || !this.idIsUnique(idElements, id)) {
            return this.generateId();
        }
        return id;
    }

    private NodeList getIdElements(Document owner) throws XWSSecurityException {
        NodeList list = null;
        String xpath = "//*[@Id]";
        try {
            list = XPathAPI.selectNodeList(owner, xpath, this.nsContext);
        }
        catch (TransformerException e) {
            log.log(Level.SEVERE, "WSS0372.error.apache.xpathAPI", e.getMessage());
            throw new XWSSecurityException(e);
        }
        return list;
    }

    private boolean idIsUnique(NodeList idElements, String id) {
        boolean result = true;
        if (idElements == null) {
            return result;
        }
        for (int i = 0; i < idElements.getLength(); ++i) {
            if (!((Element)idElements.item(i)).getAttribute("Id").equals(id)) continue;
            result = false;
        }
        return result;
    }

    public void generateWsuId(Element element) throws XWSSecurityException {
        Random rnd;
        long longRandom;
        String id;
        NodeList wsuIdElements = this.getWsuIdElements(element.getOwnerDocument());
        if (!this.wsuIdIsUnique(wsuIdElements, id = String.valueOf(longRandom = (rnd = new Random()).nextLong()))) {
            this.generateWsuId(element);
        }
        element.setAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu:Id", id);
    }

    public void generateWsuId(Element element, String id) throws XWSSecurityException {
        NodeList wsuIdElements = this.getWsuIdElements(element.getOwnerDocument());
        if (!this.wsuIdIsUnique(wsuIdElements, id)) {
            return;
        }
        element.setAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu:Id", id);
    }

    private NodeList getWsuIdElements(Document owner) throws XWSSecurityException {
        NodeList result = null;
        String xpath = "//*[@wsu:Id]";
        try {
            result = XPathAPI.selectNodeList(owner, xpath, this.nsContext);
        }
        catch (TransformerException e) {
            log.log(Level.SEVERE, "WSS0372.error.apache.xpathAPI", e.getMessage());
            throw new XWSSecurityException(e);
        }
        return result;
    }

    private boolean wsuIdIsUnique(NodeList wsuIdElements, String id) {
        boolean result = true;
        if (wsuIdElements == null) {
            return result;
        }
        for (int i = 0; i < wsuIdElements.getLength(); ++i) {
            if (!((Element)wsuIdElements.item(i)).getAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id").equals(id)) continue;
            result = false;
        }
        return result;
    }

    public SOAPElement getElementByWsuId(String id) throws XWSSecurityException {
        SOAPElement result = null;
        String xpath = "//*[@wsu:Id='" + id + "']";
        try {
            NodeList elements = XPathAPI.selectNodeList((Node)this.soapPart, xpath, this.nsContext);
            if (elements != null) {
                result = (SOAPElement)elements.item(0);
            }
        }
        catch (TransformerException e) {
            log.log(Level.SEVERE, "WSS0374.error.apache.xpathAPI", new Object[]{id, e.getMessage()});
            throw new XWSSecurityException(e);
        }
        return result;
    }

    public Element getElementById(String id) throws XWSSecurityException {
        Object result = null;
        result = this.getElementByWsuId(id);
        if (result == null) {
            NodeList elems;
            String xpath = "//*[@Id='" + id + "']";
            try {
                elems = XPathAPI.selectNodeList((Node)this.soapPart, xpath, this.nsContext);
            }
            catch (TransformerException e) {
                log.log(Level.SEVERE, "WSS0375.error.apache.xpathAPI", new Object[]{id, e.getMessage()});
                throw new XWSSecurityException(e);
            }
            for (int i = 0; i < elems.getLength(); ++i) {
                Element elem = (Element)elems.item(i);
                String namespace = elem.getNamespaceURI();
                if (!namespace.equals("http://www.w3.org/2000/09/xmldsig#") && !namespace.equals("http://www.w3.org/2001/04/xmlenc#")) continue;
                result = elem;
                break;
            }
            if (elems == null || elems.getLength() == 0) {
                throw new XWSSecurityException("No elements exist with Id/WsuId: " + id);
            }
            if (elems.getLength() > 1) {
                throw new XWSSecurityException("More than one element exists with Id/WsuId: " + id);
            }
        }
        return result;
    }

    public String getIdFromFragmentRef(String ref) {
        int start = ref.indexOf(35);
        if (start == -1) {
            return null;
        }
        return ref.substring(start + 1);
    }

    public ArrayList getOperationsLog() {
        return this.operationsLog;
    }

    public void logSignatureReferences(Set references) {
        this.operationsLog.add(new OperationsLogItem(0, references));
    }

    public void logEncryptionReferences(Set references) {
        this.operationsLog.add(new OperationsLogItem(1, references));
    }

    public void logUsernameToken(String nonce, String digest) {
        HashSet<UsernamePasswordRequirement> upReq = new HashSet<UsernamePasswordRequirement>();
        upReq.add(new UsernamePasswordRequirement(nonce, digest));
        this.operationsLog.add(new OperationsLogItem(2, upReq));
    }

    public Object getMessageParts(Target target) throws XWSSecurityException {
        Object retValue = null;
        String type = target.getType();
        String value = target.getValue();
        if (type.equals("qname")) {
            String xpath = XMLUtil.convertToXpath(value);
            NodeList targetsToCheckFor = null;
            try {
                targetsToCheckFor = XPathAPI.selectNodeList((Node)this.getSOAPPart(), xpath, this.getNSContext());
            }
            catch (TransformerException e) {
                throw new XWSSecurityRuntimeException(e);
            }
            retValue = targetsToCheckFor;
        } else if (type.equals("xpath")) {
            NodeList targetsToCheckFor = null;
            try {
                targetsToCheckFor = XPathAPI.selectNodeList((Node)this.getSOAPPart(), value, this.getNSContext());
            }
            catch (TransformerException e) {
                throw new XWSSecurityRuntimeException(e);
            }
            retValue = targetsToCheckFor;
        } else if (type.equals("uri")) {
            retValue = this.getElementById(value);
        }
        return retValue;
    }

    static {
        Init.init();
        Provider bc = Security.getProvider("BC");
        if (bc != null) {
            bc.put("Alg.Alias.Cipher.RSA/ECB/OAEPWithSHA1AndMGF1Padding", "RSA/OAEP");
        }
    }

    public static class OperationsLogItem {
        public static final int SIGNATURE = 0;
        public static final int ENCRYPTION = 1;
        public static final int USERNAMETOKEN = 2;
        private int type = 0;
        private Set references = new HashSet();

        public OperationsLogItem(int type, Set references) {
            this.type = type;
            this.references = references;
        }

        public Set getReferences() {
            return this.references;
        }

        public int getType() {
            return this.type;
        }
    }
}

