/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.security;

import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.web.security.WebSecurityManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.jacc.PolicyContextException;

public class WebSecurityManagerFactory {
    private static Logger logger = Logger.getLogger("javax.enterprise.system.core.security");
    private Map securityManagerPool = new HashMap();
    private Map CONTEXT_ID = new HashMap();
    private static WebSecurityManagerFactory webSecurityManager = null;

    private WebSecurityManagerFactory() {
    }

    public static WebSecurityManagerFactory getInstance() {
        if (webSecurityManager == null) {
            webSecurityManager = new WebSecurityManagerFactory();
        }
        return webSecurityManager;
    }

    public WebSecurityManager newWebSecurityManager(WebBundleDescriptor wbd) {
        String contextId = WebSecurityManager.getContextID(wbd);
        String appname = wbd.getApplication().getRegistrationName();
        ArrayList<String> lst = (ArrayList<String>)this.CONTEXT_ID.get(appname);
        if (lst == null) {
            lst = new ArrayList<String>();
        }
        lst.add(contextId);
        this.CONTEXT_ID.put(appname, lst);
        WebSecurityManager wsManager = null;
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "[Web-Security] Web Security:Creating WebSecurityManager for contextId = " + contextId);
        }
        if (!this.securityManagerPool.containsKey(contextId)) {
            try {
                wsManager = new WebSecurityManager(wbd);
            }
            catch (PolicyContextException e) {
                logger.log(Level.FINE, "[Web-Security] FATAl Exception. Unable to create WebSecurityManager: " + e.getMessage());
                throw new RuntimeException(e);
            }
            this.securityManagerPool.put(contextId, wsManager);
            return wsManager;
        }
        return (WebSecurityManager)this.securityManagerPool.get(contextId);
    }

    public WebSecurityManager getWebSecurityManager(String contextId) {
        return (WebSecurityManager)this.securityManagerPool.get(contextId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeWebSecurityManager(String contextId) {
        Map map = this.securityManagerPool;
        synchronized (map) {
            if (this.securityManagerPool.get(contextId) != null) {
                this.securityManagerPool.remove(contextId);
            }
        }
    }

    public String[] getAndRemoveContextIdForWebAppName(String appName) {
        List contextId = (List)this.CONTEXT_ID.get(appName);
        this.CONTEXT_ID.remove(appName);
        if (contextId == null) {
            return null;
        }
        String[] arrayContext = new String[contextId.size()];
        arrayContext = contextId.toArray(arrayContext);
        return arrayContext;
    }
}

