/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.security;

import com.sun.enterprise.security.SecurityContext;
import com.sun.enterprise.security.auth.LoginContextDriver;
import com.sun.logging.LogDomains;
import com.sun.web.security.WebPrincipal;
import java.io.IOException;
import java.security.AccessControlException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.catalina.Context;
import org.apache.catalina.Manager;
import org.apache.catalina.Session;
import org.apache.coyote.tomcat5.CoyoteRequest;
import org.apache.coyote.tomcat5.CoyoteRequestFacade;

public class WebProgrammaticLogin {
    public static final String WEBAUTH_PROGRAMMATIC = "PROGRAMMATIC";
    private static Logger logger;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static Boolean login(String user, String password, String realm, HttpServletRequest request, HttpServletResponse response) {
        Session realSession;
        CoyoteRequest req = WebProgrammaticLogin.getUnwrappedCoyoteRequest(request);
        if (req == null) {
            return false;
        }
        LoginContextDriver.login(user, password, realm);
        SecurityContext secCtx = SecurityContext.getCurrent();
        if (!$assertionsDisabled && secCtx == null) {
            throw new AssertionError();
        }
        WebPrincipal principal = new WebPrincipal(user, password, secCtx);
        req.setUserPrincipal(principal);
        req.setAuthType(WEBAUTH_PROGRAMMATIC);
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Programmatic login set principal in http request to: " + user);
        }
        if ((realSession = WebProgrammaticLogin.getSession(req)) != null) {
            realSession.setPrincipal(principal);
            realSession.setAuthType(WEBAUTH_PROGRAMMATIC);
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Programmatic login set principal in session.");
            }
        } else if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Programmatic login: No session available.");
        }
        return true;
    }

    private static CoyoteRequest getUnwrappedCoyoteRequest(HttpServletRequest request) {
        CoyoteRequest req = null;
        try {
            req = ((CoyoteRequestFacade)request).getUnwrappedCoyoteRequest();
        }
        catch (AccessControlException ex) {
            logger.log(Level.FINE, "Programmatic login faiied to get request");
        }
        return req;
    }

    public static Boolean logout(HttpServletRequest request, HttpServletResponse response) throws Exception {
        Session realSession;
        CoyoteRequest req = WebProgrammaticLogin.getUnwrappedCoyoteRequest(request);
        if (req == null) {
            return false;
        }
        LoginContextDriver.logout();
        req.setUserPrincipal(null);
        req.setAuthType(null);
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Programmatic logout removed principal from request.");
        }
        if ((realSession = WebProgrammaticLogin.getSession(req)) != null) {
            realSession.setPrincipal(null);
            realSession.setAuthType(null);
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Programmatic logout removed principal from session.");
            }
        }
        return true;
    }

    private static Session getSession(CoyoteRequest request) {
        Manager manager;
        Context context;
        HttpSession session = request.getSession(false);
        if (session != null && (context = request.getContext()) != null && (manager = context.getManager()) != null) {
            String sessionId = session.getId();
            try {
                Session realSession = manager.findSession(sessionId);
                return realSession;
            }
            catch (IOException e) {
                return null;
            }
        }
        return null;
    }

    static {
        $assertionsDisabled = !WebProgrammaticLogin.class.desiredAssertionStatus();
        logger = LogDomains.getLogger("javax.enterprise.system.core.security");
    }
}

