/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.security.utils;

import java.io.IOException;
import java.io.StringReader;

public class RFC2253Parser {
    static boolean _TOXML = true;
    static int counter = 0;

    public static String rfc2253toXMLdsig(String string) {
        _TOXML = true;
        String string2 = RFC2253Parser.normalize(string);
        return RFC2253Parser.rfctoXML(string2);
    }

    public static String xmldsigtoRFC2253(String string) {
        _TOXML = false;
        String string2 = RFC2253Parser.normalize(string);
        return RFC2253Parser.xmltoRFC(string2);
    }

    public static String normalize(String string) {
        if (string == null || string.equals("")) {
            return "";
        }
        try {
            int n;
            String string2 = RFC2253Parser.semicolonToComma(string);
            StringBuffer stringBuffer = new StringBuffer();
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            while ((n = string2.indexOf(",", n4)) >= 0) {
                if (n > 0 && string2.charAt(n - 1) != '\\' && (n3 += RFC2253Parser.countQuotes(string2, n4, n)) % 2 != 1) {
                    stringBuffer.append(RFC2253Parser.parseRDN(string2.substring(n2, n).trim()) + ",");
                    n2 = n + 1;
                    n3 = 0;
                }
                n4 = n + 1;
            }
            stringBuffer.append(RFC2253Parser.parseRDN(RFC2253Parser.trim(string2.substring(n2))));
            return stringBuffer.toString();
        }
        catch (IOException iOException) {
            return string;
        }
    }

    static String parseRDN(String string) throws IOException {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while ((n = string.indexOf("+", n4)) >= 0) {
            if (n > 0 && string.charAt(n - 1) != '\\' && (n3 += RFC2253Parser.countQuotes(string, n4, n)) % 2 != 1) {
                stringBuffer.append(RFC2253Parser.parseATAV(RFC2253Parser.trim(string.substring(n2, n))) + "+");
                n2 = n + 1;
                n3 = 0;
            }
            n4 = n + 1;
        }
        stringBuffer.append(RFC2253Parser.parseATAV(RFC2253Parser.trim(string.substring(n2))));
        return stringBuffer.toString();
    }

    static String parseATAV(String string) throws IOException {
        int n = string.indexOf("=");
        if (n == -1 || n > 0 && string.charAt(n - 1) == '\\') {
            return string;
        }
        String string2 = RFC2253Parser.normalizeAT(string.substring(0, n));
        String string3 = RFC2253Parser.normalizeV(string.substring(n + 1));
        return string2 + "=" + string3;
    }

    static String normalizeAT(String string) {
        String string2 = string.toUpperCase().trim();
        if (string2.startsWith("OID")) {
            string2 = string2.substring(3);
        }
        return string2;
    }

    static String normalizeV(String string) throws IOException {
        String string2 = RFC2253Parser.trim(string);
        if (string2.startsWith("\"")) {
            StringBuffer stringBuffer = new StringBuffer();
            StringReader stringReader = new StringReader(string2.substring(1, string2.length() - 1));
            int n = 0;
            while ((n = stringReader.read()) > -1) {
                char c = (char)n;
                if (c == ',' || c == '=' || c == '+' || c == '<' || c == '>' || c == '#' || c == ';') {
                    stringBuffer.append('\\');
                }
                stringBuffer.append(c);
            }
            string2 = RFC2253Parser.trim(stringBuffer.toString());
        }
        if (_TOXML) {
            if (string2.startsWith("#")) {
                string2 = '\\' + string2;
            }
        } else if (string2.startsWith("\\#")) {
            string2 = string2.substring(1);
        }
        return string2;
    }

    static String rfctoXML(String string) {
        try {
            String string2 = RFC2253Parser.changeLess32toXML(string);
            return RFC2253Parser.changeWStoXML(string2);
        }
        catch (Exception exception) {
            return string;
        }
    }

    static String xmltoRFC(String string) {
        try {
            String string2 = RFC2253Parser.changeLess32toRFC(string);
            return RFC2253Parser.changeWStoRFC(string2);
        }
        catch (Exception exception) {
            return string;
        }
    }

    static String changeLess32toRFC(String string) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        StringReader stringReader = new StringReader(string);
        int n = 0;
        while ((n = stringReader.read()) > -1) {
            char c = (char)n;
            if (c == '\\') {
                stringBuffer.append(c);
                char c2 = (char)stringReader.read();
                char c3 = (char)stringReader.read();
                if ((c2 >= '0' && c2 <= '9' || c2 >= 'A' && c2 <= 'F' || c2 >= 'a' && c2 <= 'f') && (c3 >= '0' && c3 <= '9' || c3 >= 'A' && c3 <= 'F' || c3 >= 'a' && c3 <= 'f')) {
                    char c4 = (char)Byte.parseByte("" + c2 + c3, 16);
                    stringBuffer.append(c4);
                    continue;
                }
                stringBuffer.append(c2);
                stringBuffer.append(c3);
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    static String changeLess32toXML(String string) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        StringReader stringReader = new StringReader(string);
        int n = 0;
        while ((n = stringReader.read()) > -1) {
            if (n < 32) {
                stringBuffer.append('\\');
                stringBuffer.append(Integer.toHexString(n));
                continue;
            }
            stringBuffer.append((char)n);
        }
        return stringBuffer.toString();
    }

    static String changeWStoXML(String string) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        StringReader stringReader = new StringReader(string);
        int n = 0;
        while ((n = stringReader.read()) > -1) {
            char c = (char)n;
            if (c == '\\') {
                char c2 = (char)stringReader.read();
                if (c2 == ' ') {
                    stringBuffer.append('\\');
                    String string2 = "20";
                    stringBuffer.append(string2);
                    continue;
                }
                stringBuffer.append('\\');
                stringBuffer.append(c2);
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    static String changeWStoRFC(String string) throws IOException {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        int n3 = 0;
        while ((n = string.indexOf("\\20", n3)) >= 0) {
            stringBuffer.append(RFC2253Parser.trim(string.substring(n2, n)) + "\\ ");
            n2 = n + 3;
            n3 = n + 3;
        }
        stringBuffer.append(string.substring(n2));
        return stringBuffer.toString();
    }

    static String semicolonToComma(String string) {
        return RFC2253Parser.removeWSandReplace(string, ";", ",");
    }

    static String removeWhiteSpace(String string, String string2) {
        return RFC2253Parser.removeWSandReplace(string, string2, string2);
    }

    static String removeWSandReplace(String string, String string2, String string3) {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while ((n = string.indexOf(string2, n4)) >= 0) {
            if (n > 0 && string.charAt(n - 1) != '\\' && (n3 += RFC2253Parser.countQuotes(string, n4, n)) % 2 != 1) {
                stringBuffer.append(RFC2253Parser.trim(string.substring(n2, n)) + string3);
                n2 = n + 1;
                n3 = 0;
            }
            n4 = n + 1;
        }
        stringBuffer.append(RFC2253Parser.trim(string.substring(n2)));
        return stringBuffer.toString();
    }

    private static int countQuotes(String string, int n, int n2) {
        int n3 = 0;
        for (int i = n; i < n2; ++i) {
            if (string.charAt(i) != '\"') continue;
            ++n3;
        }
        return n3;
    }

    static String trim(String string) {
        String string2 = string.trim();
        int n = string.indexOf(string2.substring(0)) + string2.length();
        if (string.length() > n && string2.endsWith("\\") && !string2.endsWith("\\\\") && string.charAt(n) == ' ') {
            string2 = string2 + " ";
        }
        return string2;
    }

    public static void main(String[] stringArray) throws Exception {
        RFC2253Parser.testToXML("CN=\"Steve, Kille\",  O=Isode Limited, C=GB");
        RFC2253Parser.testToXML("CN=Steve Kille    ,   O=Isode Limited,C=GB");
        RFC2253Parser.testToXML("\\ OU=Sales+CN=J. Smith,O=Widget Inc.,C=US\\ \\ ");
        RFC2253Parser.testToXML("CN=L. Eagle,O=Sue\\, Grabbit and Runn,C=GB");
        RFC2253Parser.testToXML("CN=Before\\0DAfter,O=Test,C=GB");
        RFC2253Parser.testToXML("CN=\"L. Eagle,O=Sue, = + < > # ;Grabbit and Runn\",C=GB");
        RFC2253Parser.testToXML("1.3.6.1.4.1.1466.0=#04024869,O=Test,C=GB");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('L');
        stringBuffer.append('u');
        stringBuffer.append('\uc48d');
        stringBuffer.append('i');
        stringBuffer.append('\uc487');
        String string = "SN=" + stringBuffer.toString();
        RFC2253Parser.testToXML(string);
        RFC2253Parser.testToRFC("CN=\"Steve, Kille\",  O=Isode Limited, C=GB");
        RFC2253Parser.testToRFC("CN=Steve Kille    ,   O=Isode Limited,C=GB");
        RFC2253Parser.testToRFC("\\20OU=Sales+CN=J. Smith,O=Widget Inc.,C=US\\20\\20 ");
        RFC2253Parser.testToRFC("CN=L. Eagle,O=Sue\\, Grabbit and Runn,C=GB");
        RFC2253Parser.testToRFC("CN=Before\\12After,O=Test,C=GB");
        RFC2253Parser.testToRFC("CN=\"L. Eagle,O=Sue, = + < > # ;Grabbit and Runn\",C=GB");
        RFC2253Parser.testToRFC("1.3.6.1.4.1.1466.0=\\#04024869,O=Test,C=GB");
        stringBuffer = new StringBuffer();
        stringBuffer.append('L');
        stringBuffer.append('u');
        stringBuffer.append('\uc48d');
        stringBuffer.append('i');
        stringBuffer.append('\uc487');
        string = "SN=" + stringBuffer.toString();
        RFC2253Parser.testToRFC(string);
    }

    static void testToXML(String string) {
        System.out.println("start " + counter++ + ": " + string);
        System.out.println("         " + RFC2253Parser.rfc2253toXMLdsig(string));
        System.out.println("");
    }

    static void testToRFC(String string) {
        System.out.println("start " + counter++ + ": " + string);
        System.out.println("         " + RFC2253Parser.xmldsigtoRFC2253(string));
        System.out.println("");
    }
}

