/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.security.keys.storage.implementations;

import com.sun.org.apache.xml.security.keys.content.x509.XMLX509SKI;
import com.sun.org.apache.xml.security.keys.storage.StorageResolverException;
import com.sun.org.apache.xml.security.keys.storage.StorageResolverSpi;
import com.sun.org.apache.xml.security.utils.Base64;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CertsInFilesystemDirectoryResolver
extends StorageResolverSpi {
    static Logger log = Logger.getLogger((class$com$sun$org$apache$xml$security$keys$storage$implementations$CertsInFilesystemDirectoryResolver == null ? (class$com$sun$org$apache$xml$security$keys$storage$implementations$CertsInFilesystemDirectoryResolver = CertsInFilesystemDirectoryResolver.class$("com.sun.org.apache.xml.security.keys.storage.implementations.CertsInFilesystemDirectoryResolver")) : class$com$sun$org$apache$xml$security$keys$storage$implementations$CertsInFilesystemDirectoryResolver).getName());
    String _merlinsCertificatesDir = null;
    private Vector _certs = new Vector();
    Iterator _iterator = null;
    static /* synthetic */ Class class$com$sun$org$apache$xml$security$keys$storage$implementations$CertsInFilesystemDirectoryResolver;

    public CertsInFilesystemDirectoryResolver(String string) throws StorageResolverException {
        this._merlinsCertificatesDir = string;
        this.readCertsFromHarddrive();
        this._iterator = new FilesystemIterator(this._certs);
    }

    private void readCertsFromHarddrive() throws StorageResolverException {
        File file = new File(this._merlinsCertificatesDir);
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray = file.list();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (!string.endsWith(".crt")) continue;
            arrayList.add(stringArray[i]);
        }
        CertificateFactory certificateFactory = null;
        try {
            certificateFactory = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException certificateException) {
            throw new StorageResolverException("empty", certificateException);
        }
        if (certificateFactory == null) {
            throw new StorageResolverException("empty");
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            String string = file.getAbsolutePath() + File.separator + (String)arrayList.get(i);
            File file2 = new File(string);
            boolean bl = false;
            String string2 = null;
            try {
                FileInputStream fileInputStream = new FileInputStream(file2);
                X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(fileInputStream);
                fileInputStream.close();
                x509Certificate.checkValidity();
                this._certs.add(x509Certificate);
                string2 = x509Certificate.getSubjectDN().getName();
                bl = true;
            }
            catch (FileNotFoundException fileNotFoundException) {
                log.log(Level.FINE, "Could not add certificate from file " + string, fileNotFoundException);
            }
            catch (IOException iOException) {
                log.log(Level.FINE, "Could not add certificate from file " + string, iOException);
            }
            catch (CertificateNotYetValidException certificateNotYetValidException) {
                log.log(Level.FINE, "Could not add certificate from file " + string, certificateNotYetValidException);
            }
            catch (CertificateExpiredException certificateExpiredException) {
                log.log(Level.FINE, "Could not add certificate from file " + string, certificateExpiredException);
            }
            catch (CertificateException certificateException) {
                log.log(Level.FINE, "Could not add certificate from file " + string, certificateException);
            }
            if (!bl) continue;
            log.log(Level.FINE, "Added certificate: " + string2);
        }
    }

    public Iterator getIterator() {
        return this._iterator;
    }

    public static void main(String[] stringArray) throws Exception {
        CertsInFilesystemDirectoryResolver certsInFilesystemDirectoryResolver = new CertsInFilesystemDirectoryResolver("data/ie/baltimore/merlin-examples/merlin-xmldsig-eighteen/certs");
        Iterator iterator = certsInFilesystemDirectoryResolver.getIterator();
        while (iterator.hasNext()) {
            X509Certificate x509Certificate = (X509Certificate)iterator.next();
            byte[] byArray = XMLX509SKI.getSKIBytesFromCert(x509Certificate);
            System.out.println();
            System.out.println("Base64(SKI())=                 \"" + Base64.encode(byArray) + "\"");
            System.out.println("cert.getSerialNumber()=        \"" + x509Certificate.getSerialNumber().toString() + "\"");
            System.out.println("cert.getSubjectDN().getName()= \"" + x509Certificate.getSubjectDN().getName() + "\"");
            System.out.println("cert.getIssuerDN().getName()=  \"" + x509Certificate.getIssuerDN().getName() + "\"");
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class FilesystemIterator
    implements Iterator {
        Vector _certs = null;
        int _i;

        public FilesystemIterator(Vector vector) throws StorageResolverException {
            this._certs = vector;
            this._i = 0;
        }

        public boolean hasNext() {
            return this._i < this._certs.size();
        }

        public Object next() {
            return this._certs.elementAt(this._i++);
        }

        public void remove() {
            throw new UnsupportedOperationException("Can't remove keys from KeyStore");
        }
    }
}

