/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.j2se.MOAgents;

import com.sun.management.j2se.MOAgents.DefaultEmmaAgent;
import com.sun.management.j2se.MOAgents.MOFactoryListener;
import com.sun.management.j2se.MOAgents.ManagedObjectAgent;
import com.sun.management.j2se.MOAgents.ManagedObjectClient;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public class MOAgentFactory {
    private static final String DEFAULT_DOMAIN_NAME = "Java";
    private static final int EMMA_RI_DEFAULT = 1;
    private static final int J2EE_RI_DEFAULT = 2;
    public static final String EMMA_AGENT = "com.sun.management.j2se.MOAgents.JDMKAgentImpl";
    public static final String EMMA_CLIENT = "com.sun.management.j2se.MOAgents.JDMKClientImpl";
    public static final String J2EE_RI_AGENT = "com.sun.management.j2se.MOAgents.J2EEIIOPAgentImpl";
    public static final String J2EE_RI_CLIENT = "com.sun.management.j2se.MOAgents.J2EEMEJBClientImpl";
    public static final String JINI_AGENT = "com.sun.management.j2se.MOAgents.JiniAgentImpl";
    public static final String JINI_CLIENT = "com.sun.management.j2se.MOAgents.JiniClientImpl";
    static String defaultAgent;
    static String defaultClient;
    static boolean agentInitialized;
    static boolean clientInitialized;
    static ManagedObjectAgent agent;
    static ManagedObjectClient clientAgent;
    static int AGENT;
    static int CLIENT;
    public static final int RMI = 1;
    public static final int RMI_IIOP = 2;
    public static final int HTTP = 3;
    static String defaultDomainName;
    private static boolean echoinit;
    private static boolean debugging;
    private static boolean gotID;
    private static String uID;
    static boolean proxyMBeans;
    static boolean serverSet;

    private static void staticinit(int type) {
        if (type == AGENT && agentInitialized) {
            return;
        }
        if (type == CLIENT && clientInitialized) {
            return;
        }
        try {
            defaultAgent = System.getProperty("com.sun.management.j2se.MOAgents.EmmaAgent", defaultAgent);
            defaultClient = System.getProperty("com.sun.management.j2se.MOAgents.EmmaClient", defaultClient);
            if (!proxyMBeans) {
                String s = System.getProperty("com.sun.management.j2se.MOAgents.proxyNonEmmaBeans", "false");
                proxyMBeans = Boolean.getBoolean("com.sun.management.j2se.MOAgents.proxyNonEmmaBeans");
            }
        }
        catch (Exception e) {
            System.err.println(e);
            e.printStackTrace();
        }
        MOAgentFactory.echo("--->DefaultAgent after getProperty is:" + defaultAgent);
        try {
            Class<?> agentClass;
            if (type == AGENT) {
                agentClass = Class.forName(defaultAgent);
                agent = (ManagedObjectAgent)agentClass.newInstance();
                agentInitialized = true;
            }
            if (type == CLIENT) {
                agentClass = Class.forName(defaultClient);
                clientAgent = (ManagedObjectClient)agentClass.newInstance();
                clientInitialized = true;
            }
        }
        catch (Exception e) {
            System.err.println(e);
            e.printStackTrace();
        }
    }

    private MOAgentFactory() {
    }

    public static ManagedObjectAgent getAgent() {
        MOAgentFactory.staticinit(AGENT);
        return agent;
    }

    public static ManagedObjectClient getClientAgent() {
        MOAgentFactory.staticinit(CLIENT);
        return clientAgent;
    }

    public static void setAgents(ManagedObjectAgent m, ManagedObjectClient c) throws SecurityException {
        if (agentInitialized) {
            System.err.println("Can not alter agent type after first retrieval of the agent");
            new Throwable().printStackTrace();
            return;
        }
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPropertiesAccess();
        }
        agent = m;
        defaultAgent = m.getClass().getName();
        clientAgent = c;
        defaultAgent = m.getClass().getName();
    }

    public static void setAgents(String defAgent, String defClient) throws SecurityException {
        if (agentInitialized) {
            System.err.println("Can not alter agent type after first retrieval of the agent");
            new Throwable().printStackTrace();
            return;
        }
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPropertiesAccess();
        }
        defaultAgent = new String(defAgent);
        defaultClient = new String(defClient);
    }

    public static String getDefaultDomainName() {
        return new String(defaultDomainName);
    }

    public static void setDefaultDomainName(String s) {
        defaultDomainName = new String(s);
    }

    public static void advertiseMBeans() {
        proxyMBeans = true;
        MOAgentFactory.getAgent();
    }

    public static void echo(String out) {
        if (!echoinit) {
            try {
                String s = System.getProperty("com.sun.management.j2se.MOAgents.debug", "false");
                if (s.equalsIgnoreCase("true")) {
                    debugging = true;
                }
            }
            catch (Exception e) {
                System.out.println("Non-Fatal exception occurred when attempting to access debug flag");
                e.printStackTrace();
            }
        }
        if (debugging) {
            System.out.println(out);
        }
    }

    static String getUniqueID(MBeanServer server) {
        if (gotID) {
            return uID;
        }
        try {
            ObjectName objName = new ObjectName("JMImplementation:type=MBeanServerDelegate");
            uID = new String((String)server.getAttribute(objName, "MBeanServerId"));
            gotID = true;
            return uID;
        }
        catch (Exception e) {
            System.out.println("Cannot ascertain MBeanServerID " + e);
            return null;
        }
    }

    static void setMBeanServer(MBeanServer s) {
        if (serverSet) {
            return;
        }
        if (proxyMBeans) {
            try {
                MOFactoryListener listener = new MOFactoryListener(s);
            }
            catch (Exception e) {
                System.out.println("Cannot Create Factorty Notification Listener " + e);
                e.printStackTrace();
                return;
            }
            serverSet = true;
        }
    }

    public static boolean isEmmaAgent(ObjectName objname) {
        String objectType = objname.getKeyProperty("objectType");
        String instanceID = objname.getKeyProperty("instanceID");
        String jvmID = objname.getKeyProperty("jvmID");
        String domainName = objname.getKeyProperty("domainName");
        return objectType != null && instanceID != null && jvmID != null && domainName != null;
    }

    static {
        DEFAULT_DOMAIN_NAME = DEFAULT_DOMAIN_NAME;
        EMMA_RI_DEFAULT = 1;
        J2EE_RI_DEFAULT = 2;
        EMMA_AGENT = EMMA_AGENT;
        EMMA_CLIENT = EMMA_CLIENT;
        J2EE_RI_AGENT = J2EE_RI_AGENT;
        J2EE_RI_CLIENT = J2EE_RI_CLIENT;
        JINI_AGENT = JINI_AGENT;
        JINI_CLIENT = JINI_CLIENT;
        defaultAgent = DefaultEmmaAgent.getAgent();
        defaultClient = DefaultEmmaAgent.getClient();
        agentInitialized = false;
        clientInitialized = false;
        AGENT = 1;
        CLIENT = 2;
        RMI = 1;
        RMI_IIOP = 2;
        HTTP = 3;
        defaultDomainName = DEFAULT_DOMAIN_NAME;
        echoinit = false;
        debugging = false;
        gotID = false;
        proxyMBeans = false;
        serverSet = false;
    }
}

