/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jts.jta;

import com.sun.jts.CosTransactions.Configuration;
import com.sun.jts.CosTransactions.ControlImpl;
import com.sun.jts.CosTransactions.GlobalTID;
import com.sun.jts.jta.NativeXAResource;
import com.sun.jts.jta.SynchronizationImpl;
import com.sun.jts.jta.TransactionImpl;
import com.sun.jts.jtsxa.OTSResourceImpl;
import com.sun.jts.jtsxa.Utility;
import com.sun.jts.jtsxa.XID;
import com.sun.logging.LogDomains;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.omg.CORBA.TRANSACTION_ROLLEDBACK;
import org.omg.CosTransactions.Control;
import org.omg.CosTransactions.Inactive;
import org.omg.CosTransactions.Unavailable;

public class TransactionState {
    private static final int NOT_EXIST = -1;
    private static final int ASSOCIATED = 0;
    private static final int NOT_ASSOCIATED = 1;
    private static final int ASSOCIATION_SUSPENDED = 2;
    private static final int FAILED = 3;
    private static final int ROLLING_BACK = 4;
    private Hashtable resourceStates = new Hashtable();
    private Hashtable resourceList = new Hashtable();
    private Set seenXids = new HashSet();
    private Vector factories = new Vector();
    private SynchronizationImpl syncImpl;
    private GlobalTID gtid;
    private TransactionImpl tran;
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.core.transaction");
    public static boolean debug = false;

    public TransactionState(GlobalTID gtid, TransactionImpl tran) {
        this.gtid = gtid;
        this.tran = tran;
    }

    public synchronized void beforeCompletion() {
        boolean exceptionThrown = false;
        XAResource res = null;
        Enumeration e = this.resourceStates.keys();
        block8: while (e.hasMoreElements()) {
            try {
                res = (XAResource)e.nextElement();
                int XAState = this.getXAState(res);
                switch (XAState) {
                    case 1: 
                    case 3: {
                        continue block8;
                    }
                    case 0: 
                    case 2: {
                        Xid xid = (Xid)this.resourceList.get(res);
                        res.end(xid, 0x4000000);
                        this.setXAState(res, 1);
                        continue block8;
                    }
                }
                throw new IllegalStateException("Wrong XA State: " + XAState);
            }
            catch (Exception ex) {
                this.setXAState(res, 3);
                _logger.log(Level.WARNING, "jts.delist_exception", ex);
                exceptionThrown = true;
            }
        }
        if (exceptionThrown) {
            try {
                this.tran.setRollbackOnly();
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
    }

    public synchronized void rollback(XAResource res) throws IllegalStateException, XAException {
        Xid xid = (Xid)this.resourceList.get(res);
        TransactionState.assert_prejdk14(xid != null);
        int XAState = this.getXAState(res);
        switch (XAState) {
            case 1: 
            case 3: {
                res.rollback(xid);
                break;
            }
            case 2: {
                res.end(xid, 0x4000000);
                this.setXAState(res, 1);
                res.rollback(xid);
                break;
            }
            case 0: {
                res.end(xid, 0x4000000);
                this.setXAState(res, 1);
                res.rollback(xid);
                break;
            }
            default: {
                throw new IllegalStateException("Wrong XAState: " + XAState);
            }
        }
    }

    private Xid computeXid(XAResource res, Control control) throws Inactive, Unavailable, XAException {
        int size = this.factories.size();
        for (int i = 0; i < size; ++i) {
            XAResource fac = (XAResource)this.factories.elementAt(i);
            if (!res.isSameRM(fac)) continue;
            Xid xid = (Xid)this.resourceList.get(fac);
            return xid;
        }
        XID xid = Configuration.isLocalFactory() ? Utility.getXID(((ControlImpl)control).get_localCoordinator()) : Utility.getXID(control.get_coordinator());
        this.factories.addElement(res);
        byte[] branchid = TransactionState.parseSize(size);
        byte[] sname = Configuration.getServerNameByteArray();
        byte[] branch = new byte[sname.length + 1 + branchid.length];
        System.arraycopy(sname, 0, branch, 0, sname.length);
        branch[sname.length] = 44;
        System.arraycopy(branchid, 0, branch, sname.length + 1, branchid.length);
        xid.setBranchQualifier(branch);
        return xid;
    }

    public synchronized void startAssociation(XAResource res, Control control, int status) throws XAException, SystemException, IllegalStateException, RollbackException {
        try {
            Xid xid = null;
            boolean newResource = false;
            if (this.resourceList.get(res) == null) {
                if (status != 0) {
                    throw new RollbackException();
                }
                newResource = true;
                xid = this.computeXid(res, control);
                if (!this.seenXids.contains(xid)) {
                    OTSResourceImpl ref = new OTSResourceImpl(xid, res, this);
                    if (Configuration.isLocalFactory()) {
                        ((ControlImpl)control).get_localCoordinator().register_resource(ref);
                    } else {
                        control.get_coordinator().register_resource(ref);
                    }
                }
                this.resourceList.put(res, xid);
            } else {
                xid = (Xid)this.resourceList.get(res);
            }
            int XAState = this.getXAState(res);
            if (!this.seenXids.contains(xid)) {
                this.seenXids.add(xid);
                res.start(xid, 0);
                this.setXAState(res, 0);
            } else {
                switch (XAState) {
                    case -1: 
                    case 1: {
                        res.start(xid, 0x200000);
                        this.setXAState(res, 0);
                        break;
                    }
                    case 2: {
                        res.start(xid, 0x8000000);
                        this.setXAState(res, 0);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Wrong XAState: " + XAState);
                    }
                }
            }
            if (res instanceof NativeXAResource && newResource) {
                ((NativeXAResource)res).enlistConnectionInXA();
            }
        }
        catch (XAException ex) {
            this.setXAState(res, 3);
            throw ex;
        }
        catch (Inactive ex) {
            _logger.log(Level.WARNING, "jts.transaction_inactive", (Throwable)((Object)ex));
            throw new SystemException();
        }
        catch (Unavailable ex) {
            _logger.log(Level.WARNING, "jts.object_unavailable", (Throwable)((Object)ex));
            throw new SystemException();
        }
    }

    public synchronized void endAssociation(XAResource xares, int flags) throws XAException, IllegalStateException {
        try {
            Xid xid = (Xid)this.resourceList.get(xares);
            TransactionState.assert_prejdk14(xid != null);
            int XAState = this.getXAState(xares);
            switch (XAState) {
                case 0: {
                    if ((flags & 0x4000000) != 0) {
                        xares.end(xid, 0x4000000);
                        this.setXAState(xares, 1);
                        break;
                    }
                    if ((flags & 0x2000000) != 0) {
                        xares.end(xid, 0x2000000);
                        this.setXAState(xares, 2);
                        break;
                    }
                    xares.end(xid, 0x20000000);
                    this.setXAState(xares, 3);
                    break;
                }
                case 4: {
                    xares.end(xid, 0x4000000);
                    this.setXAState(xares, 1);
                    xares.rollback(xid);
                    break;
                }
                case 2: {
                    if ((flags & 0x4000000) != 0) {
                        xares.end(xid, 0x4000000);
                        this.setXAState(xares, 1);
                        break;
                    }
                    if ((flags & 0x2000000) != 0) {
                        throw new IllegalStateException("Wrong XAState: " + XAState);
                    }
                    xares.end(xid, 0x20000000);
                    this.setXAState(xares, 3);
                    break;
                }
                default: {
                    throw new IllegalStateException("Wrong XAState: " + XAState);
                }
            }
        }
        catch (XAException ex) {
            this.setXAState(xares, 3);
            throw ex;
        }
    }

    public synchronized void registerSynchronization(Synchronization sync, Control control) throws RollbackException, IllegalStateException, SystemException {
        try {
            if (this.syncImpl == null) {
                this.syncImpl = new SynchronizationImpl(this);
                if (Configuration.isLocalFactory()) {
                    ((ControlImpl)control).get_localCoordinator().register_synchronization(this.syncImpl);
                } else {
                    control.get_coordinator().register_synchronization(this.syncImpl);
                }
            }
            this.syncImpl.addSynchronization(sync);
        }
        catch (TRANSACTION_ROLLEDBACK ex) {
            throw new RollbackException();
        }
        catch (Unavailable ex) {
            throw new SystemException();
        }
        catch (Inactive ex) {
            throw new IllegalStateException();
        }
        catch (Exception ex) {
            throw new SystemException();
        }
    }

    private void setXAState(XAResource res, int state) {
        if (debug) {
            int oldValue = this.getXAState(res);
            _logger.log(Level.FINE, "transaction id : " + this.gtid);
            _logger.log(Level.FINE, "res: " + res + "," + oldValue + "," + state);
        }
        this.resourceStates.put(res, new Integer(state));
    }

    private int getXAState(XAResource res) {
        Integer result = (Integer)this.resourceStates.get(res);
        if (result == null) {
            return -1;
        }
        return result;
    }

    public Enumeration listXAResources() {
        return this.resourceList.keys();
    }

    public boolean containsXAResource(XAResource res) {
        return this.resourceList.containsKey(res);
    }

    private static void assert_prejdk14(boolean value) {
        if (!value) {
            Exception e = new Exception();
            _logger.log(Level.WARNING, "jts.assert", e);
        }
    }

    private static byte[] parseSize(int size) {
        int j = 9;
        byte[] res = new byte[10];
        if (size == 0) {
            res[j--] = 0;
        }
        while (size > 0) {
            res[j--] = (byte)(size % 10);
            size /= 10;
        }
        int len = 9 - j;
        byte[] result = new byte[len];
        System.arraycopy(res, j + 1, result, 0, len);
        return result;
    }
}

