/*
 * Decompiled with CFR 0.152.
 */
package com.sun.gjc.spi;

import com.sun.enterprise.util.i18n.StringManager;
import com.sun.gjc.common.DataSourceObjectBuilder;
import com.sun.gjc.spi.ConnectionHolder;
import com.sun.gjc.spi.LocalTransaction;
import com.sun.gjc.spi.ManagedConnectionFactory;
import com.sun.gjc.spi.ManagedConnectionMetaData;
import com.sun.gjc.spi.XAResourceImpl;
import com.sun.logging.LogDomains;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.resource.NotSupportedException;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionEvent;
import javax.resource.spi.ConnectionEventListener;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.security.PasswordCredential;
import javax.security.auth.Subject;
import javax.sql.PooledConnection;
import javax.sql.XAConnection;
import javax.transaction.xa.XAResource;

public class ManagedConnection
implements javax.resource.spi.ManagedConnection {
    public static final int ISNOTAPOOLEDCONNECTION = 0;
    public static final int ISPOOLEDCONNECTION = 1;
    public static final int ISXACONNECTION = 2;
    private boolean isDestroyed = false;
    private boolean isUsable = true;
    private int connectionCount = 0;
    private int connectionType = 0;
    private PooledConnection pc = null;
    private Connection actualConnection = null;
    private Hashtable connectionHandles;
    private PrintWriter logWriter;
    private PasswordCredential passwdCredential;
    private javax.resource.spi.ManagedConnectionFactory mcf = null;
    private XAResource xar = null;
    private int isolationLevelWhenCleaned;
    private boolean isClean = false;
    private boolean transactionInProgress = false;
    private ConnectionEventListener listener = null;
    private ConnectionEvent ce = null;
    private static Logger _logger = LogDomains.getLogger("javax.enterprise.resource.resourceadapter");
    private StringManager localStrings = StringManager.getManager(DataSourceObjectBuilder.class);

    public ManagedConnection(PooledConnection pooledConn, Connection sqlConn, PasswordCredential passwdCred, javax.resource.spi.ManagedConnectionFactory mcf) throws ResourceException {
        if (pooledConn == null && sqlConn == null) {
            String i18nMsg = this.localStrings.getString("jdbc.conn_obj_null");
            throw new ResourceException(i18nMsg);
        }
        if (this.connectionType == 0) {
            this.actualConnection = sqlConn;
        }
        this.pc = pooledConn;
        this.connectionHandles = new Hashtable();
        this.passwdCredential = passwdCred;
        this.mcf = mcf;
        if (this.passwdCredential != null && !this.mcf.equals(this.passwdCredential.getManagedConnectionFactory())) {
            String i18nMsg = this.localStrings.getString("jdbc.mc_construct_err");
            throw new ResourceException(i18nMsg);
        }
        this.logWriter = mcf.getLogWriter();
        this.ce = new ConnectionEvent((javax.resource.spi.ManagedConnection)this, 1);
    }

    public void addConnectionEventListener(ConnectionEventListener listener) {
        this.listener = listener;
    }

    public void associateConnection(Object connection) throws ResourceException {
        if (this.logWriter != null) {
            this.logWriter.println("In associateConnection");
        }
        this.checkIfValid();
        if (connection == null) {
            String i18nMsg = this.localStrings.getString("jdbc.conn_handle_null");
            throw new ResourceException(i18nMsg);
        }
        ConnectionHolder ch = (ConnectionHolder)connection;
        ManagedConnection mc = ch.getManagedConnection();
        this.isClean = false;
        ch.associateConnection(this.actualConnection, this);
        ch.setActive(true);
        this.incrementCount();
        mc.decrementCount();
    }

    public void cleanup() throws ResourceException {
        if (this.logWriter != null) {
            this.logWriter.println("In cleanup");
        }
        this.checkIfValid();
        if (this.connectionType == 0) {
            try {
                this.isolationLevelWhenCleaned = this.actualConnection.getTransactionIsolation();
            }
            catch (SQLException sqle) {
                String i18nMsg = this.localStrings.getString("jdbc.cannot_get_iso_lvl");
                ResourceException re = new ResourceException(i18nMsg);
                re.initCause((Throwable)sqle);
                throw re;
            }
        }
        this.isClean = true;
    }

    private void invalidateAllConnectionHandles() throws ResourceException {
        Set handles = this.connectionHandles.keySet();
        Iterator iter = handles.iterator();
        try {
            while (iter.hasNext()) {
                ConnectionHolder ch = (ConnectionHolder)iter.next();
                ch.invalidate();
            }
        }
        catch (NoSuchElementException nsee) {
            throw new ResourceException("Could not find the connection handle: " + nsee.getMessage());
        }
        this.connectionHandles.clear();
    }

    public void destroy() throws ResourceException {
        if (this.logWriter != null) {
            this.logWriter.println("In destroy");
        }
        if (this.isDestroyed) {
            return;
        }
        try {
            if (this.connectionType == 2 || this.connectionType == 1) {
                this.pc.close();
                this.pc = null;
                this.actualConnection = null;
            } else {
                this.actualConnection.close();
                this.actualConnection = null;
            }
        }
        catch (SQLException sqle) {
            this.isDestroyed = true;
            this.passwdCredential = null;
            this.connectionHandles = null;
            String i18nMsg = this.localStrings.getString("jdbc.error_in_destroy");
            ResourceException re = new ResourceException(i18nMsg + sqle.getMessage(), (Throwable)sqle);
            throw re;
        }
        this.isDestroyed = true;
        this.passwdCredential = null;
        this.connectionHandles = null;
    }

    public Object getConnection(Subject sub, ConnectionRequestInfo cxReqInfo) throws ResourceException {
        if (this.logWriter != null) {
            this.logWriter.println("In getConnection");
        }
        this.checkIfValid();
        this.getActualConnection();
        if (this.isClean) {
            ((ManagedConnectionFactory)this.mcf).resetIsolation(this, this.isolationLevelWhenCleaned);
        }
        ConnectionHolder connHolderObject = new ConnectionHolder(this.actualConnection, this);
        this.incrementCount();
        this.isClean = false;
        connHolderObject.setActive(true);
        return connHolderObject;
    }

    public javax.resource.spi.LocalTransaction getLocalTransaction() throws ResourceException {
        if (this.logWriter != null) {
            this.logWriter.println("In getLocalTransaction");
        }
        this.checkIfValid();
        return new LocalTransaction(this);
    }

    public PrintWriter getLogWriter() throws ResourceException {
        if (this.logWriter != null) {
            this.logWriter.println("In getLogWriter");
        }
        this.checkIfValid();
        return this.logWriter;
    }

    public javax.resource.spi.ManagedConnectionMetaData getMetaData() throws ResourceException {
        if (this.logWriter != null) {
            this.logWriter.println("In getMetaData");
        }
        this.checkIfValid();
        return new ManagedConnectionMetaData(this);
    }

    public XAResource getXAResource() throws ResourceException {
        if (this.logWriter != null) {
            this.logWriter.println("In getXAResource");
        }
        this.checkIfValid();
        if (this.connectionType == 2) {
            try {
                if (this.xar == null) {
                    this.xar = new XAResourceImpl(((XAConnection)this.pc).getXAResource(), this);
                }
                return this.xar;
            }
            catch (SQLException sqle) {
                throw new ResourceException(sqle.getMessage(), (Throwable)sqle);
            }
        }
        throw new NotSupportedException("Cannot get an XAResource from a non XA connection");
    }

    public void removeConnectionEventListener(ConnectionEventListener listener) {
        listener = null;
    }

    void transactionStarted() {
        this.transactionInProgress = true;
    }

    void transactionCompleted() {
        this.transactionInProgress = false;
        if (this.connectionType == 1 || this.connectionType == 2) {
            try {
                this.isolationLevelWhenCleaned = this.actualConnection.getTransactionIsolation();
            }
            catch (SQLException sqle) {
                _logger.log(Level.WARNING, "jdbc.notgot_tx_isolvl");
            }
            if (this.connectionCount <= 0) {
                try {
                    this.actualConnection.close();
                    this.actualConnection = null;
                }
                catch (SQLException sqle) {
                    this.actualConnection = null;
                }
            }
        }
        this.isClean = true;
    }

    public boolean isTransactionInProgress() {
        return this.transactionInProgress;
    }

    public void setLogWriter(PrintWriter out) throws ResourceException {
        this.checkIfValid();
        this.logWriter = out;
    }

    private int getConnectionType(PooledConnection pooledConn) {
        if (pooledConn == null) {
            return 0;
        }
        if (pooledConn instanceof XAConnection) {
            return 2;
        }
        return 1;
    }

    ManagedConnectionFactory getManagedConnectionFactory() {
        return (ManagedConnectionFactory)this.mcf;
    }

    Connection getActualConnection() throws ResourceException {
        if (this.connectionType == 2 || this.connectionType == 1) {
            try {
                if (this.actualConnection == null) {
                    this.actualConnection = this.pc.getConnection();
                }
            }
            catch (SQLException sqle) {
                throw new ResourceException(sqle.getMessage(), (Throwable)sqle);
            }
        }
        return this.actualConnection;
    }

    PasswordCredential getPasswordCredential() {
        return this.passwdCredential;
    }

    void checkIfValid() throws ResourceException {
        if (this.isDestroyed || !this.isUsable) {
            String i18nMsg = this.localStrings.getString("jdbc.mc_not_usable");
            throw new ResourceException(i18nMsg);
        }
    }

    void connectionClosed(Exception e, ConnectionHolder connHolderObject) throws SQLException {
        connHolderObject.invalidate();
        this.decrementCount();
        this.ce.setConnectionHandle((Object)connHolderObject);
        this.listener.connectionClosed(this.ce);
    }

    void connectionErrorOccurred(Exception e, ConnectionHolder connHolderObject) {
        ConnectionEventListener cel = this.listener;
        ConnectionEvent ce = null;
        ConnectionEvent connectionEvent = ce = e == null ? new ConnectionEvent((javax.resource.spi.ManagedConnection)this, 5) : new ConnectionEvent((javax.resource.spi.ManagedConnection)this, 5, e);
        if (connHolderObject != null) {
            ce.setConnectionHandle((Object)connHolderObject);
        }
        cel.connectionErrorOccurred(ce);
        this.isUsable = false;
    }

    void XAStartOccurred() {
        try {
            this.actualConnection.setAutoCommit(false);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.connectionErrorOccurred(e, null);
        }
    }

    void XAEndOccurred() {
        try {
            this.actualConnection.setAutoCommit(true);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.connectionErrorOccurred(e, null);
        }
    }

    void checkIfActive(ConnectionHolder ch) throws SQLException {
        if (this.isDestroyed || !this.isUsable) {
            String i18nMsg = this.localStrings.getString("jdbc.conn_not_usable");
            throw new SQLException(i18nMsg);
        }
    }

    public void initializeConnectionType(int _connectionType) {
        this.connectionType = _connectionType;
    }

    public void incrementCount() {
        ++this.connectionCount;
    }

    public void decrementCount() {
        --this.connectionCount;
    }
}

