/*
 * Decompiled with CFR 0.152.
 */
package com.sun.gjc.spi;

import com.sun.gjc.spi.ManagedConnection;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.Map;

public class ConnectionHolder
implements Connection {
    private Connection con;
    private ManagedConnection mc;
    private boolean wrappedAlready = false;
    private boolean isClosed = false;
    private boolean valid = true;
    private boolean active = false;

    public ConnectionHolder(Connection con, ManagedConnection mc) {
        this.con = con;
        this.mc = mc;
    }

    Connection getConnection() {
        return this.con;
    }

    void wrapped(boolean wrapFlag) {
        this.wrappedAlready = wrapFlag;
    }

    boolean isWrapped() {
        return this.wrappedAlready;
    }

    ManagedConnection getManagedConnection() {
        return this.mc;
    }

    void associateConnection(Connection con, ManagedConnection mc) {
        this.mc = mc;
        this.con = con;
    }

    public void clearWarnings() throws SQLException {
        this.checkValidity();
        this.con.clearWarnings();
    }

    public void close() throws SQLException {
        this.isClosed = true;
        this.mc.connectionClosed(null, this);
    }

    public void invalidate() {
        this.valid = false;
    }

    void actualClose() throws SQLException {
        this.con.close();
    }

    public void commit() throws SQLException {
        this.checkValidity();
        this.con.commit();
    }

    public Statement createStatement() throws SQLException {
        this.checkValidity();
        return this.con.createStatement();
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkValidity();
        return this.con.createStatement(resultSetType, resultSetConcurrency);
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldabilty) throws SQLException {
        this.checkValidity();
        return this.con.createStatement(resultSetType, resultSetConcurrency, resultSetHoldabilty);
    }

    public boolean getAutoCommit() throws SQLException {
        this.checkValidity();
        return this.con.getAutoCommit();
    }

    public String getCatalog() throws SQLException {
        this.checkValidity();
        return this.con.getCatalog();
    }

    public int getHoldability() throws SQLException {
        this.checkValidity();
        return this.con.getHoldability();
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        this.checkValidity();
        return this.con.getMetaData();
    }

    public int getTransactionIsolation() throws SQLException {
        this.checkValidity();
        return this.con.getTransactionIsolation();
    }

    public Map getTypeMap() throws SQLException {
        this.checkValidity();
        return this.con.getTypeMap();
    }

    public SQLWarning getWarnings() throws SQLException {
        this.checkValidity();
        return this.con.getWarnings();
    }

    public boolean isClosed() throws SQLException {
        return this.isClosed;
    }

    public boolean isReadOnly() throws SQLException {
        this.checkValidity();
        return this.con.isReadOnly();
    }

    public String nativeSQL(String sql) throws SQLException {
        this.checkValidity();
        return this.con.nativeSQL(sql);
    }

    public CallableStatement prepareCall(String sql) throws SQLException {
        this.checkValidity();
        return this.con.prepareCall(sql);
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkValidity();
        return this.con.prepareCall(sql, resultSetType, resultSetConcurrency);
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldabilty) throws SQLException {
        this.checkValidity();
        return this.con.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldabilty);
    }

    public PreparedStatement prepareStatement(String sql) throws SQLException {
        this.checkValidity();
        return this.con.prepareStatement(sql);
    }

    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        this.checkValidity();
        return this.con.prepareStatement(sql, autoGeneratedKeys);
    }

    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        this.checkValidity();
        return this.con.prepareStatement(sql, columnIndexes);
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkValidity();
        return this.con.prepareStatement(sql, resultSetType, resultSetConcurrency);
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldabilty) throws SQLException {
        this.checkValidity();
        return this.con.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldabilty);
    }

    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        this.checkValidity();
        return this.con.prepareStatement(sql, columnNames);
    }

    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.checkValidity();
        this.con.releaseSavepoint(savepoint);
    }

    public void rollback() throws SQLException {
        this.checkValidity();
        this.con.rollback();
    }

    public void rollback(Savepoint savepoint) throws SQLException {
        this.checkValidity();
        this.con.rollback(savepoint);
    }

    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.checkValidity();
        this.con.setAutoCommit(autoCommit);
    }

    public void setCatalog(String catalog) throws SQLException {
        this.checkValidity();
        this.con.setCatalog(catalog);
    }

    public void setHoldability(int holdability) throws SQLException {
        this.checkValidity();
        this.con.setHoldability(holdability);
    }

    public void setReadOnly(boolean readOnly) throws SQLException {
        this.checkValidity();
        this.con.setReadOnly(readOnly);
    }

    public Savepoint setSavepoint() throws SQLException {
        this.checkValidity();
        return this.con.setSavepoint();
    }

    public Savepoint setSavepoint(String name) throws SQLException {
        this.checkValidity();
        return this.con.setSavepoint(name);
    }

    public void setTransactionIsolation(int level) throws SQLException {
        this.checkValidity();
        this.con.setTransactionIsolation(level);
    }

    public void setTypeMap(Map map) throws SQLException {
        this.checkValidity();
        this.con.setTypeMap(map);
    }

    private void checkValidity() throws SQLException {
        if (this.isClosed) {
            throw new SQLException("Connection closed");
        }
        if (!this.valid) {
            throw new SQLException("Invalid Connection");
        }
        if (!this.active) {
            this.mc.checkIfActive(this);
        }
    }

    void setActive(boolean actv) {
        this.active = actv;
    }
}

