/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.webservice;

import com.sun.enterprise.ComponentInvocation;
import com.sun.enterprise.InvocationManager;
import com.sun.enterprise.Switch;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.WebComponentDescriptor;
import com.sun.enterprise.deployment.WebService;
import com.sun.enterprise.deployment.WebServiceEndpoint;
import com.sun.enterprise.deployment.WebServicesDescriptor;
import com.sun.enterprise.security.jauth.ServerAuthConfig;
import com.sun.enterprise.webservice.ImplementorCacheDelegateImpl;
import com.sun.enterprise.webservice.ServletSystemHandlerDelegate;
import com.sun.enterprise.webservice.WSSCallbackHandler;
import com.sun.enterprise.webservice.WsUtil;
import com.sun.logging.LogDomains;
import com.sun.xml.rpc.spi.JaxRpcObjectFactory;
import com.sun.xml.rpc.spi.runtime.ImplementorCache;
import com.sun.xml.rpc.spi.runtime.ImplementorCacheDelegate;
import com.sun.xml.rpc.spi.runtime.RuntimeEndpointInfo;
import com.sun.xml.rpc.spi.runtime.ServletDelegate;
import com.sun.xml.rpc.spi.runtime.ServletSecondDelegate;
import com.sun.xml.rpc.spi.runtime.SystemHandlerDelegate;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ServletWebServiceDelegate
extends ServletSecondDelegate {
    private static Logger logger = LogDomains.getLogger("javax.enterprise.system.container.web");
    private WebServiceEndpoint endpoint_;
    private ServletConfig servletConfig_;
    private ServletDelegate rpcDelegate_;
    private JaxRpcObjectFactory rpcFactory_;

    public ServletWebServiceDelegate(ServletDelegate firstDelegate) {
        this.rpcDelegate_ = firstDelegate;
        this.rpcFactory_ = JaxRpcObjectFactory.newInstance();
    }

    public void postInit(ServletConfig servletConfig) throws ServletException {
        block6: {
            this.servletConfig_ = servletConfig;
            String servletName = "unknown";
            try {
                InvocationManager invManager = Switch.getSwitch().getInvocationManager();
                ComponentInvocation inv = invManager.getCurrentInvocation();
                Object containerContext = inv.getContainerContext();
                WebBundleDescriptor webBundle = (WebBundleDescriptor)Switch.getSwitch().getDescriptorFor(containerContext);
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                servletName = servletConfig.getServletName();
                WebComponentDescriptor webComponent = webBundle.getWebComponentByCanonicalName(servletName);
                if (webComponent != null) {
                    WebServicesDescriptor webServices = webBundle.getWebServices();
                    Collection endpoints = webServices.getEndpointsImplementedBy(webComponent);
                    this.endpoint_ = (WebServiceEndpoint)endpoints.iterator().next();
                    this.registerEndpoint(classLoader);
                    if (this.endpoint_.hasAuthMethod()) break block6;
                    try {
                        ServerAuthConfig config = ServerAuthConfig.getConfig("SOAP", this.endpoint_.getMessageSecurityBinding(), WSSCallbackHandler.getInstance());
                        if (config != null) {
                            ServletSystemHandlerDelegate systemHandlerDelegate = new ServletSystemHandlerDelegate(config);
                            this.rpcDelegate_.setSystemHandlerDelegate((SystemHandlerDelegate)systemHandlerDelegate);
                        }
                        break block6;
                    }
                    catch (Exception e) {
                        logger.log(Level.SEVERE, "Servlet Webservice security configuration Failure", e);
                    }
                    break block6;
                }
                throw new ServletException(servletName + " not found");
            }
            catch (Throwable t) {
                logger.log(Level.WARNING, "Servlet web service endpoint '" + servletName + "' failure", t);
                ServletException se = new ServletException();
                se.initCause(t);
                throw se;
            }
        }
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        WsUtil wsUtil = new WsUtil();
        try {
            wsUtil.handleGet(request, response, this.endpoint_);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Servlet web service endpoint '" + this.endpoint_.getEndpointName() + "' HTTP GET error", e);
        }
    }

    public void warnMissingContextInformation() {
    }

    public ImplementorCache createImplementorCache(ServletConfig sc) {
        ImplementorCache ic = this.rpcFactory_.createImplementorCache(sc);
        ImplementorCacheDelegateImpl delegate = new ImplementorCacheDelegateImpl(sc);
        ic.setDelegate((ImplementorCacheDelegate)delegate);
        return ic;
    }

    private void registerEndpoint(ClassLoader loader) throws Exception {
        RuntimeEndpointInfo endpointInfo = this.rpcFactory_.createRuntimeEndpointInfo();
        Class<?> serviceEndpointInterfaceClass = loader.loadClass(this.endpoint_.getServiceEndpointInterface());
        Class<?> implementationClass = loader.loadClass(this.endpoint_.getServletImplClass());
        String tieClassName = this.endpoint_.getTieClassName();
        Class<?> tieClass = loader.loadClass(tieClassName);
        endpointInfo.setRemoteInterface(serviceEndpointInterfaceClass);
        endpointInfo.setImplementationClass(implementationClass);
        endpointInfo.setTieClass(tieClass);
        endpointInfo.setName(this.endpoint_.getEndpointName());
        WebService webService = this.endpoint_.getWebService();
        endpointInfo.setDeployed(true);
        endpointInfo.setPortName(this.endpoint_.getWsdlPort());
        endpointInfo.setServiceName(this.endpoint_.getServiceName());
        String uri = this.endpoint_.getEndpointAddressUri();
        uri = uri.startsWith("/") ? uri : "/" + uri;
        endpointInfo.setUrlPattern(uri);
        this.rpcDelegate_.registerEndpointUrlPattern(endpointInfo);
    }
}

