/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.webservice;

import com.sun.enterprise.deployment.NameValuePairDescriptor;
import com.sun.enterprise.deployment.ServiceRefPortInfo;
import com.sun.enterprise.deployment.ServiceReferenceDescriptor;
import com.sun.enterprise.deployment.runtime.common.MessageSecurityBindingDescriptor;
import com.sun.enterprise.security.jauth.ClientAuthConfig;
import com.sun.enterprise.webservice.MessageLayerClientHandler;
import com.sun.enterprise.webservice.WSSCallbackHandler;
import com.sun.enterprise.webservice.WsUtil;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.rpc.Call;
import javax.xml.rpc.Service;
import javax.xml.rpc.Stub;
import javax.xml.rpc.handler.HandlerInfo;
import javax.xml.rpc.handler.HandlerRegistry;

public class ServiceInvocationHandler
implements InvocationHandler {
    private ServiceReferenceDescriptor serviceRef;
    private Service serviceDelegate;
    private Service configuredServiceDelegate;
    private ClassLoader classLoader;
    private Method getClientManagedPortMethod;
    private URL wsdlLocation;
    private boolean fullWsdl = false;
    private boolean noWsdl = false;
    private WsUtil wsUtil = new WsUtil();
    private static final int CREATE_CALL_NO_ARGS = 1;
    private static final int CREATE_CALL_PORT = 2;
    private static final int CREATE_CALL_OPERATION_QNAME = 3;
    private static final int CREATE_CALL_OPERATION_STRING = 4;
    private static final int GET_CALLS = 5;
    private static final int GET_HANDLER_REGISTRY = 6;
    private static final int GET_PORT_CONTAINER_MANAGED = 7;
    private static final int GET_PORT_CLIENT_MANAGED = 8;
    private static final int GET_PORTS = 9;
    private static final int GET_SERVICE_NAME = 10;
    private static final int GET_TYPE_MAPPING_REGISTRY = 11;
    private static final int GET_WSDL_LOCATION = 12;
    private static final int GENERATED_SERVICE_METHOD = 13;
    private static Map serviceMethodTypes;
    private static Set fullWsdlIllegalMethods;
    private static Set noWsdlIllegalMethods;

    public ServiceInvocationHandler(ServiceReferenceDescriptor descriptor, Service delegate, ClassLoader loader) throws Exception {
        this.serviceRef = descriptor;
        this.serviceDelegate = delegate;
        this.classLoader = loader;
        if (this.serviceRef.hasWsdlFile()) {
            this.wsdlLocation = this.wsUtil.privilegedGetServiceRefWsdl(this.serviceRef);
            this.fullWsdl = true;
        } else {
            this.noWsdl = true;
        }
        this.getClientManagedPortMethod = Service.class.getMethod("getPort", QName.class, Class.class);
        this.addMessageSecurityHandler(delegate);
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (method.getDeclaringClass() == Object.class) {
            return this.invokeJavaObjectMethod(this, method, args);
        }
        int methodType = this.getMethodType(method);
        this.checkUnsupportedMethods(methodType);
        Object returnValue = null;
        try {
            Call[] calls;
            Service serviceToInvoke = this.serviceDelegate;
            Method methodToInvoke = method;
            int methodTypeToInvoke = methodType;
            Object[] argsForInvoke = args;
            switch (methodType) {
                case 7: {
                    Class serviceEndpointInterfaceClass = (Class)args[0];
                    String serviceEndpointInterface = serviceEndpointInterfaceClass.getName();
                    ServiceRefPortInfo portInfo = this.serviceRef.getPortInfo(serviceEndpointInterface);
                    if (portInfo == null || !portInfo.hasWsdlPort()) break;
                    methodToInvoke = this.getClientManagedPortMethod;
                    methodTypeToInvoke = 8;
                    argsForInvoke = new Object[]{portInfo.getWsdlPort(), args[0]};
                    break;
                }
                case 12: {
                    return this.wsdlLocation;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 9: {
                    serviceToInvoke = this.getConfiguredServiceDelegate();
                }
            }
            returnValue = methodToInvoke.invoke((Object)serviceToInvoke, argsForInvoke);
            if (returnValue instanceof Stub) {
                Stub stub = (Stub)returnValue;
                this.setStubProperties(stub, methodTypeToInvoke, methodToInvoke, argsForInvoke);
            } else if (returnValue instanceof Call) {
                calls = new Call[]{(Call)returnValue};
                this.setCallProperties(calls, methodTypeToInvoke, argsForInvoke);
            } else if (methodType == 5) {
                calls = (Call[])returnValue;
                this.setCallProperties(calls, methodTypeToInvoke, argsForInvoke);
            }
        }
        catch (InvocationTargetException ite) {
            throw ite.getCause();
        }
        return returnValue;
    }

    public HandlerInfo getMessageSecurityHandlerInfo(QName port) throws Exception {
        ClientAuthConfig config;
        HandlerInfo rvalue = null;
        MessageSecurityBindingDescriptor binding = null;
        ServiceRefPortInfo portInfo = this.serviceRef.getPortInfoByPort(port);
        if (portInfo != null) {
            binding = portInfo.getMessageSecurityBinding();
        }
        if ((config = ClientAuthConfig.getConfig("SOAP", binding, WSSCallbackHandler.getInstance())) != null) {
            QName[] headers = config.getMechanisms();
            HashMap<String, ClientAuthConfig> properties = new HashMap<String, ClientAuthConfig>();
            properties.put("com.sun.enterprise.security.wss.ClientAuthConfig", config);
            rvalue = new HandlerInfo(MessageLayerClientHandler.class, properties, headers);
        }
        return rvalue;
    }

    private boolean addMessageSecurityHandler(Service service) throws Exception {
        HandlerRegistry registry = service.getHandlerRegistry();
        Iterator ports = null;
        try {
            ports = service.getPorts();
        }
        catch (Exception e) {
            ports = null;
        }
        while (ports != null && ports.hasNext()) {
            QName nextPort = (QName)ports.next();
            List handlerChain = registry.getHandlerChain(nextPort);
            HandlerInfo handlerInfo = this.getMessageSecurityHandlerInfo(nextPort);
            if (handlerInfo == null) continue;
            handlerChain.add(handlerInfo);
        }
        return ports != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Service getConfiguredServiceDelegate() throws Exception {
        ServiceInvocationHandler serviceInvocationHandler = this;
        synchronized (serviceInvocationHandler) {
            if (this.configuredServiceDelegate == null) {
                Service configuredService = this.wsUtil.createConfiguredService(this.serviceRef);
                this.wsUtil.configureHandlerChain(this.serviceRef, configuredService, configuredService.getPorts(), this.classLoader);
                this.configuredServiceDelegate = configuredService;
                this.addMessageSecurityHandler(configuredService);
            }
        }
        return this.configuredServiceDelegate;
    }

    private int getMethodType(Method method) {
        Integer methodType = (Integer)serviceMethodTypes.get(method);
        return methodType != null ? methodType : 13;
    }

    private static void Init() {
        serviceMethodTypes = new HashMap();
        fullWsdlIllegalMethods = new HashSet();
        noWsdlIllegalMethods = new HashSet();
        try {
            Class[] noParams = new Class[]{};
            String createCall = "createCall";
            Class serviceClass = Service.class;
            Method createCallNoArgs = serviceClass.getDeclaredMethod(createCall, noParams);
            serviceMethodTypes.put(createCallNoArgs, new Integer(1));
            Method createCallPort = serviceClass.getDeclaredMethod(createCall, QName.class);
            serviceMethodTypes.put(createCallPort, new Integer(2));
            Method createCallOperationQName = serviceClass.getDeclaredMethod(createCall, QName.class, QName.class);
            serviceMethodTypes.put(createCallOperationQName, new Integer(3));
            Method createCallOperationString = serviceClass.getDeclaredMethod(createCall, QName.class, String.class);
            serviceMethodTypes.put(createCallOperationString, new Integer(4));
            Method getCalls = serviceClass.getDeclaredMethod("getCalls", QName.class);
            serviceMethodTypes.put(getCalls, new Integer(5));
            Method getHandlerRegistry = serviceClass.getDeclaredMethod("getHandlerRegistry", noParams);
            serviceMethodTypes.put(getHandlerRegistry, new Integer(6));
            Method getPortContainerManaged = serviceClass.getDeclaredMethod("getPort", Class.class);
            serviceMethodTypes.put(getPortContainerManaged, new Integer(7));
            Method getPortClientManaged = serviceClass.getDeclaredMethod("getPort", QName.class, Class.class);
            serviceMethodTypes.put(getPortClientManaged, new Integer(8));
            Method getPorts = serviceClass.getDeclaredMethod("getPorts", noParams);
            serviceMethodTypes.put(getPorts, new Integer(9));
            Method getServiceName = serviceClass.getDeclaredMethod("getServiceName", noParams);
            serviceMethodTypes.put(getServiceName, new Integer(10));
            Method getTypeMappingRegistry = serviceClass.getDeclaredMethod("getTypeMappingRegistry", noParams);
            serviceMethodTypes.put(getTypeMappingRegistry, new Integer(11));
            Method getWsdlLocation = serviceClass.getDeclaredMethod("getWSDLDocumentLocation", noParams);
            serviceMethodTypes.put(getWsdlLocation, new Integer(12));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        fullWsdlIllegalMethods.add(new Integer(6));
        fullWsdlIllegalMethods.add(new Integer(11));
        noWsdlIllegalMethods.add(new Integer(2));
        noWsdlIllegalMethods.add(new Integer(3));
        noWsdlIllegalMethods.add(new Integer(4));
        noWsdlIllegalMethods.add(new Integer(5));
        noWsdlIllegalMethods.add(new Integer(6));
        noWsdlIllegalMethods.add(new Integer(7));
        noWsdlIllegalMethods.add(new Integer(8));
        noWsdlIllegalMethods.add(new Integer(9));
        noWsdlIllegalMethods.add(new Integer(10));
        noWsdlIllegalMethods.add(new Integer(11));
        noWsdlIllegalMethods.add(new Integer(12));
        noWsdlIllegalMethods.add(new Integer(13));
    }

    private void checkUnsupportedMethods(int methodType) throws UnsupportedOperationException {
        Set illegalMethods;
        Set set = illegalMethods = this.fullWsdl ? fullWsdlIllegalMethods : noWsdlIllegalMethods;
        if (illegalMethods.contains(new Integer(methodType))) {
            throw new UnsupportedOperationException();
        }
    }

    private void setStubProperties(Stub stub, int methodType, Method method, Object[] args) {
        QName port = null;
        String serviceEndpointInterface = null;
        switch (methodType) {
            case 7: {
                serviceEndpointInterface = ((Class)args[0]).getName();
                break;
            }
            case 8: {
                port = (QName)args[0];
                serviceEndpointInterface = ((Class)args[1]).getName();
                break;
            }
            case 13: {
                String portLocalPart;
                String string = portLocalPart = method.getName().startsWith("get") ? method.getName().substring(3) : null;
                if (portLocalPart != null) {
                    QName serviceName = this.serviceRef.getServiceName();
                    port = new QName(serviceName.getNamespaceURI(), portLocalPart);
                }
                serviceEndpointInterface = method.getReturnType().getName();
                break;
            }
            default: {
                return;
            }
        }
        ServiceRefPortInfo portInfo = null;
        if (port != null) {
            portInfo = this.serviceRef.getPortInfoByPort(port);
        }
        if (portInfo == null) {
            portInfo = this.serviceRef.getPortInfoBySEI(serviceEndpointInterface);
        }
        if (portInfo != null) {
            Set properties = portInfo.getStubProperties();
            Iterator iter = properties.iterator();
            while (iter.hasNext()) {
                NameValuePairDescriptor next = (NameValuePairDescriptor)iter.next();
                if (next.getName().equals("com.sun.enterprise.webservice.client.transport.log")) {
                    this.wsUtil.setClientTransportLog(this.serviceRef, stub, next.getValue());
                    continue;
                }
                stub._setProperty(next.getName(), (Object)next.getValue());
            }
            if (portInfo.hasTargetEndpointAddress() && !portInfo.hasStubProperty("javax.xml.rpc.service.endpoint.address")) {
                stub._setProperty("javax.xml.rpc.service.endpoint.address", (Object)portInfo.getTargetEndpointAddress());
            }
        }
    }

    private void setCallProperties(Call[] calls, int methodType, Object[] args) {
        Set callProperties = this.getPropertiesForCall(methodType, args);
        if (callProperties != null) {
            for (int callIndex = 0; callIndex < calls.length; ++callIndex) {
                this.setCallProperties(calls[callIndex], callProperties);
            }
        }
    }

    private Set getPropertiesForCall(int methodType, Object[] args) {
        Set callProperties = null;
        switch (methodType) {
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                QName port = (QName)args[0];
                ServiceRefPortInfo portInfo = this.serviceRef.getPortInfoByPort(port);
                if (portInfo == null) break;
                callProperties = portInfo.getCallProperties();
                break;
            }
            case 1: {
                callProperties = this.serviceRef.getCallProperties();
            }
        }
        return callProperties;
    }

    private void setCallProperties(Call call, Set callProperties) {
        Iterator iter = callProperties.iterator();
        while (iter.hasNext()) {
            NameValuePairDescriptor next = (NameValuePairDescriptor)iter.next();
            call.setProperty(next.getName(), (Object)next.getValue());
        }
    }

    private Object invokeJavaObjectMethod(InvocationHandler handler, Method method, Object[] args) throws Throwable {
        Object returnValue = null;
        switch (method.getName().charAt(0)) {
            case 'e': {
                Object other = Proxy.isProxyClass(args[0].getClass()) ? Proxy.getInvocationHandler(args[0]) : args[0];
                returnValue = new Boolean(handler.equals(other));
                break;
            }
            case 'h': {
                returnValue = new Integer(handler.hashCode());
                break;
            }
            case 't': {
                returnValue = handler.toString();
                break;
            }
            default: {
                throw new Throwable("Object method " + method.getName() + "not found");
            }
        }
        return returnValue;
    }

    static {
        ServiceInvocationHandler.Init();
    }
}

