/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.webservice;

import com.sun.enterprise.security.SSLUtils;
import com.sun.enterprise.security.jauth.callback.CertStoreCallback;
import com.sun.enterprise.webservice.Processor;
import com.sun.logging.LogDomains;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertStore;
import java.security.cert.Certificate;
import java.security.cert.CollectionCertStoreParameters;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.callback.Callback;

public class CertStoreProcessor
implements Processor {
    private static Logger _logger = LogDomains.getLogger("javax.enterprise.system.core.security");
    CertStoreCallback csc = null;
    KeyStore ks = null;

    CertStoreProcessor(Callback callback) {
        this.csc = (CertStoreCallback)callback;
        this.ks = SSLUtils.getMergedTrustStore();
    }

    public void process() {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "container-auth: wss : In CertStoreCallback Processor");
        }
        if (this.ks == null) {
            this.csc.setStore(null);
        }
        ArrayList<Certificate> list = new ArrayList<Certificate>();
        CollectionCertStoreParameters ccsp = null;
        try {
            Enumeration<String> enu = this.ks.aliases();
            while (enu.hasMoreElements()) {
                String alias = enu.nextElement();
                if (!this.ks.isCertificateEntry(alias)) continue;
                try {
                    Certificate cert = this.ks.getCertificate(alias);
                    list.add(cert);
                }
                catch (KeyStoreException kse) {
                    _logger.log(Level.FINE, "container-auth : wss: Cannot retrievecertificate for alias " + alias);
                }
            }
            ccsp = new CollectionCertStoreParameters(list);
            CertStore certstore = CertStore.getInstance("Collection", ccsp);
            this.csc.setStore(certstore);
        }
        catch (KeyStoreException kse) {
            _logger.log(Level.FINE, "container-auth: wss :  Cannot determine truststore aliases", kse);
        }
        catch (InvalidAlgorithmParameterException iape) {
            _logger.log(Level.FINE, "container-auth: wss :  Cannot instantiate CertStore", iape);
        }
        catch (NoSuchAlgorithmException nsape) {
            _logger.log(Level.FINE, "container-auth: wss :  Cannot instantiate CertStore", nsape);
        }
    }
}

