/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web.logger;

import com.sun.enterprise.util.logging.IASLevel;
import com.sun.enterprise.web.logger.LoggerBase;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class IASLogger
extends LoggerBase {
    Logger _logger = null;
    private String _classname;
    private String _methodname;
    protected static final String info = "com.sun.enterprise.web.logger.IASLogger/1.0";

    private IASLogger() {
    }

    public IASLogger(Logger logger) {
        this._logger = logger;
    }

    protected void write(String msg, int verbosity) {
        if (this._logger == null) {
            return;
        }
        Level level = Level.INFO;
        if (verbosity == Integer.MIN_VALUE) {
            level = IASLevel.FATAL;
        } else if (verbosity == 1) {
            level = Level.SEVERE;
        } else if (verbosity == 2) {
            level = Level.WARNING;
        } else if (verbosity == 3) {
            level = Level.FINE;
        } else if (verbosity == 4) {
            level = Level.FINER;
        }
        this.inferCaller();
        this._logger.logp(level, this._classname, this._methodname, msg);
    }

    protected void write(String msg) {
        if (this._logger == null) {
            return;
        }
        this.inferCaller();
        this._logger.logp(this._logger.getLevel(), this._classname, this._methodname, msg);
    }

    private void inferCaller() {
        StackTraceElement[] stack = new Throwable().getStackTrace();
        this._classname = "";
        this._methodname = "";
        for (int ix = 0; ix < stack.length; ++ix) {
            StackTraceElement frame = stack[ix];
            this._classname = frame.getClassName();
            if (this._classname.startsWith("com.sun.enterprise.web.logger")) continue;
            this._methodname = frame.getMethodName();
            return;
        }
    }
}

