/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web.connector.grizzly;

import com.sun.enterprise.web.connector.grizzly.Constants;
import com.sun.enterprise.web.connector.grizzly.NonBlockingPipedInputStream;
import com.sun.enterprise.web.connector.grizzly.SocketChannelOutputBuffer;
import com.sun.enterprise.web.connector.grizzly.Task;
import com.sun.enterprise.web.connector.grizzly.TaskBase;
import com.sun.enterprise.web.connector.grizzly.TaskContext;
import com.sun.enterprise.web.connector.grizzly.TaskEvent;
import com.sun.logging.LogDomains;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.nio.channels.SocketChannel;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.ObjectName;
import org.apache.commons.modeler.Registry;
import org.apache.coyote.ActionCode;
import org.apache.coyote.ActionHook;
import org.apache.coyote.Adapter;
import org.apache.coyote.Processor;
import org.apache.coyote.Request;
import org.apache.coyote.RequestGroupInfo;
import org.apache.coyote.RequestInfo;
import org.apache.coyote.Response;
import org.apache.coyote.http11.InputFilter;
import org.apache.coyote.http11.InternalInputBuffer;
import org.apache.coyote.http11.InternalOutputBuffer;
import org.apache.coyote.http11.OutputFilter;
import org.apache.coyote.http11.filters.BufferedInputFilter;
import org.apache.coyote.http11.filters.ChunkedInputFilter;
import org.apache.coyote.http11.filters.ChunkedOutputFilter;
import org.apache.coyote.http11.filters.GzipOutputFilter;
import org.apache.coyote.http11.filters.IdentityInputFilter;
import org.apache.coyote.http11.filters.IdentityOutputFilter;
import org.apache.coyote.http11.filters.VoidInputFilter;
import org.apache.coyote.http11.filters.VoidOutputFilter;
import org.apache.tomcat.util.buf.Ascii;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.buf.HexUtils;
import org.apache.tomcat.util.buf.MessageBytes;
import org.apache.tomcat.util.http.FastHttpDateFormat;
import org.apache.tomcat.util.http.MimeHeaders;
import org.apache.tomcat.util.net.SSLImplementation;
import org.apache.tomcat.util.net.SSLSupport;

public class ProcessorTask
extends TaskBase
implements Processor,
ActionHook {
    private static final String KEEP_ALIVE = "com.sun.enterprise.web.connector.grizzly.keepAlive";
    private static final String USE_KEEP_ALIVE = "com.sun.enterprise.web.connector.grizzly.useKeepAliveAlgorithm";
    private static final String HTTP_HEADER_BUFFER_SIZE = "com.sun.enterprise.web.connector.grizzly.maxHttpHeaderSize";
    private static Logger logger = LogDomains.getLogger("javax.enterprise.system.container.web");
    protected Adapter adapter = null;
    protected Request request = null;
    protected Response response = null;
    protected InternalInputBuffer inputBuffer = null;
    protected InternalOutputBuffer outputBuffer = null;
    protected boolean started = false;
    protected boolean error = false;
    protected boolean keepAlive = true;
    protected boolean http11 = true;
    protected boolean http09 = false;
    protected boolean contentDelimitation = true;
    protected int maxKeepAliveRequests = -1;
    protected SSLSupport sslSupport;
    protected Socket socket;
    protected String remoteAddr = null;
    protected String remoteHost = null;
    protected String localName = null;
    protected int localPort = -1;
    protected int remotePort = -1;
    protected String localAddr = null;
    protected int timeout = 300000;
    protected boolean disableUploadTimeout = true;
    protected int maxPostSize = 0x200000;
    protected char[] hostNameC = new char[0];
    protected TaskContext taskContext;
    protected TaskEvent taskEvent = new TaskEvent();
    protected SSLImplementation sslImplementation = null;
    protected static int keepAliveTimeout = 5;
    protected static boolean useKeepAliveAlgorithm = false;
    protected boolean usingNioNonBlocking = true;
    private boolean hasRequestInfoRegistered = false;
    private RequestGroupInfo requestGroupInfo;
    private static boolean useMonitoring = false;
    protected static int maxHttpHeaderSize = 4096;
    protected static int requestCount;
    private int requestBufferSize = 4096;

    public ProcessorTask() {
        this(true, true);
    }

    public ProcessorTask(boolean useNio, boolean init) {
        this.usingNioNonBlocking = useNio;
        this.type = 2;
        if (init) {
            this.initialize();
        }
    }

    private void initialize() {
        this.started = true;
        this.request = new Request();
        this.inputBuffer = new InternalInputBuffer(this.request, this.requestBufferSize);
        this.request.setInputBuffer(this.inputBuffer);
        this.response = new Response();
        this.response.setHook(this);
        this.outputBuffer = this.usingNioNonBlocking ? new SocketChannelOutputBuffer(this.response, maxHttpHeaderSize) : new InternalOutputBuffer(this.response, maxHttpHeaderSize);
        this.response.setOutputBuffer(this.outputBuffer);
        this.request.setResponse(this.response);
        this.initializeFilters();
    }

    protected static void configureProperties() {
        if (System.getProperty(KEEP_ALIVE) != null) {
            try {
                keepAliveTimeout = Integer.parseInt(System.getProperty(KEEP_ALIVE));
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
        }
        if (System.getProperty(HTTP_HEADER_BUFFER_SIZE) != null) {
            try {
                maxHttpHeaderSize = Integer.parseInt(System.getProperty(HTTP_HEADER_BUFFER_SIZE));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (System.getProperty(USE_KEEP_ALIVE) != null) {
            useKeepAliveAlgorithm = Boolean.valueOf(System.getProperty(USE_KEEP_ALIVE));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void doTask() throws IOException {
        block56: {
            IOException ioe222;
            boolean sslEnabled;
            block47: {
                boolean bl = sslEnabled = this.sslImplementation != null;
                if (!this.started) {
                    this.initialize();
                }
                this.hasBeenReturned = false;
                if (this.usingNioNonBlocking && !sslEnabled) {
                    this.process(this.taskContext.getInputStream(), (SocketChannel)this.key.channel());
                    break block47;
                }
                this.process(this.taskContext.getInputStream(), this.taskContext.getOutputStream());
            }
            Object var4_2 = null;
            try {
                if (this.key != null && ((Task)this.key.attachment()).getType() == 1) {
                    this.selectorThread.deregisterInterestOp(this.key);
                }
            }
            catch (Throwable ex2) {
                logger.log(Level.FINE, "processorTask.deregistrationError", ex2);
            }
            if (this.key != null) {
                this.key.attach(null);
                try {
                    this.taskContext.recycle();
                }
                catch (IOException ioe222) {}
            } else {
                if (!sslEnabled) {
                    try {
                        if (!this.socket.isInputShutdown()) {
                            this.socket.shutdownInput();
                        }
                    }
                    catch (IOException ioe222) {
                        // empty catch block
                    }
                    try {
                        if (!this.socket.isOutputShutdown()) {
                            this.socket.shutdownOutput();
                        }
                    }
                    catch (IOException ex2) {
                        // empty catch block
                    }
                }
                try {
                    this.socket.close();
                }
                catch (IOException ex2) {
                    // empty catch block
                }
            }
            this.notifyTaskCompleted(this.taskEvent);
            if (!this.hasBeenReturned && this.key != null) {
                this.selectorThread.returnTask(this);
                this.hasBeenReturned = true;
            }
            break block56;
            {
                catch (Throwable ex) {
                    IOException ioe222;
                    logger.log(Level.SEVERE, "processorTask.errorProcessingRequest", ex);
                    Object var4_3 = null;
                    try {
                        if (this.key != null && ((Task)this.key.attachment()).getType() == 1) {
                            this.selectorThread.deregisterInterestOp(this.key);
                        }
                    }
                    catch (Throwable ex2) {
                        logger.log(Level.FINE, "processorTask.deregistrationError", ex2);
                    }
                    if (this.key != null) {
                        this.key.attach(null);
                        try {
                            this.taskContext.recycle();
                        }
                        catch (IOException ioe222) {}
                    } else {
                        if (!sslEnabled) {
                            try {
                                if (!this.socket.isInputShutdown()) {
                                    this.socket.shutdownInput();
                                }
                            }
                            catch (IOException ioe222) {
                                // empty catch block
                            }
                            try {
                                if (!this.socket.isOutputShutdown()) {
                                    this.socket.shutdownOutput();
                                }
                            }
                            catch (IOException ex2) {
                                // empty catch block
                            }
                        }
                        try {
                            this.socket.close();
                        }
                        catch (IOException ex2) {
                            // empty catch block
                        }
                    }
                    this.notifyTaskCompleted(this.taskEvent);
                    if (!this.hasBeenReturned && this.key != null) {
                        this.selectorThread.returnTask(this);
                        this.hasBeenReturned = true;
                    }
                }
            }
            catch (Throwable throwable) {
                IOException ioe222;
                Object var4_4 = null;
                try {
                    if (this.key != null && ((Task)this.key.attachment()).getType() == 1) {
                        this.selectorThread.deregisterInterestOp(this.key);
                    }
                }
                catch (Throwable ex2) {
                    logger.log(Level.FINE, "processorTask.deregistrationError", ex2);
                }
                if (this.key != null) {
                    this.key.attach(null);
                    try {
                        this.taskContext.recycle();
                    }
                    catch (IOException ioe222) {}
                } else {
                    if (!sslEnabled) {
                        try {
                            if (!this.socket.isInputShutdown()) {
                                this.socket.shutdownInput();
                            }
                        }
                        catch (IOException ioe222) {
                            // empty catch block
                        }
                        try {
                            if (!this.socket.isOutputShutdown()) {
                                this.socket.shutdownOutput();
                            }
                        }
                        catch (IOException ex2) {
                            // empty catch block
                        }
                    }
                    try {
                        this.socket.close();
                    }
                    catch (IOException ex2) {
                        // empty catch block
                    }
                }
                this.notifyTaskCompleted(this.taskEvent);
                if (!this.hasBeenReturned && this.key != null) {
                    this.selectorThread.returnTask(this);
                    this.hasBeenReturned = true;
                }
                throw throwable;
            }
        }
    }

    public void setTaskContext(TaskContext taskContext) {
        this.taskContext = taskContext;
    }

    public void taskStarted(TaskEvent event) {
        this.taskContext = event.getTaskContext();
        this.taskEvent.setTaskContext(this.taskContext);
        this.execute();
    }

    public void recycle() {
        super.recycle();
        this.error = false;
        this.keepAlive = true;
        this.http11 = true;
        this.http09 = false;
        this.contentDelimitation = true;
        this.sslSupport = null;
        this.socket = null;
        this.remoteAddr = null;
        this.remoteHost = null;
        this.localName = null;
        this.localPort = -1;
        this.remotePort = -1;
        this.localAddr = null;
        this.disableUploadTimeout = true;
    }

    public void process(InputStream input, OutputStream output) throws IOException {
        if (this.sslImplementation != null) {
            this.sslSupport = this.sslImplementation.getSSLSupport(this.socket);
        }
        this.outputBuffer.setOutputStream(output);
        this.process(input);
    }

    public void process(InputStream input, SocketChannel byteChannel) throws IOException {
        ((SocketChannelOutputBuffer)this.outputBuffer).setChannel(byteChannel);
        ((NonBlockingPipedInputStream)input).setMaxKeepAlive(keepAliveTimeout);
        this.process(input);
    }

    private void process(InputStream input) throws IOException {
        if (this.selectorThread.getDomain() != null && useMonitoring && !this.hasRequestInfoRegistered) {
            this.registerMonitoring();
        }
        this.inputBuffer.setInputStream(input);
        this.remoteAddr = null;
        this.remoteHost = null;
        this.localAddr = null;
        this.remotePort = -1;
        this.localPort = -1;
        this.error = false;
        this.keepAlive = true;
        int keepAliveLeft = this.maxKeepAliveRequests;
        int soTimeout = this.socket.getSoTimeout();
        if (useKeepAliveAlgorithm) {
            float threadRatio = (float)this.pipeline.getCurrentThreadsBusy() / (float)this.pipeline.getMaxThreads();
            if ((double)threadRatio > 0.33 && (double)threadRatio < 0.66) {
                soTimeout /= 2;
            } else if ((double)threadRatio >= 0.66) {
                soTimeout /= 5;
                keepAliveLeft = 1;
            }
        }
        boolean keptAlive = false;
        while (this.started && !this.error && this.keepAlive) {
            try {
                if (!this.disableUploadTimeout && keptAlive && soTimeout > 0) {
                    this.socket.setSoTimeout(soTimeout);
                }
                this.inputBuffer.parseRequestLine();
                this.request.setStartTime(System.currentTimeMillis());
                keptAlive = true;
                if (!this.disableUploadTimeout) {
                    this.socket.setSoTimeout(this.timeout);
                }
                this.inputBuffer.parseHeaders();
            }
            catch (IOException e) {
                this.error = true;
                break;
            }
            catch (NonBlockingPipedInputStream.KeepAliveExpired ex) {
                this.inputBuffer.nextRequest();
                this.outputBuffer.nextRequest();
                break;
            }
            catch (Throwable t) {
                logger.log(Level.SEVERE, "processorTask.nonBlockingError", t);
                this.response.setStatus(400);
                this.error = true;
            }
            try {
                this.prepareRequest();
            }
            catch (Throwable t) {
                logger.log(Level.FINE, "processorTask.createRequestError", t);
                this.response.setStatus(400);
                this.error = true;
            }
            if (this.maxKeepAliveRequests > 0 && --keepAliveLeft == 0) {
                this.keepAlive = false;
                logger.log(Level.FINE, "processorTask.keepAliveTimeout");
            }
            if (!this.error) {
                try {
                    this.adapter.service(this.request, this.response);
                    if (this.keepAlive && !this.error) {
                        this.error = this.response.getErrorException() != null || this.statusDropsConnection(this.response.getStatus());
                    }
                }
                catch (InterruptedIOException e) {
                    this.error = true;
                }
                catch (Throwable t) {
                    logger.log(Level.SEVERE, "processorTask.serviceError", t);
                    this.response.setStatus(500);
                    this.error = true;
                }
            }
            try {
                this.inputBuffer.endRequest();
            }
            catch (IOException e) {
                this.error = true;
            }
            catch (Throwable t) {
                logger.log(Level.SEVERE, "processorTask.errorFinishingRequest", t);
                this.response.setStatus(500);
                this.error = true;
            }
            try {
                this.outputBuffer.endRequest();
            }
            catch (IOException e) {
                this.error = true;
            }
            catch (Throwable t) {
                logger.log(Level.SEVERE, "processorTask.errorFinishingResponse", t);
                this.error = true;
            }
            if (this.error) {
                this.response.setStatus(500);
            }
            if (useMonitoring) {
                this.request.updateCounters();
            }
            this.inputBuffer.nextRequest();
            this.outputBuffer.nextRequest();
        }
        this.inputBuffer.recycle();
        this.outputBuffer.recycle();
        this.sslSupport = null;
    }

    public Request getRequest() {
        return this.request;
    }

    public void setRequestGroupInfo(RequestGroupInfo requestGroupInfo) {
        this.requestGroupInfo = requestGroupInfo;
    }

    public void action(ActionCode actionCode, Object param) {
        block52: {
            if (actionCode == ActionCode.ACTION_COMMIT) {
                if (this.response.isCommitted()) {
                    return;
                }
                this.prepareResponse();
                try {
                    this.outputBuffer.commit();
                }
                catch (IOException ex) {
                    logger.log(Level.SEVERE, "processorTask.errorCommitingResponse", ex);
                    this.error = true;
                }
            } else if (actionCode == ActionCode.ACTION_ACK) {
                if (this.response.isCommitted() || !this.http11) {
                    return;
                }
                MessageBytes expectMB = this.request.getMimeHeaders().getValue("expect");
                if (expectMB != null && expectMB.indexOfIgnoreCase("100-continue", 0) != -1) {
                    try {
                        this.outputBuffer.sendAck();
                    }
                    catch (IOException e) {
                        this.error = true;
                    }
                }
            } else if (actionCode == ActionCode.ACTION_CLOSE) {
                try {
                    this.outputBuffer.endRequest();
                }
                catch (IOException e) {
                    this.error = true;
                }
            } else if (actionCode == ActionCode.ACTION_RESET) {
                this.outputBuffer.reset();
            } else if (actionCode != ActionCode.ACTION_CUSTOM) {
                if (actionCode == ActionCode.ACTION_START) {
                    this.started = true;
                } else if (actionCode == ActionCode.ACTION_STOP) {
                    this.started = false;
                } else if (actionCode == ActionCode.ACTION_REQ_SSL_ATTRIBUTE) {
                    try {
                        if (this.sslSupport == null) break block52;
                        Object sslO = this.sslSupport.getCipherSuite();
                        if (sslO != null) {
                            this.request.setAttribute("javax.servlet.request.cipher_suite", sslO);
                        }
                        if ((sslO = this.sslSupport.getPeerCertificateChain(false)) != null) {
                            this.request.setAttribute("javax.servlet.request.X509Certificate", sslO);
                        }
                        if ((sslO = this.sslSupport.getKeySize()) != null) {
                            this.request.setAttribute("javax.servlet.request.key_size", sslO);
                        }
                        if ((sslO = this.sslSupport.getSessionId()) != null) {
                            this.request.setAttribute("javax.servlet.request.ssl_session", sslO);
                        }
                    }
                    catch (Exception e) {
                        logger.log(Level.WARNING, "processorTask.errorSSL", e);
                    }
                } else if (actionCode == ActionCode.ACTION_REQ_HOST_ADDR_ATTRIBUTE) {
                    InetAddress inetAddr;
                    if (this.remoteAddr == null && this.socket != null && (inetAddr = this.socket.getInetAddress()) != null) {
                        this.remoteAddr = inetAddr.getHostAddress();
                    }
                    this.request.remoteAddr().setString(this.remoteAddr);
                } else if (actionCode == ActionCode.ACTION_REQ_LOCAL_NAME_ATTRIBUTE) {
                    InetAddress inetAddr;
                    if (this.localName == null && this.socket != null && (inetAddr = this.socket.getLocalAddress()) != null) {
                        this.localName = inetAddr.getHostName();
                    }
                    this.request.localName().setString(this.localName);
                } else if (actionCode == ActionCode.ACTION_REQ_HOST_ATTRIBUTE) {
                    InetAddress inetAddr;
                    if (this.remoteHost == null && this.socket != null && (inetAddr = this.socket.getInetAddress()) != null) {
                        this.remoteHost = inetAddr.getHostName();
                    }
                    this.request.remoteHost().setString(this.remoteHost);
                } else if (actionCode == ActionCode.ACTION_REQ_LOCAL_ADDR_ATTRIBUTE) {
                    if (this.localAddr == null) {
                        this.localAddr = this.socket.getLocalAddress().getHostAddress();
                    }
                    this.request.localAddr().setString(this.localAddr);
                } else if (actionCode == ActionCode.ACTION_REQ_REMOTEPORT_ATTRIBUTE) {
                    if (this.remotePort == -1 && this.socket != null) {
                        this.remotePort = this.socket.getPort();
                    }
                    this.request.setRemotePort(this.remotePort);
                } else if (actionCode == ActionCode.ACTION_REQ_LOCALPORT_ATTRIBUTE) {
                    if (this.localPort == -1 && this.socket != null) {
                        this.localPort = this.socket.getLocalPort();
                    }
                    this.request.setLocalPort(this.localPort);
                } else if (actionCode == ActionCode.ACTION_REQ_SSL_CERTIFICATE && this.sslSupport != null) {
                    InputFilter[] inputFilters = this.inputBuffer.getFilters();
                    ((BufferedInputFilter)inputFilters[3]).setLimit(this.maxPostSize);
                    this.inputBuffer.addActiveFilter(inputFilters[3]);
                    try {
                        Object[] sslO = this.sslSupport.getPeerCertificateChain(true);
                        if (sslO != null) {
                            this.request.setAttribute("javax.servlet.request.X509Certificate", sslO);
                        }
                    }
                    catch (Exception e) {
                        logger.log(Level.WARNING, "processorTask.exceptionSSLcert", e);
                    }
                }
            }
        }
    }

    public void setAdapter(Adapter adapter) {
        this.adapter = adapter;
    }

    public Adapter getAdapter() {
        return this.adapter;
    }

    protected void prepareRequest() {
        ByteChunk uriBC;
        MessageBytes protocolMB;
        this.http11 = true;
        this.http09 = false;
        this.contentDelimitation = false;
        if (this.sslSupport != null) {
            this.request.scheme().setString("https");
        }
        if ((protocolMB = this.request.protocol()).equals("HTTP/1.1")) {
            this.http11 = true;
            protocolMB.setString("HTTP/1.1");
        } else if (protocolMB.equals("HTTP/1.0")) {
            this.http11 = false;
            this.keepAlive = false;
            protocolMB.setString("HTTP/1.0");
        } else if (protocolMB.equals("")) {
            this.http09 = true;
            this.http11 = false;
            this.keepAlive = false;
        } else {
            this.http11 = false;
            this.error = true;
            this.response.setStatus(505);
        }
        MessageBytes methodMB = this.request.method();
        if (methodMB.equals("GET")) {
            methodMB.setString("GET");
        } else if (methodMB.equals("POST")) {
            methodMB.setString("POST");
        }
        MessageBytes connectionValueMB = this.request.getMimeHeaders().getValue("connection");
        if (connectionValueMB != null) {
            ByteChunk connectionValueBC = connectionValueMB.getByteChunk();
            if (this.findBytes(connectionValueBC, Constants.CLOSE_BYTES) != -1) {
                this.keepAlive = false;
            } else if (this.findBytes(connectionValueBC, Constants.KEEPALIVE_BYTES) != -1) {
                this.keepAlive = true;
            }
        }
        if ((uriBC = this.request.requestURI().getByteChunk()).startsWithIgnoreCase("http", 0)) {
            int pos = uriBC.indexOf("://", 0, 3, 4);
            int uriBCStart = uriBC.getStart();
            int slashPos = -1;
            if (pos != -1) {
                byte[] uriB = uriBC.getBytes();
                slashPos = uriBC.indexOf('/', pos + 3);
                if (slashPos == -1) {
                    slashPos = uriBC.getLength();
                    this.request.requestURI().setBytes(uriB, uriBCStart + pos + 1, 1);
                } else {
                    this.request.requestURI().setBytes(uriB, uriBCStart + slashPos, uriBC.getLength() - slashPos);
                }
                MessageBytes hostMB = this.request.getMimeHeaders().setValue("host");
                hostMB.setBytes(uriB, uriBCStart + pos + 3, slashPos - pos - 3);
            }
        }
        InputFilter[] inputFilters = this.inputBuffer.getFilters();
        long contentLength = this.request.getContentLengthLong();
        if (contentLength >= 0L) {
            this.inputBuffer.addActiveFilter(inputFilters[0]);
            this.contentDelimitation = true;
        }
        MessageBytes transferEncodingValueMB = null;
        if (this.http11) {
            transferEncodingValueMB = this.request.getMimeHeaders().getValue("transfer-encoding");
        }
        if (transferEncodingValueMB != null) {
            String transferEncodingValue = transferEncodingValueMB.toString();
            int startPos = 0;
            int commaPos = transferEncodingValue.indexOf(44);
            String encodingName = null;
            while (commaPos != -1) {
                encodingName = transferEncodingValue.substring(startPos, commaPos).toLowerCase().trim();
                if (!this.addInputFilter(inputFilters, encodingName)) {
                    this.error = true;
                    this.response.setStatus(501);
                }
                startPos = commaPos + 1;
                commaPos = transferEncodingValue.indexOf(44, startPos);
            }
            encodingName = transferEncodingValue.substring(startPos).toLowerCase().trim();
            if (!this.addInputFilter(inputFilters, encodingName)) {
                this.error = true;
                this.response.setStatus(501);
            }
        }
        MessageBytes valueMB = this.request.getMimeHeaders().getValue("host");
        if (this.http11 && valueMB == null) {
            this.error = true;
            this.response.setStatus(400);
        }
        this.parseHost(valueMB);
        if (!this.contentDelimitation && this.keepAlive) {
            this.inputBuffer.addActiveFilter(inputFilters[2]);
            this.contentDelimitation = true;
        }
        if (!this.contentDelimitation) {
            this.keepAlive = false;
        }
    }

    public void parseHost(MessageBytes valueMB) {
        if (valueMB == null || valueMB.isNull()) {
            this.request.setServerPort(this.socket.getLocalPort());
            InetAddress localAddress = this.socket.getLocalAddress();
            this.request.setLocalHost(localAddress.getHostName());
            this.request.serverName().setString(localAddress.getHostName());
            return;
        }
        ByteChunk valueBC = valueMB.getByteChunk();
        byte[] valueB = valueBC.getBytes();
        int valueL = valueBC.getLength();
        int valueS = valueBC.getStart();
        int colonPos = -1;
        if (this.hostNameC.length < valueL) {
            this.hostNameC = new char[valueL];
        }
        boolean ipv6 = valueB[valueS] == 91;
        boolean bracketClosed = false;
        for (int i = 0; i < valueL; ++i) {
            char b;
            this.hostNameC[i] = b = (char)valueB[i + valueS];
            if (b == ']') {
                bracketClosed = true;
                continue;
            }
            if (b != ':' || ipv6 && !bracketClosed) continue;
            colonPos = i;
            break;
        }
        if (colonPos < 0) {
            if (this.sslSupport == null) {
                this.request.setServerPort(80);
            } else {
                this.request.setServerPort(443);
            }
            this.request.serverName().setChars(this.hostNameC, 0, valueL);
        } else {
            this.request.serverName().setChars(this.hostNameC, 0, colonPos);
            int port = 0;
            int mult = 1;
            for (int i = valueL - 1; i > colonPos; --i) {
                int charValue = HexUtils.DEC[valueB[i + valueS]];
                if (charValue == -1) {
                    this.error = true;
                    this.response.setStatus(400);
                    break;
                }
                port += charValue * mult;
                mult = 10 * mult;
            }
            this.request.setServerPort(port);
        }
    }

    protected void prepareResponse() {
        MessageBytes methodMB;
        boolean entityBody = true;
        this.contentDelimitation = false;
        OutputFilter[] outputFilters = this.outputBuffer.getFilters();
        if (this.http09) {
            this.outputBuffer.addActiveFilter(outputFilters[0]);
            return;
        }
        int statusCode = this.response.getStatus();
        if (statusCode == 204 || statusCode == 205 || statusCode == 304) {
            this.outputBuffer.addActiveFilter(outputFilters[2]);
            entityBody = false;
            this.contentDelimitation = true;
        }
        if ((methodMB = this.request.method()).equals("HEAD")) {
            this.outputBuffer.addActiveFilter(outputFilters[2]);
            this.contentDelimitation = true;
        }
        MimeHeaders headers = this.response.getMimeHeaders();
        if (!entityBody) {
            this.response.setContentLength(-1);
        } else {
            String contentLanguage;
            String contentType = this.response.getContentType();
            if (contentType != null) {
                headers.setValue("Content-Type").setString(contentType);
            }
            if ((contentLanguage = this.response.getContentLanguage()) != null) {
                headers.setValue("Content-Language").setString(contentLanguage);
            }
        }
        int contentLength = this.response.getContentLength();
        if (contentLength != -1) {
            this.response.getMimeHeaders().setValue("Content-Length").setInt(contentLength);
            this.outputBuffer.addActiveFilter(outputFilters[0]);
            this.contentDelimitation = true;
        } else if (entityBody && this.http11 && this.keepAlive) {
            this.outputBuffer.addActiveFilter(outputFilters[1]);
            this.contentDelimitation = true;
            this.response.addHeader("Transfer-Encoding", "chunked");
        } else {
            this.outputBuffer.addActiveFilter(outputFilters[0]);
        }
        if (!this.response.containsHeader("Date")) {
            String date = FastHttpDateFormat.getCurrentDate();
            this.response.addHeader("Date", date);
        }
        this.response.addHeader("Server", Constants.SERVER);
        if (entityBody && !this.contentDelimitation) {
            this.keepAlive = false;
        }
        boolean bl = this.keepAlive = this.keepAlive && !this.statusDropsConnection(statusCode);
        if (!this.keepAlive) {
            this.response.addHeader("Connection", "close");
        } else if (!this.http11) {
            this.response.addHeader("Connection", "Keep-Alive");
        }
        this.outputBuffer.sendStatus();
        int size = headers.size();
        for (int i = 0; i < size; ++i) {
            this.outputBuffer.sendHeader(headers.getName(i), headers.getValue(i));
        }
        this.outputBuffer.endHeaders();
    }

    protected void initializeFilters() {
        this.inputBuffer.addFilter(new IdentityInputFilter());
        this.outputBuffer.addFilter(new IdentityOutputFilter());
        this.inputBuffer.addFilter(new ChunkedInputFilter());
        this.outputBuffer.addFilter(new ChunkedOutputFilter());
        this.inputBuffer.addFilter(new VoidInputFilter());
        this.outputBuffer.addFilter(new VoidOutputFilter());
        this.inputBuffer.addFilter(new BufferedInputFilter());
        this.outputBuffer.addFilter(new GzipOutputFilter());
    }

    protected boolean addInputFilter(InputFilter[] inputFilters, String encodingName) {
        if (!encodingName.equals("identity")) {
            if (encodingName.equals("chunked")) {
                this.inputBuffer.addActiveFilter(inputFilters[1]);
                this.contentDelimitation = true;
            } else {
                for (int i = 2; i < inputFilters.length; ++i) {
                    if (!inputFilters[i].getEncodingName().toString().equals(encodingName)) continue;
                    this.inputBuffer.addActiveFilter(inputFilters[i]);
                    return true;
                }
                return false;
            }
        }
        return true;
    }

    protected int findBytes(ByteChunk bc, byte[] b) {
        byte first = b[0];
        byte[] buff = bc.getBuffer();
        int start = bc.getStart();
        int end = bc.getEnd();
        int srcEnd = b.length;
        for (int i = start; i <= end - srcEnd; ++i) {
            if (Ascii.toLower(buff[i]) != first) continue;
            int myPos = i + 1;
            int srcPos = 1;
            while (srcPos < srcEnd && Ascii.toLower(buff[myPos++]) == b[srcPos++]) {
                if (srcPos != srcEnd) continue;
                return i - start;
            }
        }
        return -1;
    }

    protected boolean statusDropsConnection(int status) {
        return status == 400 || status == 408 || status == 411 || status == 413 || status == 414 || status == 500 || status == 503 || status == 501;
    }

    protected void addFilter(String className) {
        try {
            Class<?> clazz = Class.forName(className);
            Object obj = clazz.newInstance();
            if (obj instanceof InputFilter) {
                this.inputBuffer.addFilter((InputFilter)obj);
            } else if (obj instanceof OutputFilter) {
                this.outputBuffer.addFilter((OutputFilter)obj);
            } else {
                logger.log(Level.WARNING, "processorTask.unknownFilter", className);
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "processorTask.errorFilter", new Object[]{className, e});
        }
    }

    public void setMaxKeepAliveRequests(int mkar) {
        this.maxKeepAliveRequests = mkar;
    }

    public int getMaxKeepAliveRequests() {
        return this.maxKeepAliveRequests;
    }

    public void setMaxPostSize(int mps) {
        this.maxPostSize = mps;
    }

    public int getMaxPostSize() {
        return this.maxPostSize;
    }

    public void setSocket(Socket socket) throws IOException {
        this.socket = socket;
    }

    public void setDisableUploadTimeout(boolean isDisabled) {
        this.disableUploadTimeout = isDisabled;
    }

    public boolean getDisableUploadTimeout() {
        return this.disableUploadTimeout;
    }

    public void setTimeout(int timeouts) {
        this.timeout = timeouts;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setSSLImplementation(SSLImplementation sslImplementation) {
        this.sslImplementation = sslImplementation;
    }

    public void setUseMonitoring(boolean useMonitoring) {
        ProcessorTask.useMonitoring = useMonitoring;
        this.hasRequestInfoRegistered = false;
    }

    public boolean getUseMonitoring() {
        return useMonitoring;
    }

    private void registerMonitoring() {
        try {
            RequestInfo requestInfo = this.request.getRequestProcessor();
            requestInfo.setGlobalProcessor(this.requestGroupInfo);
            ObjectName objectName = new ObjectName(this.selectorThread.getDomain() + ":type=RequestProcessor,worker=http" + this.selectorThread.getPort() + ",name=HttpRequest" + requestCount++);
            Registry.getRegistry().registerComponent((Object)requestInfo, objectName, null);
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, "processorTask.errorRegisteringRequest", ex);
        }
        this.hasRequestInfoRegistered = true;
    }

    public int getMaxHttpHeaderSize() {
        return maxHttpHeaderSize;
    }

    public void setMaxHttpHeaderSize(int maxHttpHeaderSize) {
        ProcessorTask.maxHttpHeaderSize = maxHttpHeaderSize;
    }

    public void setBufferSize(int requestBufferSize) {
        this.requestBufferSize = requestBufferSize;
    }

    public int getBufferSize() {
        return this.requestBufferSize;
    }

    static {
        ProcessorTask.configureProperties();
    }
}

