/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web.connector.coyote;

import com.sun.enterprise.web.PwcWebModule;
import com.sun.enterprise.web.session.SessionCookieConfig;
import com.sun.logging.LogDomains;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.Cookie;
import org.apache.catalina.Context;
import org.apache.coyote.tomcat5.CoyoteConnector;
import org.apache.coyote.tomcat5.CoyoteRequest;
import org.apache.coyote.tomcat5.CoyoteResponse;
import org.apache.tomcat.util.http.Parameters;

public class PECoyoteRequest
extends CoyoteRequest {
    private static Logger logger = LogDomains.getLogger("javax.enterprise.system.container.web");
    private boolean requestEncodingSet = false;

    public void setContext(Context ctx) {
        super.setContext(ctx);
        CoyoteResponse response = (CoyoteResponse)this.getResponse();
        if (response != null) {
            String[] cacheControls = ((PwcWebModule)ctx).getCacheControls();
            for (int i = 0; cacheControls != null && i < cacheControls.length; ++i) {
                response.addHeader("Cache-Control", cacheControls[i]);
            }
        }
        this.requestEncodingSet = false;
    }

    public BufferedReader getReader() throws IOException {
        this.setRequestEncoding();
        return super.getReader();
    }

    public String getCharacterEncoding() {
        String enc = super.getCharacterEncoding();
        if (enc != null) {
            return enc;
        }
        this.setRequestEncoding();
        return super.getCharacterEncoding();
    }

    public void configureSessionCookie(Cookie cookie) {
        super.configureSessionCookie(cookie);
        PwcWebModule wm = (PwcWebModule)this.getContext();
        SessionCookieConfig cookieConfig = wm.getSessionCookieConfig();
        if (cookieConfig != null) {
            String name = cookieConfig.getName();
            if (name != null && !name.equals("JSESSIONID")) {
                logger.log(Level.WARNING, "pe_coyote.request.illegal_cookie_name", new String[]{name, "JSESSIONID"});
            }
            if (cookieConfig.getPath() != null) {
                cookie.setPath(cookieConfig.getPath());
            }
            cookie.setMaxAge(cookieConfig.getMaxAge());
            if (cookieConfig.getDomain() != null) {
                cookie.setDomain(cookieConfig.getDomain());
            }
            if (cookieConfig.getComment() != null) {
                cookie.setVersion(1);
                cookie.setComment(cookieConfig.getComment());
            }
        }
    }

    private void setRequestEncoding() {
        if (this.requestEncodingSet) {
            return;
        }
        this.requestEncodingSet = true;
        if (super.getCharacterEncoding() != null) {
            return;
        }
        PwcWebModule wm = (PwcWebModule)this.getContext();
        String encoding = this.getFormHintFieldEncoding(wm);
        if (encoding == null && (encoding = wm.getDefaultCharset()) == null && wm.hasLocaleToCharsetMapping()) {
            encoding = wm.mapLocalesToCharset(this.getLocales());
        }
        if (encoding != null) {
            try {
                this.setCharacterEncoding(encoding);
            }
            catch (UnsupportedEncodingException uee) {
                logger.log(Level.WARNING, "pe_coyote.request.encoding", uee);
            }
        }
    }

    private String getFormHintFieldEncoding(PwcWebModule wm) {
        String encoding = null;
        String formHintField = wm.getFormHintField();
        if (formHintField == null) {
            return null;
        }
        if (this.getMethod().equalsIgnoreCase("POST")) {
            encoding = this.getPostDataEncoding(formHintField);
        } else {
            String query = this.getQueryString();
            if (query != null) {
                encoding = this.parseFormHintField(query, formHintField);
            }
        }
        return encoding;
    }

    private String getPostDataEncoding(String formHintField) {
        int semicolon;
        if (!this.getMethod().equalsIgnoreCase("POST")) {
            return null;
        }
        String contentType = this.getContentType();
        if (contentType == null) {
            contentType = "";
        }
        if (!"application/x-www-form-urlencoded".equals(contentType = (semicolon = contentType.indexOf(59)) >= 0 ? contentType.substring(0, semicolon).trim() : contentType.trim())) {
            return null;
        }
        int len = this.getContentLength();
        if (len <= 0) {
            return null;
        }
        int maxPostSize = ((CoyoteConnector)this.connector).getMaxPostSize();
        if (maxPostSize > 0 && len > maxPostSize) {
            logger.log(Level.WARNING, "peCoyoteRequest.postTooLarge");
            throw new IllegalStateException("Post too large");
        }
        String encoding = null;
        try {
            byte[] formData = null;
            if (len < CACHED_POST_LEN) {
                if (this.postData == null) {
                    this.postData = new byte[CACHED_POST_LEN];
                }
                formData = this.postData;
            } else {
                formData = new byte[len];
            }
            int actualLen = this.readPostBody(formData, len);
            if (actualLen == len) {
                String formDataString = new String(formData).substring(0, len);
                encoding = this.parseFormHintField(formDataString, formHintField);
                Parameters parameters = this.coyoteRequest.getParameters();
                if (encoding != null) {
                    parameters.setEncoding(encoding);
                    parameters.setQueryStringEncoding(encoding);
                } else {
                    parameters.setEncoding("ISO-8859-1");
                    parameters.setQueryStringEncoding("ISO-8859-1");
                }
                parameters.processParameters(formData, 0, len);
                this.requestParametersParsed = true;
            }
        }
        catch (Throwable t) {
            // empty catch block
        }
        return encoding;
    }

    private String parseFormHintField(String paramsString, String formHintField) {
        String encoding = null;
        int index = paramsString.indexOf(formHintField = formHintField + "=");
        if (index != -1) {
            int endIndex = paramsString.indexOf(38, index);
            encoding = endIndex != -1 ? paramsString.substring(index + formHintField.length(), endIndex) : paramsString.substring(index + formHintField.length());
        }
        return encoding;
    }
}

