/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web;

import com.sun.appserv.server.ServerLifecycleException;
import com.sun.enterprise.admin.common.PasswordConfReader;
import com.sun.enterprise.admin.monitor.registry.MonitoringLevelListener;
import com.sun.enterprise.admin.monitor.registry.MonitoringRegistrationException;
import com.sun.enterprise.admin.monitor.registry.MonitoringRegistry;
import com.sun.enterprise.admin.monitor.stats.HTTPListenerStats;
import com.sun.enterprise.admin.monitor.stats.PWCVirtualServerStats;
import com.sun.enterprise.config.ConfigBean;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.ElementProperty;
import com.sun.enterprise.config.serverbeans.HttpListener;
import com.sun.enterprise.config.serverbeans.HttpService;
import com.sun.enterprise.config.serverbeans.ServerBeansFactory;
import com.sun.enterprise.config.serverbeans.Ssl;
import com.sun.enterprise.server.ServerContext;
import com.sun.enterprise.util.StringUtils;
import com.sun.enterprise.web.MimeMap;
import com.sun.enterprise.web.PEAccessLogValve;
import com.sun.enterprise.web.VirtualServer;
import com.sun.enterprise.web.VirtualServerValve;
import com.sun.enterprise.web.WebContainer;
import com.sun.enterprise.web.connector.coyote.PECoyoteConnector;
import com.sun.enterprise.web.stats.HTTPListenerStatsImpl;
import com.sun.enterprise.web.stats.PWCVirtualServerStatsImpl;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.logging.Level;
import org.apache.catalina.Connector;
import org.apache.catalina.Container;
import org.apache.catalina.Engine;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.core.StandardEngine;
import org.apache.catalina.core.StandardHost;
import org.apache.catalina.startup.Embedded;
import org.apache.coyote.tomcat5.CoyoteConnector;

public class PEWebContainer
extends WebContainer
implements MonitoringLevelListener {
    private HashMap mimeMap;
    private HashMap connectorMap;
    private boolean installAccessLogValve = true;
    private String accessLogBufferSize = null;
    private String accessLogWriteInterval = null;

    protected PEWebContainer(String id, ServerContext context) {
        super(id, context);
    }

    protected void init(ServerContext context) {
        this.connectorMap = new HashMap();
        Config config = null;
        ConfigContext configContext = context.getConfigContext();
        try {
            config = ServerBeansFactory.getConfigBean(configContext);
        }
        catch (ConfigException e) {
            String msg = _rb.getString("vs.appsConfigError");
            Object[] params = new Object[]{};
            msg = MessageFormat.format(msg, params);
            _logger.log(Level.SEVERE, msg, e);
        }
        this.createEngine();
        HttpService httpService = config.getHttpService();
        this.createConnectors(httpService);
        this.createJKConnector();
        this.createHosts(httpService, this.installAccessLogValve);
    }

    private void createJKConnector() {
        int port = 8009;
        int defaultRedirectPort = -1;
        String portString = System.getProperty("com.sun.enterprise.web.connector.enableJK");
        if (portString == null) {
            return;
        }
        try {
            port = Integer.parseInt(portString);
        }
        catch (NumberFormatException ex) {
            port = 8009;
        }
        Connector connector = ((Embedded)this._embedded).createConnector("0.0.0.0", port, "ajp");
        String defaultHost = "server";
        Container[] virtualServers = this._embedded.getEngines()[0].findChildren();
        for (int i = 0; i < virtualServers.length; ++i) {
            if (virtualServers[i].getName().equalsIgnoreCase("__asadmin")) continue;
            defaultHost = virtualServers[i].getName();
            break;
        }
        connector.setDefaultHost(defaultHost);
        _logger.log(Level.INFO, "Apache mod_jk/jk2 attached to virtual-server " + defaultHost + " listening on port: " + portString);
        this._embedded.addConnector(connector);
    }

    private void createConnectors(HttpService httpService) {
        int port = 8080;
        int defaultRedirectPort = -1;
        HttpListener[] httpListeners = httpService.getHttpListener();
        ElementProperty[] httpServiceProps = httpService.getElementProperty();
        if (httpListeners != null) {
            Connector[] connectors = new Connector[httpListeners.length];
            for (int i = 0; i < httpListeners.length; ++i) {
                String address;
                this.checkHostnameUniqueness(httpListeners[i].getId(), httpService);
                try {
                    port = Integer.parseInt(httpListeners[i].getPort());
                }
                catch (NumberFormatException nfe) {
                    nfe.printStackTrace();
                    String msg = _rb.getString("pewebcontainer.http_listener.invalid_port");
                    msg = MessageFormat.format(msg, httpListeners[i].getPort(), httpListeners[i].getId());
                    throw new IllegalArgumentException(msg);
                }
                boolean isSecure = httpListeners[i].isSecurityEnabled();
                if (isSecure && defaultRedirectPort == -1) {
                    defaultRedirectPort = port;
                }
                if ("any".equals(address = httpListeners[i].getAddress()) || "ANY".equals(address) || "INADDR_ANY".equals(address)) {
                    address = null;
                }
                PECoyoteConnector connector = (PECoyoteConnector)this._embedded.createConnector(address, port, isSecure);
                this.configureConnector(connector, httpListeners[i], isSecure, httpServiceProps);
                _logger.log(Level.FINE, "create.listenerport", new Object[]{new Integer(port), connector});
                this._embedded.addConnector(connector);
                this.connectorMap.put(httpListeners[i].getId(), connector);
            }
            this.setDefaultRedirectPort(defaultRedirectPort);
        }
    }

    private void setDefaultRedirectPort(int defaultRedirectPort) {
        if (defaultRedirectPort != -1) {
            Connector[] connectors = this._embedded.getConnectors();
            for (int i = 0; i < connectors.length; ++i) {
                if (connectors[i].getRedirectPort() != -1) continue;
                connectors[i].setRedirectPort(defaultRedirectPort);
            }
        }
    }

    protected void createEngine() {
        String engineName = "com.sun.appserv";
        Engine engine = this._embedded.createEngine();
        this._embedded.addEngine(engine);
        ((StandardEngine)engine).setName(engineName);
        if (this.isTomcatUsingDefaultDomain()) {
            ((StandardEngine)engine).setDomain(this._serverContext.getDefaultDomainName());
        } else {
            ((StandardEngine)engine).setDomain(engineName);
        }
        _logger.log(Level.FINE, "Creating Engine " + engineName);
    }

    protected HttpListener findHttpListener(HttpService httpService, String id) {
        HttpListener[] list = httpService.getHttpListener();
        for (int i = 0; i < list.length; ++i) {
            if (!list[i].getId().equalsIgnoreCase(id)) continue;
            return list[i];
        }
        return null;
    }

    protected void createHosts(HttpService httpService, boolean configureAccessLog) {
        Engine[] engines = this._embedded.getEngines();
        String docroot = null;
        MimeMap mm = null;
        com.sun.enterprise.config.serverbeans.VirtualServer[] vses = httpService.getVirtualServer();
        for (int j = 0; j < vses.length; ++j) {
            List values;
            String cacheControl;
            String vs_id = vses[j].getId();
            if (vses[j].getElementPropertyByName("docroot") != null) {
                docroot = vses[j].getElementPropertyByName("docroot").getValue();
                boolean isValid = new File(docroot).exists();
                if (!isValid && vses[j].getDefaultWebModule() == null) {
                    String msg = _rb.getString("pewebcontainer.virtual_server.invalid_docroot");
                    msg = MessageFormat.format(msg, vs_id, docroot);
                    throw new IllegalArgumentException(msg);
                }
                if (!isValid) {
                    _logger.log(Level.WARNING, "virtual-server " + vs_id + " has an invalid docroot: " + docroot);
                }
            } else if (vses[j].getDefaultWebModule() == null) {
                String msg = _rb.getString("pewebcontainer.virtual_server.missing_docroot");
                msg = MessageFormat.format(msg, vs_id);
                throw new IllegalArgumentException(msg);
            }
            VirtualServer vs = this.createVS(vs_id, vses[j], docroot, vses[j].getLogFile(), mm);
            ElementProperty cacheProp = vses[j].getElementPropertyByName("setCacheControl");
            if (cacheProp != null && (cacheControl = cacheProp.getValue()) != null && (values = StringUtils.parseStringList((String)cacheControl, (String)",")) != null && !values.isEmpty()) {
                String[] cacheControls = new String[values.size()];
                vs.setCacheControls(values.toArray(cacheControls));
            }
            if (configureAccessLog) {
                this.setAccessLog(vs, vs_id, vses[j]);
            }
            _logger.log(Level.INFO, "Created virtual server " + vs_id);
            engines[0].addChild(vs);
            this.configureHost(vs, httpService);
        }
    }

    protected void configureHost(VirtualServer vs, HttpService httpService) {
        com.sun.enterprise.config.serverbeans.VirtualServer vsBean = vs.getBean();
        List hosts = StringUtils.parseStringList((String)vsBean.getHosts(), (String)",");
        for (int i = 0; i < hosts.size(); ++i) {
            String alias = hosts.get(i).toString();
            if (alias.equalsIgnoreCase("localhost.localdomain")) continue;
            vs.addAlias(alias);
        }
        List listeners = StringUtils.parseStringList((String)vsBean.getHttpListeners(), (String)",");
        if (listeners == null) {
            return;
        }
        int[] ports = new int[listeners.size()];
        ListIterator iter = listeners.listIterator();
        int i = 0;
        while (iter.hasNext()) {
            HttpListener listener = this.findHttpListener(httpService, iter.next().toString());
            if (listener == null) continue;
            CoyoteConnector conn = (CoyoteConnector)this.connectorMap.get(listener.getId());
            ports[i++] = conn.getPort();
            if (listener.isEnabled()) continue;
            if (vs.getName().equalsIgnoreCase("__asadmin")) {
                throw new IllegalArgumentException("http-listener __asadmin enabled property cannot be modified");
            }
            if (vs.getValve() == null) {
                VirtualServerValve virtualServerValve = new VirtualServerValve();
                vs.addValve(virtualServerValve);
                vs.setValve(virtualServerValve);
            }
            vs.getValve().addDisabledConnector(conn);
        }
        vs.setPorts(ports);
    }

    public static WebContainer createInstance(ServerContext context) {
        webContainer = new PEWebContainer(new String("0"), context);
        _logger.log(Level.FINE, "Creating new instance of PEWebContainer.");
        ((PEWebContainer)webContainer).init(context);
        _logger.log(Level.FINE, "Initialization of PEWebContainer.");
        return webContainer;
    }

    public void startInstance() throws ServerLifecycleException {
        _logger.log(Level.INFO, "pewebcontainer.start");
        try {
            super.start();
        }
        catch (LifecycleException le) {
            Throwable ex = le.getThrowable();
            if (ex == null) {
                ex = le;
            }
            String msg = _rb.getString("webcontainer.startError");
            throw new ServerLifecycleException(msg, ex);
        }
        this.enableVirtualServerMonitoring();
        this.enableHttpListenerMonitoring();
    }

    public void stopInstance() throws ServerLifecycleException {
        _logger.log(Level.INFO, "pewebcontainer.stop");
        try {
            super.stop();
        }
        catch (LifecycleException le) {
            Throwable ex = le.getThrowable();
            if (ex == null) {
                ex = le;
            }
            String msg = _rb.getString("webcontainer.stopError");
            throw new ServerLifecycleException(msg, ex);
        }
    }

    public static PEWebContainer getPEWebContainer() {
        return (PEWebContainer)webContainer;
    }

    protected void setAccessLog(StandardHost vs, String vsId, com.sun.enterprise.config.serverbeans.VirtualServer vsBean) {
        String accessLog = "access";
        if (vsBean.getElementPropertyByName("accesslog") != null) {
            accessLog = vsBean.getElementPropertyByName("accesslog").getValue();
        }
        if (accessLog != null) {
            File dir = new File(accessLog);
            if (!dir.isAbsolute()) {
                String logRoot = this.domain.getLogRoot();
                dir = logRoot != null ? new File(logRoot, accessLog) : new File(this.instance.getInstancesRoot(), accessLog);
            }
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "Setting accesslog directory for virtual server '" + vsId + "' to " + dir.getAbsolutePath());
            }
            PEAccessLogValve accessLogValve = new PEAccessLogValve();
            accessLogValve.setDirectory(dir.getAbsolutePath());
            accessLogValve.setPrefix(vsId + "_access_log.");
            accessLogValve.setSuffix(".txt");
            accessLogValve.setPattern("common");
            accessLogValve.setResolveHosts(false);
            if (vsBean.getElementPropertyByName("accessLogWriteInterval") != null) {
                this.accessLogWriteInterval = vsBean.getElementPropertyByName("accessLogWriteInterval").getValue();
            }
            if (this.accessLogWriteInterval != null) {
                accessLogValve.setWriterInterval(Integer.parseInt(this.accessLogWriteInterval));
            }
            if (vsBean.getElementPropertyByName("accessLogBufferSize") != null) {
                this.accessLogBufferSize = vsBean.getElementPropertyByName("accessLogBufferSize").getValue();
            }
            if (this.accessLogBufferSize != null) {
                accessLogValve.setBufferSize(Integer.parseInt(this.accessLogBufferSize));
            }
            vs.addValve(accessLogValve);
        }
    }

    private void configureConnector(PECoyoteConnector connector, HttpListener httpListener, boolean isSecure, ElementProperty[] httpServiceProps) {
        ElementProperty prop;
        String redirectPort;
        Ssl sslConfig = httpListener.getSsl();
        if (sslConfig != null) {
            String ciphers;
            if (sslConfig.isClientAuthEnabled()) {
                connector.setClientAuth(true);
            }
            StringBuffer sslProtocolsBuf = new StringBuffer();
            boolean needComma = false;
            if (sslConfig.isSsl2Enabled()) {
                sslProtocolsBuf.append("SSLv2");
                needComma = true;
            }
            if (sslConfig.isSsl3Enabled()) {
                if (needComma) {
                    sslProtocolsBuf.append(", ");
                } else {
                    needComma = true;
                }
                sslProtocolsBuf.append("SSLv3");
            }
            if (sslConfig.isTlsEnabled()) {
                if (needComma) {
                    sslProtocolsBuf.append(", ");
                }
                sslProtocolsBuf.append("TLSv1");
            }
            if (sslConfig.isSsl3Enabled() || sslConfig.isTlsEnabled()) {
                sslProtocolsBuf.append(", SSLv2Hello");
            }
            if (sslProtocolsBuf.length() == 0) {
                _logger.log(Level.WARNING, "pewebcontainer.all_ssl_protocols_disabled", httpListener.getId());
            } else {
                connector.setSslProtocols(sslProtocolsBuf.toString());
            }
            String certNickname = sslConfig.getCertNickname();
            if (certNickname != null && certNickname.length() > 0) {
                connector.setKeyAlias(sslConfig.getCertNickname());
            }
            if ((ciphers = sslConfig.getSsl3TlsCiphers()) != null) {
                String jsseCiphers = this.getJSSECiphers(ciphers);
                if (jsseCiphers == null) {
                    _logger.log(Level.WARNING, "pewebcontainer.all_ciphers_disabled", httpListener.getId());
                } else {
                    connector.setCiphers(jsseCiphers);
                }
            }
        }
        connector.setDefaultHost(httpListener.getDefaultVirtualServer());
        connector.setXpoweredBy(httpListener.isXpoweredBy());
        String serverName = httpListener.getServerName();
        if (serverName != null && serverName.length() > 0) {
            int index = serverName.indexOf(58);
            if (index != -1) {
                connector.setProxyName(serverName.substring(0, index).trim());
                String serverPort = serverName.substring(index + 1).trim();
                if (serverPort.length() > 0) {
                    try {
                        connector.setProxyPort(Integer.parseInt(serverPort));
                    }
                    catch (NumberFormatException nfe) {
                        _logger.log(Level.SEVERE, "pewebcontainer.invalid_proxy_port", new Object[]{serverPort, httpListener.getId()});
                    }
                }
            } else {
                connector.setProxyName(serverName);
            }
        }
        if ((redirectPort = httpListener.getRedirectPort()) != null && !redirectPort.equals("")) {
            try {
                connector.setRedirectPort(Integer.parseInt(redirectPort));
            }
            catch (NumberFormatException nfe) {
                _logger.log(Level.WARNING, "pewebcontainer.invalid_redirect_port", new Object[]{redirectPort, httpListener.getId(), Integer.toString(connector.getRedirectPort())});
            }
        } else {
            connector.setRedirectPort(-1);
        }
        String acceptorThreads = httpListener.getAcceptorThreads();
        if (acceptorThreads != null) {
            try {
                connector.setMaxProcessors(Integer.parseInt(acceptorThreads));
            }
            catch (NumberFormatException nfe) {
                _logger.log(Level.WARNING, "pewebcontainer.invalid_acceptor_threads", new Object[]{acceptorThreads, httpListener.getId(), Integer.toString(connector.getMaxProcessors())});
            }
        }
        if (isSecure) {
            String ksFile = System.getProperty("javax.net.ssl.keyStore");
            if (ksFile != null) {
                connector.setKeystoreFile(ksFile);
            }
            String ksPasswd = null;
            try {
                ksPasswd = PasswordConfReader.getKeyStorePassword();
            }
            catch (IOException ioe) {
                // empty catch block
            }
            if (ksPasswd == null) {
                ksPasswd = System.getProperty("javax.net.ssl.keyStorePassword");
            }
            if (ksPasswd != null) {
                try {
                    connector.setKeystorePass(ksPasswd);
                }
                catch (Exception e) {
                    _logger.log(Level.SEVERE, "pewebcontainer.http_listener_keystore_password_exception", e);
                }
            }
        }
        if ((prop = httpListener.getElementPropertyByName("chunkingDisabled")) == null) {
            prop = httpListener.getElementPropertyByName("chunking-disabled");
        }
        if (prop != null) {
            connector.setChunkingDisabled(ConfigBean.toBoolean(prop.getValue()));
        }
        if (httpServiceProps != null) {
            for (int i = 0; i < httpServiceProps.length; ++i) {
                String propName = httpServiceProps[i].getName();
                String propValue = httpServiceProps[i].getValue();
                if ("bufferSize".equals(propName)) {
                    connector.setBufferSize(Integer.parseInt(propValue));
                    continue;
                }
                if ("connectionTimeout".equals(propName)) {
                    connector.setConnectionTimeout(Integer.parseInt(propValue));
                    continue;
                }
                if ("maxKeepAliveRequests".equals(propName)) {
                    connector.setMaxKeepAliveRequests(Integer.parseInt(propValue));
                    continue;
                }
                if ("tcpNoDelay".equals(propName)) {
                    connector.setTcpNoDelay(ConfigBean.toBoolean(propValue));
                    continue;
                }
                if ("traceEnabled".equals(propName)) {
                    connector.setAllowTrace(ConfigBean.toBoolean(propValue));
                    continue;
                }
                if ("accessLoggingEnabled".equals(propName)) {
                    this.installAccessLogValve = ConfigBean.toBoolean(propValue);
                    continue;
                }
                if ("accessLogWriteInterval".equals(propName)) {
                    this.accessLogWriteInterval = propValue;
                    continue;
                }
                if ("accessLogBufferSize".equals(propName)) {
                    this.accessLogBufferSize = propValue;
                    continue;
                }
                if ("authPassthroughEnabled".equals(propName)) {
                    connector.setAuthPassthroughEnabled(ConfigBean.toBoolean(propValue));
                    continue;
                }
                _logger.log(Level.WARNING, "pewebcontainer.invalid_http_service_property", httpServiceProps[i].getName());
            }
        }
    }

    private String getJSSECiphers(String ciphers) {
        String cipher = null;
        StringBuffer enabledCiphers = null;
        boolean first = true;
        int index = ciphers.indexOf(44);
        if (index != -1) {
            int fromIndex = 0;
            while (index != -1) {
                cipher = ciphers.substring(fromIndex, index).trim();
                if (cipher.length() > 0 && !cipher.startsWith("-")) {
                    String jsseCipher;
                    if (cipher.startsWith("+")) {
                        cipher = cipher.substring(1);
                    }
                    if ((jsseCipher = this.getJSSECipher(cipher)) == null) {
                        _logger.log(Level.WARNING, "pewebcontainer.unrecognized_cipher", cipher);
                    } else {
                        if (enabledCiphers == null) {
                            enabledCiphers = new StringBuffer();
                        }
                        if (!first) {
                            enabledCiphers.append(", ");
                        } else {
                            first = false;
                        }
                        enabledCiphers.append(jsseCipher);
                    }
                }
                fromIndex = index + 1;
                index = ciphers.indexOf(44, fromIndex);
            }
            cipher = ciphers.substring(fromIndex);
        } else {
            cipher = ciphers;
        }
        if (cipher != null && (cipher = cipher.trim()).length() > 0 && !cipher.startsWith("-")) {
            String jsseCipher;
            if (cipher.startsWith("+")) {
                cipher = cipher.substring(1);
            }
            if ((jsseCipher = this.getJSSECipher(cipher)) == null) {
                _logger.log(Level.WARNING, "pewebcontainer.unrecognized_cipher", cipher);
            } else {
                if (enabledCiphers == null) {
                    enabledCiphers = new StringBuffer();
                }
                if (!first) {
                    enabledCiphers.append(", ");
                } else {
                    first = false;
                }
                enabledCiphers.append(jsseCipher);
            }
        }
        return enabledCiphers == null ? null : enabledCiphers.toString();
    }

    private String getJSSECipher(String cipher) {
        String jsseCipher = null;
        if ("rsa_rc4_128_md5".equals(cipher)) {
            jsseCipher = "SSL_RSA_WITH_RC4_128_MD5";
        } else if ("rsa_3des_sha".equals(cipher)) {
            jsseCipher = "SSL_RSA_WITH_3DES_EDE_CBC_SHA";
        } else if ("rsa_des_sha".equals(cipher)) {
            jsseCipher = "SSL_RSA_WITH_DES_CBC_SHA";
        } else if ("rsa_rc4_40_md5".equals(cipher)) {
            jsseCipher = "SSL_RSA_EXPORT_WITH_RC4_40_MD5";
        } else if ("rsa_null_md5".equals(cipher)) {
            jsseCipher = "SSL_RSA_WITH_NULL_MD5";
        } else if ("rsa_des_56_sha".equals(cipher)) {
            jsseCipher = "SSL_RSA_WITH_DES_CBC_SHA";
        } else if ("rsa_rc4_56_sha".equals(cipher)) {
            jsseCipher = "SSL_RSA_WITH_RC4_128_SHA";
        }
        return jsseCipher;
    }

    public void enableHttpListenerMonitoring() {
        HttpService httpService;
        ServerContext sc = this.getServerContext();
        ConfigContext cc = sc.getConfigContext();
        MonitoringRegistry mReg = sc.getMonitoringRegistry();
        try {
            httpService = ServerBeansFactory.getHttpServiceBean(cc);
        }
        catch (ConfigException ce) {
            _logger.log(Level.WARNING, "Unable to find HttpServiceBean in config", ce);
            return;
        }
        com.sun.enterprise.config.serverbeans.VirtualServer[] vs = httpService.getVirtualServer();
        for (int i = 0; i < vs.length; ++i) {
            List listeners;
            String vsId = vs[i].getId();
            if (vsId.equalsIgnoreCase("__asadmin") || (listeners = StringUtils.parseStringList((String)vs[i].getHttpListeners(), (String)",")) == null) continue;
            ListIterator iter = listeners.listIterator();
            while (iter.hasNext()) {
                HttpListener currentListener = this.findHttpListener(httpService, iter.next().toString());
                int port = Integer.parseInt(currentListener.getPort());
                String lsnrName = currentListener.getId();
                HTTPListenerStatsImpl httpStats = this.isTomcatUsingDefaultDomain() ? new HTTPListenerStatsImpl(sc.getDefaultDomainName(), port) : new HTTPListenerStatsImpl(vsId, port);
                try {
                    mReg.registerHttpListenerStats((HTTPListenerStats)httpStats, lsnrName, vsId, null);
                }
                catch (MonitoringRegistrationException mre) {
                    _logger.log(Level.WARNING, "Unable to register HTTP listener for monitoring", mre);
                }
            }
        }
    }

    private void checkHostnameUniqueness(String listenerId, HttpService httpService) {
        int i;
        ArrayList<com.sun.enterprise.config.serverbeans.VirtualServer> listenerVses = null;
        com.sun.enterprise.config.serverbeans.VirtualServer[] vses = httpService.getVirtualServer();
        if (vses == null) {
            return;
        }
        block0: for (i = 0; i < vses.length; ++i) {
            List vsListeners = StringUtils.parseStringList((String)vses[i].getHttpListeners(), (String)",");
            for (int j = 0; vsListeners != null && j < vsListeners.size(); ++j) {
                if (!listenerId.equals((String)vsListeners.get(j))) continue;
                if (listenerVses == null) {
                    listenerVses = new ArrayList<com.sun.enterprise.config.serverbeans.VirtualServer>();
                }
                listenerVses.add(vses[i]);
                continue block0;
            }
        }
        if (listenerVses == null) {
            return;
        }
        for (i = 0; i < listenerVses.size(); ++i) {
            com.sun.enterprise.config.serverbeans.VirtualServer vs = (com.sun.enterprise.config.serverbeans.VirtualServer)listenerVses.get(i);
            List hosts = StringUtils.parseStringList((String)vs.getHosts(), (String)",");
            for (int j = 0; hosts != null && j < hosts.size(); ++j) {
                String host = (String)hosts.get(j);
                for (int k = 0; k < listenerVses.size(); ++k) {
                    if (k <= i) continue;
                    com.sun.enterprise.config.serverbeans.VirtualServer otherVs = (com.sun.enterprise.config.serverbeans.VirtualServer)listenerVses.get(k);
                    List otherHosts = StringUtils.parseStringList((String)otherVs.getHosts(), (String)",");
                    for (int l = 0; otherHosts != null && l < otherHosts.size(); ++l) {
                        if (!host.equals((String)otherHosts.get(l))) continue;
                        _logger.log(Level.SEVERE, "pewebcontainer.duplicate_host_name", new Object[]{host, vs.getId(), otherVs.getId(), listenerId});
                    }
                }
            }
        }
    }

    protected boolean isTomcatUsingDefaultDomain() {
        return true;
    }

    protected void loadAllJ2EEApplicationWebModules() {
    }

    public static WebContainer getInstance() {
        return webContainer;
    }

    private void enableVirtualServerMonitoring() {
        ServerContext sc = this.getServerContext();
        ConfigContext cc = sc.getConfigContext();
        MonitoringRegistry monitoringRegistry = sc.getMonitoringRegistry();
        Engine[] engines = this._embedded.getEngines();
        for (int j = 0; j < engines.length; ++j) {
            Container[] hostArray = engines[j].findChildren();
            for (int i = 0; i < hostArray.length; ++i) {
                VirtualServer vs = (VirtualServer)hostArray[i];
                PWCVirtualServerStatsImpl vsStats = new PWCVirtualServerStatsImpl(vs);
                try {
                    monitoringRegistry.registerPWCVirtualServerStats((PWCVirtualServerStats)vsStats, vs.getID(), null);
                    continue;
                }
                catch (Exception e) {
                    _logger.log(Level.WARNING, "Unable to register PWCVirtualServerStats for " + vs.getID(), e);
                }
            }
        }
    }
}

