/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.FileChannel;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.catalina.HttpResponse;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Request;
import org.apache.catalina.Response;
import org.apache.catalina.util.LifecycleSupport;
import org.apache.catalina.util.StringManager;
import org.apache.catalina.valves.ValveBase;

public final class PEAccessLogValve
extends ValveBase
implements Lifecycle,
Runnable {
    public static final String COMMON_ALIAS = "common";
    public static final String COMMON_PATTERN = "%h %l %u %t \"%r\" %s %b";
    public static final String COMBINED_ALIAS = "combined";
    public static final String COMBINED_PATTERN = "%h %l %u %t \"%r\" %s %b \"%{Referer}i\" \"%{User-Agent}i\"";
    private String dateStamp = "";
    private String directory = "logs";
    protected static final String info = "com.sun.enterprise.web.PEAccessLogValve/1.0";
    protected LifecycleSupport lifecycle = new LifecycleSupport(this);
    protected static final String[] months = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
    private boolean common = false;
    private boolean combined = false;
    private String pattern = null;
    private String prefix = "access_log.";
    private boolean rotatable = true;
    private StringManager sm = StringManager.getManager("com.sun.enterprise.web");
    private boolean started = false;
    private String suffix = "";
    private SimpleDateFormat dateFormatter = null;
    private SimpleDateFormat dayFormatter = null;
    private SimpleDateFormat monthFormatter = null;
    private DecimalFormat timeTakenFormatter = null;
    private SimpleDateFormat yearFormatter = null;
    private SimpleDateFormat timeFormatter = null;
    private String timeZone = null;
    private Date currentDate = null;
    private String space = " ";
    private boolean resolveHosts = false;
    private long rotationLastChecked = 0L;
    private String condition = null;
    private String fileDateFormat = null;
    protected FileChannel fileChannel;
    FileOutputStream fis;
    private int writeInterval = 300;
    private Thread writerThread = null;
    private boolean threadDone = false;
    private ByteBuffer byteBuffer;
    private CharBuffer charBuffer;
    public int chunkSize = 0;
    protected int directByteBufferSize = 32768;
    protected boolean flushRealTime = false;
    private Object[] lock = new Object[0];

    public PEAccessLogValve() {
        this.setPattern(COMMON_ALIAS);
        this.byteBuffer = ByteBuffer.allocateDirect(this.directByteBufferSize);
        this.charBuffer = CharBuffer.allocate(this.directByteBufferSize);
    }

    public int getWriterInterval() {
        return this.writeInterval;
    }

    public void setWriterInterval(int t) {
        this.writeInterval = t;
    }

    public void setBufferSize(int size) {
        this.directByteBufferSize = size;
    }

    public int getBufferSize() {
        return this.directByteBufferSize;
    }

    public String getDirectory() {
        return this.directory;
    }

    public void setDirectory(String directory) {
        this.directory = directory;
    }

    public String getInfo() {
        return info;
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        if (pattern == null) {
            pattern = "";
        }
        if (pattern.equals(COMMON_ALIAS)) {
            pattern = COMMON_PATTERN;
        }
        if (pattern.equals(COMBINED_ALIAS)) {
            pattern = COMBINED_PATTERN;
        }
        this.pattern = pattern;
        this.common = this.pattern.equals(COMMON_PATTERN);
        this.combined = this.pattern.equals(COMBINED_PATTERN);
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public boolean isRotatable() {
        return this.rotatable;
    }

    public void setRotatable(boolean rotatable) {
        this.rotatable = rotatable;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    public void setResolveHosts(boolean resolveHosts) {
        this.resolveHosts = resolveHosts;
    }

    public boolean isResolveHosts() {
        return this.resolveHosts;
    }

    public String getCondition() {
        return this.condition;
    }

    public void setCondition(String condition) {
        this.condition = condition;
    }

    public String getFileDateFormat() {
        return this.fileDateFormat;
    }

    public void setFileDateFormat(String fileDateFormat) {
        this.fileDateFormat = fileDateFormat;
    }

    public int invoke(Request request, Response response) throws IOException, ServletException {
        return 1;
    }

    public synchronized void postInvoke(Request request, Response response) {
        boolean flushBuffer;
        if (this.condition != null && null != request.getRequest().getAttribute(this.condition)) {
            return;
        }
        Date date = this.getDate();
        String value = null;
        ServletRequest req = request.getRequest();
        HttpServletRequest hreq = (HttpServletRequest)req;
        int lastPosition = this.charBuffer.position();
        if (this.charBuffer.position() == this.charBuffer.limit()) {
            this.charBuffer.limit(this.charBuffer.capacity());
        }
        boolean bl = flushBuffer = !this.charBuffer.hasRemaining();
        if (this.chunkSize + this.charBuffer.position() > this.charBuffer.limit()) {
            flushBuffer = true;
        }
        if (!flushBuffer) {
            try {
                if (this.isResolveHosts()) {
                    this.charBuffer.put(req.getRemoteHost());
                } else {
                    this.charBuffer.put(req.getRemoteAddr());
                }
                this.charBuffer.put(" - ");
                value = hreq.getRemoteUser();
                if (value == null) {
                    this.charBuffer.put("- ");
                } else {
                    this.charBuffer.put(value);
                    this.charBuffer.put(this.space);
                }
                this.charBuffer.put("[");
                this.charBuffer.put(this.dayFormatter.format(date));
                this.charBuffer.put('/');
                this.charBuffer.put(this.lookup(this.monthFormatter.format(date)));
                this.charBuffer.put('/');
                this.charBuffer.put(this.yearFormatter.format(date));
                this.charBuffer.put(':');
                this.charBuffer.put(this.timeFormatter.format(date));
                this.charBuffer.put(this.space);
                this.charBuffer.put(this.timeZone);
                this.charBuffer.put("] \"");
                this.charBuffer.put(hreq.getMethod());
                this.charBuffer.put(this.space);
                this.charBuffer.put(hreq.getRequestURI());
                if (hreq.getQueryString() != null) {
                    this.charBuffer.put('?');
                    this.charBuffer.put(hreq.getQueryString());
                }
                this.charBuffer.put(this.space);
                this.charBuffer.put(hreq.getProtocol());
                this.charBuffer.put("\" ");
                this.charBuffer.put(String.valueOf(((HttpResponse)response).getStatus()));
                this.charBuffer.put(this.space);
                int length = response.getContentCount();
                value = length <= 0 ? "-" : "" + length;
                this.charBuffer.put(value);
                if (this.combined) {
                    this.charBuffer.put(this.space);
                    this.charBuffer.put("\"");
                    String referer = hreq.getHeader("referer");
                    if (referer != null) {
                        this.charBuffer.put(referer);
                    } else {
                        this.charBuffer.put("-");
                    }
                    this.charBuffer.put("\"");
                    this.charBuffer.put(this.space);
                    this.charBuffer.put("\"");
                    String ua = hreq.getHeader("user-agent");
                    if (ua != null) {
                        this.charBuffer.put(ua);
                    } else {
                        this.charBuffer.put("-");
                    }
                    this.charBuffer.put("\"");
                }
                this.charBuffer.put("\n");
                this.chunkSize = this.charBuffer.position() - lastPosition;
            }
            catch (BufferOverflowException ex) {
                flushBuffer = true;
                this.charBuffer.position(lastPosition);
            }
        }
        if (flushBuffer || this.flushRealTime) {
            this.log(this.getDate());
            if (!this.flushRealTime) {
                this.postInvoke(request, response);
            }
        }
    }

    private synchronized void close() {
        this.dateStamp = "";
        try {
            this.log(this.getDate());
            this.fileChannel.close();
            this.fis.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void log(Date date) {
        long systime;
        if (this.rotatable && (systime = System.currentTimeMillis()) - this.rotationLastChecked > 1000L) {
            this.currentDate = new Date(systime);
            this.rotationLastChecked = systime;
            String tsDate = this.dateFormatter.format(this.currentDate);
            if (!this.dateStamp.equals(tsDate)) {
                PEAccessLogValve pEAccessLogValve = this;
                synchronized (pEAccessLogValve) {
                    if (!this.dateStamp.equals(tsDate)) {
                        this.close();
                        this.dateStamp = tsDate;
                        this.open();
                    }
                }
            }
        }
        try {
            this.charBuffer.flip();
            this.byteBuffer.put(this.charBuffer.toString().getBytes());
            this.byteBuffer.flip();
            while (this.byteBuffer.hasRemaining()) {
                this.fileChannel.write(this.byteBuffer);
            }
            this.charBuffer.clear();
            this.byteBuffer.clear();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private String lookup(String month) {
        int index;
        try {
            index = Integer.parseInt(month) - 1;
        }
        catch (Throwable t) {
            index = 0;
        }
        return months[index];
    }

    private synchronized void open() {
        this.flushRealTime = this.writeInterval == 0;
        File dir = new File(this.directory);
        if (!dir.isAbsolute()) {
            dir = new File(System.getProperty("catalina.base"), this.directory);
        }
        dir.mkdirs();
        try {
            String pathname = this.rotatable ? dir.getAbsolutePath() + File.separator + this.prefix + this.dateStamp + this.suffix : dir.getAbsolutePath() + File.separator + this.prefix + this.suffix;
            this.fis = new FileOutputStream(pathname, true);
            this.fileChannel = this.fis.getChannel();
        }
        catch (IOException e) {
            try {
                this.fileChannel.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private Date getDate() {
        long systime = System.currentTimeMillis();
        if (systime - this.currentDate.getTime() > 1000L) {
            this.currentDate = new Date(systime);
        }
        return this.currentDate;
    }

    private String calculateTimeZoneOffset(long offset) {
        StringBuffer tz = new StringBuffer();
        if (offset < 0L) {
            tz.append("-");
            offset = -offset;
        } else {
            tz.append("+");
        }
        long hourOffset = offset / 3600000L;
        long minuteOffset = offset / 60000L % 60L;
        if (hourOffset < 10L) {
            tz.append("0");
        }
        tz.append(hourOffset);
        if (minuteOffset < 10L) {
            tz.append("0");
        }
        tz.append(minuteOffset);
        return tz.toString();
    }

    public void addLifecycleListener(LifecycleListener listener) {
        this.lifecycle.addLifecycleListener(listener);
    }

    public LifecycleListener[] findLifecycleListeners() {
        return this.lifecycle.findLifecycleListeners();
    }

    public void removeLifecycleListener(LifecycleListener listener) {
        this.lifecycle.removeLifecycleListener(listener);
    }

    public void start() throws LifecycleException {
        if (this.started) {
            throw new LifecycleException(this.sm.getString("accessLogValve.alreadyStarted"));
        }
        this.lifecycle.fireLifecycleEvent("start", null);
        this.started = true;
        TimeZone tz = TimeZone.getDefault();
        this.timeZone = this.calculateTimeZoneOffset(tz.getRawOffset());
        if (this.fileDateFormat == null || this.fileDateFormat.length() == 0) {
            this.fileDateFormat = "yyyy-MM-dd";
        }
        this.dateFormatter = new SimpleDateFormat(this.fileDateFormat);
        this.dateFormatter.setTimeZone(tz);
        this.dayFormatter = new SimpleDateFormat("dd");
        this.dayFormatter.setTimeZone(tz);
        this.monthFormatter = new SimpleDateFormat("MM");
        this.monthFormatter.setTimeZone(tz);
        this.yearFormatter = new SimpleDateFormat("yyyy");
        this.yearFormatter.setTimeZone(tz);
        this.timeFormatter = new SimpleDateFormat("HH:mm:ss");
        this.timeFormatter.setTimeZone(tz);
        this.currentDate = new Date();
        this.dateStamp = this.dateFormatter.format(this.currentDate);
        this.timeTakenFormatter = new DecimalFormat("0.000");
        this.open();
        if (!this.flushRealTime) {
            this.threadStart();
        }
    }

    public void stop() throws LifecycleException {
        if (!this.started) {
            throw new LifecycleException(this.sm.getString("accessLogValve.notStarted"));
        }
        this.lifecycle.fireLifecycleEvent("stop", null);
        this.started = false;
        if (!this.flushRealTime) {
            this.threadStop();
        }
        this.close();
    }

    public void run() {
        while (!this.threadDone) {
            this.threadSleep();
            this.log(this.getDate());
        }
    }

    private void threadSleep() {
        try {
            Thread.sleep((long)this.writeInterval * 1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void threadStart() {
        if (this.writerThread != null) {
            return;
        }
        this.threadDone = false;
        String threadName = "AccessLogWriter";
        this.writerThread = new Thread((Runnable)this, threadName);
        this.writerThread.setDaemon(true);
        this.writerThread.start();
    }

    private void threadStop() {
        if (this.writerThread == null) {
            return;
        }
        this.threadDone = true;
        this.writerThread.interrupt();
        try {
            this.writerThread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.writerThread = null;
    }
}

