/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.util.cache;

import com.sun.enterprise.util.cache.Cache;

public class ConcurrentCache
implements Cache {
    private int maxBuckets;
    private CBucket[] buckets;
    private int size;

    public ConcurrentCache(int maxBuckets) {
        this.maxBuckets = maxBuckets;
        this.buckets = new CBucket[maxBuckets];
        for (int i = 0; i < maxBuckets; ++i) {
            this.buckets[i] = new CBucket();
        }
        this.size = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(Object key) {
        int keyHashCode = key.hashCode();
        int index = (Integer.MAX_VALUE & keyHashCode) % this.maxBuckets;
        CBucket cBucket = this.buckets[index];
        synchronized (cBucket) {
            CMapNode node = this.buckets[index].first;
            while (node != null) {
                if (node.keyHashCode == keyHashCode && node.key.equals(key)) {
                    return true;
                }
                node = node.next;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getEntry(Object key) {
        CBucket bucket;
        int keyHashCode = key.hashCode();
        int index = (Integer.MAX_VALUE & keyHashCode) % this.maxBuckets;
        CBucket cBucket = bucket = this.buckets[index];
        synchronized (cBucket) {
            CMapNode node = bucket.first;
            while (node != null) {
                if (node.keyHashCode == keyHashCode && node.key.equals(key)) {
                    return node.object;
                }
                node = node.next;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object putEntry(Object key, Object object) {
        int keyHashCode = key.hashCode();
        int index = (Integer.MAX_VALUE & keyHashCode) % this.maxBuckets;
        CBucket cBucket = this.buckets[index];
        synchronized (cBucket) {
            CMapNode node = this.buckets[index].first;
            while (node != null) {
                if (node.keyHashCode == keyHashCode && node.key.equals(key)) {
                    Object oldObject = node.object;
                    node.object = object;
                    return oldObject;
                }
                node = node.next;
            }
            this.buckets[index].first = node = new CMapNode(key, keyHashCode, object, this.buckets[index].first);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object removeEntry(Object key) {
        int keyHashCode = key.hashCode();
        int index = (Integer.MAX_VALUE & keyHashCode) % this.maxBuckets;
        CMapNode prev = null;
        CMapNode node = null;
        CBucket cBucket = this.buckets[index];
        synchronized (cBucket) {
            node = this.buckets[index].first;
            while (node != null) {
                if (node.keyHashCode == keyHashCode && key.equals(node.key)) {
                    if (prev == null) {
                        this.buckets[index].first = node.next;
                    } else {
                        prev.next = node.next;
                    }
                    node.next = null;
                    return node.object;
                }
                prev = node;
                node = node.next;
            }
        }
        return null;
    }

    public String toString() {
        return this.getClass().getName();
    }

    private static class CMapNode {
        Object key;
        Object object;
        int keyHashCode;
        CMapNode next;

        CMapNode() {
        }

        CMapNode(Object key, int keyHashCode, Object object, CMapNode next) {
            this.key = key;
            this.object = object;
            this.keyHashCode = keyHashCode;
            this.next = next;
        }
    }

    private static class CBucket {
        CMapNode first;

        private CBucket() {
        }
    }
}

