/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class MakeZipProto {
    public static String parseFile(String line) {
        StringTokenizer tok = new StringTokenizer(line);
        tok.nextToken();
        tok.nextToken();
        String result = tok.nextToken().replaceAll("\\$ASINSTDIR/", "");
        int pos = result.indexOf("=");
        if (pos > 0) {
            return result.substring(pos + 1);
        }
        return result;
    }

    public static String parse(String line) {
        String result = line.trim();
        if (result.length() == 0) {
            return null;
        }
        if (result.startsWith("#")) {
            return null;
        }
        if (result.startsWith("d ")) {
            return null;
        }
        if (result.startsWith("i ")) {
            return null;
        }
        if (result.startsWith("f ")) {
            return MakeZipProto.parseFile(result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void writeOutputFile(String out, ArrayList fileList) throws FileNotFoundException, IOException {
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new FileWriter(out, false));
            for (int i = 0; i < fileList.size(); ++i) {
                writer.write((String)fileList.get(i));
                writer.newLine();
            }
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            throw throwable;
        }
        try {
            if (writer != null) {
                writer.close();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static ArrayList readInputFile(String in) throws FileNotFoundException, IOException {
        ArrayList<String> arrayList;
        ArrayList<String> result = new ArrayList<String>();
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(in));
            String line = null;
            String newLine = null;
            while ((line = reader.readLine()) != null) {
                newLine = MakeZipProto.parse(line);
                if (newLine == null) continue;
                result.add(newLine);
            }
            arrayList = result;
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            throw throwable;
        }
        try {
            if (reader != null) {
                reader.close();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return arrayList;
    }

    protected static void filesetElement(Node filesetNode, ArrayList fileList) {
        NamedNodeMap attributes = filesetNode.getAttributes();
        Node includes = attributes.getNamedItem("includes");
        if (includes != null) {
            StringTokenizer tok = new StringTokenizer(includes.getNodeValue());
            while (tok.hasMoreTokens()) {
                fileList.add(tok.nextToken());
            }
        }
        ArrayList<String> removeList = new ArrayList<String>();
        Node excludes = attributes.getNamedItem("excludes");
        if (excludes != null) {
            StringTokenizer tok = new StringTokenizer(excludes.getNodeValue());
            while (tok.hasMoreTokens()) {
                removeList.add(tok.nextToken());
            }
        }
        for (int i = 0; i < fileList.size(); ++i) {
            if (!removeList.contains(fileList.get(i))) continue;
            fileList.remove(i--);
        }
    }

    protected static void zipfileElement(Node zipfileNode) throws FileNotFoundException, IOException {
        NamedNodeMap attributes = zipfileNode.getAttributes();
        String inputFile = attributes.getNamedItem("input").getNodeValue();
        System.out.println("inputFile = " + inputFile);
        String outputFile = attributes.getNamedItem("output").getNodeValue();
        System.out.println("output = " + outputFile);
        ArrayList fileList = MakeZipProto.readInputFile(inputFile);
        for (int i = 0; i < fileList.size(); ++i) {
            System.out.println("fileList before " + i + " = " + fileList.get(i));
        }
        NodeList children = zipfileNode.getChildNodes();
        for (int j = 0; j < children.getLength(); ++j) {
            Node childNode = children.item(j);
            if (!childNode.getNodeName().equals("fileset")) continue;
            MakeZipProto.filesetElement(childNode, fileList);
        }
        for (int i = 0; i < fileList.size(); ++i) {
            System.out.println("fileList after " + i + " = " + fileList.get(i));
        }
        MakeZipProto.writeOutputFile(outputFile, fileList);
    }

    protected static void parseXML(String fileName) throws FileNotFoundException, SAXException, IOException, ParserConfigurationException {
        FileInputStream source;
        DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document document = builder.parse(source = new FileInputStream(fileName));
        NodeList nodeList = document.getElementsByTagName("zipfile");
        if (nodeList != null) {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                MakeZipProto.zipfileElement(node);
            }
        }
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.out.println("usage: MakeZipProto xmlFile");
        } else {
            String xmlFile = args[0];
            try {
                MakeZipProto.parseXML(xmlFile);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }
}

