/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.util;

import com.sun.enterprise.loader.EJBClassLoader;
import com.sun.enterprise.server.ResourcesUtil;
import com.sun.logging.LogDomains;
import java.io.File;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ConnectorClassLoader
extends EJBClassLoader {
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.util");
    private static ConnectorClassLoader classLoader = null;
    private List classLoaderChain = new LinkedList();
    private ClassLoader parent = null;
    private Map rarModuleClassLoaders = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ConnectorClassLoader getInstance() {
        if (classLoader == null) {
            Class clazz = ConnectorClassLoader.class;
            synchronized (clazz) {
                classLoader = new ConnectorClassLoader();
            }
        }
        return classLoader;
    }

    private ConnectorClassLoader() {
    }

    private ConnectorClassLoader(ClassLoader parent) {
        super(parent);
        this.parent = parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ConnectorClassLoader getInstance(ClassLoader parent) {
        if (classLoader == null) {
            Class clazz = ConnectorClassLoader.class;
            synchronized (clazz) {
                classLoader = new ConnectorClassLoader(parent);
            }
        }
        return classLoader;
    }

    public void addResourceAdapter(String rarName, String moduleDir) {
        try {
            if (!ResourcesUtil.getInstance().belongToSystemRar(rarName)) {
                File file = new File(moduleDir);
                EJBClassLoader cl = new EJBClassLoader(this.parent);
                cl.appendURL(file.toURL());
                this.classLoaderChain.add(cl);
                this.rarModuleClassLoaders.put(rarName, cl);
            }
        }
        catch (MalformedURLException ex) {
            _logger.log(Level.SEVERE, "enterprise_util.connector_malformed_url", ex);
        }
    }

    public void removeResourceAdapter(String moduleName) {
        EJBClassLoader classLoaderToRemove = (EJBClassLoader)this.rarModuleClassLoaders.get(moduleName);
        if (classLoaderToRemove != null) {
            this.classLoaderChain.remove(classLoaderToRemove);
            this.rarModuleClassLoaders.remove(moduleName);
            classLoaderToRemove = null;
            _logger.log(Level.WARNING, "The Connector module " + moduleName + "  has been removed. Please redeploy all applications that " + "are using this connector module's resources");
        }
    }

    public synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> clz = null;
        if (this.parent != null) {
            try {
                clz = this.parent.loadClass(name);
                if (clz != null) {
                    if (resolve) {
                        this.resolveClass(clz);
                    }
                    return clz;
                }
            }
            catch (ClassNotFoundException e) {}
        } else {
            return super.loadClass(name, resolve);
        }
        Iterator iter = this.classLoaderChain.iterator();
        while (iter.hasNext()) {
            EJBClassLoader ccl = (EJBClassLoader)iter.next();
            try {
                clz = ccl.loadClass(name);
                if (clz == null) continue;
                if (resolve) {
                    this.resolveClass(clz);
                }
                return clz;
            }
            catch (ClassNotFoundException cnfe) {
            }
        }
        throw new ClassNotFoundException(name);
    }

    public String getClasspath() {
        StringBuffer strBuf = new StringBuffer();
        for (int i = 0; i < this.classLoaderChain.size(); ++i) {
            EJBClassLoader ecl = (EJBClassLoader)this.classLoaderChain.get(i);
            String eclClasspath = ecl.getClasspath();
            if (eclClasspath == null) continue;
            if (i > 0) {
                strBuf.append(File.pathSeparator);
            }
            strBuf.append(eclClasspath);
        }
        return strBuf.toString();
    }
}

