/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.web;

import com.sun.enterprise.deployment.TagLibConfigurationDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.archivist.FileArchive;
import com.sun.enterprise.logging.LogDomains;
import com.sun.enterprise.tools.verifier.Context;
import com.sun.enterprise.tools.verifier.StringManagerHelper;
import com.sun.enterprise.tools.verifier.TagLibDescriptor;
import com.sun.enterprise.tools.verifier.web.TagLibDescriptorImpl;
import com.sun.enterprise.tools.verifier.web.TagLibDescriptorImpl1_1;
import com.sun.enterprise.tools.verifier.web.TagLibDescriptorImpl1_2;
import com.sun.enterprise.tools.verifier.web.TagLibDescriptorImpl2_0;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import tools.com.sun.enterprise.util.XMLValidationHandler;

public class TagLibFactory {
    private DocumentBuilder builder;
    private Context context;
    private Logger logger = LogDomains.getLogger("javax.enterprise.system.tools.avk.tools.verifier");
    private boolean uninitialised = false;
    private final LocalStringManagerImpl smh = StringManagerHelper.getLocalStringsManager();

    public TagLibFactory(Context context) {
        this.context = context;
    }

    public TagLibDescriptor[] getTagLibDescriptors(WebBundleDescriptor descriptor) {
        ArrayList<TagLibDescriptorImpl1_1> tmp = new ArrayList<TagLibDescriptorImpl1_1>();
        Enumeration taglibConfig = null;
        if (descriptor.getJspConfigDescriptor() == null) {
            return null;
        }
        taglibConfig = descriptor.getJspConfigDescriptor().getTagLibs();
        this.init();
        while (taglibConfig.hasMoreElements()) {
            TagLibConfigurationDescriptor taglibDescriptor = (TagLibConfigurationDescriptor)taglibConfig.nextElement();
            String taglibLocation = taglibDescriptor.getTagLibLocation();
            Document d = null;
            try {
                d = this.createDocument(taglibLocation, descriptor);
            }
            catch (Exception e) {
                this.logger.log(Level.WARNING, this.smh.getLocalString(this.getClass().getName() + ".exception", "Continuing, though problem in creating taglib document. Cause: {0}", new Object[]{e.getMessage()}));
                continue;
            }
            String version = this.getTLDSpecVersion(d);
            TagLibDescriptorImpl taglib = null;
            if (version.trim().equalsIgnoreCase("1.1")) {
                taglib = new TagLibDescriptorImpl1_1(d, version, taglibLocation);
            }
            if (version.trim().equalsIgnoreCase("1.2")) {
                taglib = new TagLibDescriptorImpl1_2(d, version, taglibLocation);
            } else if (version.trim().equalsIgnoreCase("2.0")) {
                taglib = new TagLibDescriptorImpl2_0(d, version, taglibLocation);
            }
            tmp.add((TagLibDescriptorImpl1_1)taglib);
        }
        int count = tmp.size();
        TagLibDescriptor[] arr = new TagLibDescriptor[count];
        int i = 0;
        Iterator e = tmp.iterator();
        while (e.hasNext()) {
            arr[i] = (TagLibDescriptor)e.next();
            ++i;
        }
        return arr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        if (!this.uninitialised) {
            TagLibFactory tagLibFactory = this;
            synchronized (tagLibFactory) {
                if (!this.uninitialised) {
                    DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                    factory.setNamespaceAware(true);
                    try {
                        this.builder = factory.newDocumentBuilder();
                    }
                    catch (ParserConfigurationException e) {
                        this.logger.log(Level.SEVERE, e.getMessage());
                    }
                    XMLValidationHandler dh = new XMLValidationHandler(false);
                    this.builder.setEntityResolver(dh);
                    this.uninitialised = true;
                }
            }
        }
    }

    private Document createDocument(String location, WebBundleDescriptor webd) throws IOException, SAXException {
        Document document = null;
        InputSource source = null;
        location = location.startsWith("/") ? location.substring(1) : "WEB-INF/" + location;
        String descuri = webd.getModuleDescriptor().getArchiveUri();
        String archBase = this.context.getAbstractArchive().getArchiveUri();
        String uri = null;
        if (descuri.endsWith(".war")) {
            String moduleDir = descuri.replace('.', '_');
            uri = archBase + File.separator + moduleDir;
        } else {
            uri = archBase;
        }
        FileArchive arch = new FileArchive();
        arch.open(uri);
        InputStream is = arch.getEntry(location);
        if (is == null) {
            throw new IOException(this.smh.getLocalString(this.getClass().getName() + ".exception1", "Wrong tld [ {0} ] specified in the web.xml of [ {1} ]", new Object[]{location, descuri}));
        }
        source = new InputSource(is);
        document = this.builder.parse(source);
        return document;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getTLDSpecVersion(Document doc) {
        String str = null;
        if (doc.getDoctype() == null) return doc.getElementsByTagName("taglib").item(0).getAttributes().getNamedItem("version").getNodeValue();
        NodeList nl = doc.getElementsByTagName("jsp-version");
        if (nl != null && nl.getLength() != 0) {
            return nl.item(0).getFirstChild().getNodeValue();
        }
        nl = doc.getElementsByTagName("jspversion");
        if (nl.getLength() == 0) return "1.1";
        return nl.item(0).getFirstChild().getNodeValue();
    }
}

