/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.webservices;

import com.sun.enterprise.deployment.WebServiceEndpoint;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.webservices.WSCheck;
import com.sun.enterprise.tools.verifier.tests.webservices.WSTest;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class WSSchemaLocation
extends WSTest
implements WSCheck {
    String myValue = null;
    private String reqSchemaLocation = "http://java.sun.com/xml/ns/j2ee http://www.ibm.com/webservices/xsd/j2ee_web_services_1_1.xsd";
    private String reqSchemaLocationSub1 = "http://java.sun.com/xml/ns/j2ee";
    private String reqSchemaLocationSub2 = "http://www.ibm.com/webservices/xsd/j2ee_web_services_1_1.xsd";

    public Result check(WebServiceEndpoint descriptor) {
        Result result = this.getInitializedResult();
        ComponentNameConstructor compName = new ComponentNameConstructor(descriptor);
        boolean pass = false;
        try {
            Document wsdoc = this.getVerifierContext().getWebServiceDocument();
            if (wsdoc.getDocumentElement().hasAttributes()) {
                boolean rslt;
                this.getNode(wsdoc);
                if (this.myValue != null && (rslt = this.verifySchema(this.myValue))) {
                    pass = true;
                }
            }
            if (pass) {
                result.addGoodDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                result.passed(smh.getLocalString(this.getClass().getName() + ".passed", "The schemaLocation in the webservices.xml file for [{0}] matches the schema file requirement", new Object[]{compName.toString()}));
            } else {
                result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                result.failed(smh.getLocalString(this.getClass().getName() + ".failed", "The schemaLocation in the webservices.xml file for [{0}] does not match the schema file requirement", new Object[]{compName.toString()}));
            }
        }
        catch (Exception e) {
            result.failed(smh.getLocalString(this.getClass().getName() + ".failed", "The schemaLocation in the webservices.xml file for [{0}] does not match the schema file requirement", new Object[]{compName.toString()}));
            result.addErrorDetails(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.webservices.Error", "Error: Unexpected error occurred [ {0} ]", new Object[]{e.getMessage()}));
        }
        return result;
    }

    private boolean verifySchema(String nodeval) {
        try {
            int off1 = this.reqSchemaLocation.indexOf("http", this.reqSchemaLocationSub1.length());
            int off2 = nodeval.indexOf("http", this.reqSchemaLocationSub1.length());
            if (!this.checkSubString(nodeval, 0, 0, this.reqSchemaLocationSub1.length()) || !this.checkSubString(nodeval, off1, off2, this.reqSchemaLocationSub2.length())) {
                return false;
            }
            if (this.reqSchemaLocation.length() > nodeval.length()) {
                return false;
            }
            for (int i = this.reqSchemaLocationSub1.length(); i < off2; ++i) {
                if (Character.isWhitespace(nodeval.charAt(i))) continue;
                return false;
            }
        }
        catch (Exception e) {
            e.toString();
            e.printStackTrace();
        }
        return true;
    }

    private boolean checkSubString(String str, int off1, int off2, int len) {
        return this.reqSchemaLocation.regionMatches(off1, str, off2, len);
    }

    public void getNode(Node node) {
        Node nextNode;
        String name = node.getNodeName();
        short myType = node.getNodeType();
        if (myType == 1 & name.equals("webservices")) {
            Element e = (Element)node;
            this.myValue = e.getAttribute("xsi:schemaLocation");
            return;
        }
        if (node.hasChildNodes()) {
            Node firstChild = node.getFirstChild();
            this.getNode(firstChild);
        }
        if ((nextNode = node.getNextSibling()) != null) {
            this.getNode(nextNode);
        }
    }
}

