/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.webservices;

import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.WebService;
import com.sun.enterprise.deployment.WebServiceEndpoint;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.webservices.WSCheck;
import com.sun.enterprise.tools.verifier.tests.webservices.WSTest;

public class SmallIcon
extends WSTest
implements WSCheck {
    public Result check(WebServiceEndpoint descriptor) {
        String smallIconString = descriptor.getSmallIconUri();
        Result result = this.doRealCheck(descriptor, smallIconString);
        return result;
    }

    public Result doRealCheck(Descriptor descriptor, String smallIconString) {
        Result result = this.getInitializedResult();
        ComponentNameConstructor compName = null;
        if (descriptor instanceof WebServiceEndpoint) {
            compName = new ComponentNameConstructor((WebServiceEndpoint)descriptor);
        } else if (descriptor instanceof WebService) {
            compName = new ComponentNameConstructor((WebService)descriptor);
        }
        if (compName == null) {
            result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notApplicable", "The small-icon element is not defined within webservice [ {0} ]", new Object[]{compName.toString()}));
            return result;
        }
        if (smallIconString != null) {
            if (!smallIconString.endsWith(".jpg") && !smallIconString.endsWith(".gif")) {
                result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                result.failed(smh.getLocalString(this.getClass().getName() + ".failed", "Error: The small-icon element [ {0} ] must end in .jpg or .gif within webservice [ {1} ]", new Object[]{smallIconString, compName.toString()}));
            } else {
                result.addGoodDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                result.passed(smh.getLocalString(this.getClass().getName() + ".passed", "The small-icon element [ {0} ] ends in .jpg or .gif within webservice [ {1} ]", new Object[]{smallIconString, compName.toString()}));
            }
        } else {
            result.addNaDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
            result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notApplicable", "The small-icon element is not defined within webservice [ {0} ]", new Object[]{compName.toString()}));
        }
        return result;
    }
}

