/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.webservices;

import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.WebComponentDescriptor;
import com.sun.enterprise.deployment.WebServiceEndpoint;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.webservices.WSCheck;
import com.sun.enterprise.tools.verifier.tests.webservices.WSTest;
import java.util.Enumeration;

public class ServletUrlPatternExactCheck
extends WSTest
implements WSCheck {
    public Result check(WebServiceEndpoint desc) {
        Result result = this.getInitializedResult();
        ComponentNameConstructor compName = new ComponentNameConstructor(desc);
        boolean pass = true;
        if (desc.implementedByWebComponent()) {
            Enumeration enumeration;
            WebBundleDescriptor webBundle = (WebBundleDescriptor)desc.getBundleDescriptor();
            WebComponentDescriptor webComponent = webBundle.getWebComponentByCanonicalName(desc.getWebComponentLink());
            if (webComponent != null && webComponent.isServlet() && (enumeration = webComponent.getUrlPatterns()).hasMoreElements()) {
                String pattern = (String)enumeration.nextElement();
                if (pattern.indexOf("*") == -1) {
                    result.addGoodDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                    result.passed(smh.getLocalString(this.getClass().getName() + ".passed", "The urlpattern for this servlet-mapping [{0}] is exact.", new Object[]{pattern}));
                } else {
                    result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                    result.failed(smh.getLocalString(this.getClass().getName() + ".failed", "The urlpattern for this servlet-mapping [{0}] contains '*' and is not exact.", new Object[]{pattern}));
                    pass = false;
                }
            }
        } else {
            result.addNaDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
            result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notapp", "Not Applicable since this not a JAX-RPC Service Endpoint."));
        }
        return result;
    }
}

