/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.webservices;

import com.sun.enterprise.deployment.WebComponentDescriptor;
import com.sun.enterprise.deployment.WebServiceEndpoint;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.webservices.WSCheck;
import com.sun.enterprise.tools.verifier.tests.webservices.WSTest;

public class ServletImplClassCheck
extends WSTest
implements WSCheck {
    public Result check(WebServiceEndpoint descriptor) {
        Result result = this.getInitializedResult();
        ComponentNameConstructor compName = new ComponentNameConstructor(descriptor);
        boolean pass = true;
        if (descriptor.implementedByWebComponent()) {
            String servletClass = null;
            ClassLoader loader = this.getVerifierContext().getClassLoader();
            WebComponentDescriptor wcd = descriptor.getWebComponentImpl();
            if (wcd != null) {
                servletClass = wcd.getWebComponentImplementation();
            }
            if (servletClass == null || !descriptor.getWebComponentImpl().isServlet()) {
                result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                result.failed(smh.getLocalString(this.getClass().getName() + ".failed1", "The Web Component Implementation for this JAX-RPC Service Endpoint [{0}] is not a Servlet.", new Object[]{compName.toString()}));
            } else {
                try {
                    Class<?> cl = loader.loadClass(servletClass);
                    result.addGoodDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                    result.passed(smh.getLocalString(this.getClass().getName() + ".passed", "The Servlet Implementation Class [{0}] was loaded successfully.", new Object[]{servletClass}));
                }
                catch (ClassNotFoundException e) {
                    result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                    result.failed(smh.getLocalString(this.getClass().getName() + ".failed", "The Servlet Implementation Class [{0}]  was not found.", new Object[]{servletClass}));
                    pass = false;
                }
            }
        } else {
            result.addNaDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
            result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notapp", "Not Applicable since this not a JAX-RPC Service Endpoint."));
        }
        return result;
    }
}

