/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.webservices;

import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.WebService;
import com.sun.enterprise.deployment.WebServiceEndpoint;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.webservices.WSCheck;
import com.sun.enterprise.tools.verifier.tests.webservices.WSTest;

public class LargeIcon
extends WSTest
implements WSCheck {
    public Result check(WebServiceEndpoint descriptor) {
        String largeIconString = descriptor.getLargeIconUri();
        Result result = this.doRealCheck(descriptor, largeIconString);
        return result;
    }

    public Result doRealCheck(Descriptor descriptor, String largeIconString) {
        Result result = this.getInitializedResult();
        ComponentNameConstructor compName = null;
        if (descriptor instanceof WebServiceEndpoint) {
            compName = new ComponentNameConstructor((WebServiceEndpoint)descriptor);
        } else if (descriptor instanceof WebService) {
            compName = new ComponentNameConstructor((WebService)descriptor);
        }
        if (compName == null) {
            result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notApplicable", "The large-icon element is not defined within webservice [ {0} ]", new Object[]{compName.toString()}));
            return result;
        }
        if (largeIconString != null) {
            if (!descriptor.getLargeIconUri().endsWith(".jpg") && !descriptor.getLargeIconUri().endsWith(".gif")) {
                result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                result.failed(smh.getLocalString(this.getClass().getName() + ".failed", "Error: The large-icon element [ {0} ] must end in .jpg or .gif within webservice [ {1} ]", new Object[]{descriptor.getLargeIconUri(), compName.toString()}));
            } else {
                result.addGoodDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                result.passed(smh.getLocalString(this.getClass().getName() + ".passed", "The large-icon element [ {0} ] ends in .jpg or .gif within webservice [ {1} ]", new Object[]{descriptor.getLargeIconUri(), compName.toString()}));
            }
        } else {
            result.addNaDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
            result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notApplicable", "The large-icon element is not defined within webservice [ {0} ]", new Object[]{compName.toString()}));
        }
        return result;
    }
}

