/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.webservices;

import com.sun.enterprise.deployment.WebServiceEndpoint;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.webservices.WSCheck;
import com.sun.enterprise.tools.verifier.tests.webservices.WSTest;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Vector;

public class EndPointImplBeanClassChecker
extends WSTest
implements WSCheck {
    private Class sei;
    private Class bean;
    private Result result;
    private boolean isEjbEndpoint;

    public EndPointImplBeanClassChecker(Class seiClz, Class beanClz, Result resultInst) {
        this.sei = seiClz;
        this.bean = beanClz;
        this.result = resultInst;
        this.isEjbEndpoint = true;
    }

    public EndPointImplBeanClassChecker(Class seiClz, Class beanClz, Result resultInst, boolean isEjb) {
        this.sei = seiClz;
        this.bean = beanClz;
        this.result = resultInst;
        this.isEjbEndpoint = isEjb;
    }

    public Result check(WebServiceEndpoint descriptor) {
        return null;
    }

    public boolean check(ComponentNameConstructor compName) {
        boolean pass = true;
        try {
            this.bean.getConstructor(new Class[0]);
            this.result.addGoodDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
            this.result.passed(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.webservices.passed", "[{0}]", new Object[]{"The Service Impl Bean has a public default Constructor"}));
        }
        catch (NoSuchMethodException e) {
            this.result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
            this.result.failed(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.webservices.failed", "[{0}]", new Object[]{"The Service Impl Bean does not have a default public Constructor"}));
            pass = false;
        }
        catch (LinkageError e) {
            Verifier.debug(e);
            pass = false;
            this.addErrorDetails(this.result, compName);
            this.result.failed(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.webservices.failed1", "Error: [ {0} ] class used in [ {1} ] class cannot be found.", new Object[]{e.getMessage().replace('/', '.'), this.bean.getName()}));
        }
        int modifiers = this.bean.getModifiers();
        if (Modifier.isPublic(modifiers)) {
            this.result.addGoodDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
            this.result.passed(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.webservices.passed", "[{0}]", new Object[]{"The Service Impl Bean is public"}));
        } else {
            this.result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
            this.result.failed(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.webservices.failed", "[{0}]", new Object[]{"The Service Impl Bean is not public"}));
            pass = false;
        }
        if (Modifier.isFinal(modifiers)) {
            this.result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
            this.result.failed(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.webservices.failed", "[{0}]", new Object[]{"The Service Impl Bean is does not implement SEI, but is decalred final"}));
            pass = false;
        } else {
            this.result.addGoodDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
            this.result.passed(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.webservices.passed", "[{0}]", new Object[]{"The Service Impl Bean class is not declared final"}));
        }
        if (Modifier.isAbstract(modifiers)) {
            this.result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
            this.result.failed(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.webservices.failed", "[{0}]", new Object[]{"The Service Impl Bean class is decalred final"}));
            pass = false;
        } else {
            this.result.addGoodDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
            this.result.passed(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.webservices.passed", "[{0}]", new Object[]{"The Service Impl Bean class is not abstract"}));
        }
        try {
            if (this.bean.getDeclaredMethod("finalize", new Class[0]) != null) {
                this.result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                this.result.failed(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.webservices.failed", "[{0}]", new Object[]{"The Service Impl Bean class defines finalize() method"}));
                pass = false;
            }
        }
        catch (NoSuchMethodException e) {
            this.result.addGoodDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
            this.result.passed(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.webservices.passed", "[{0}]", new Object[]{"The Service Impl Bean class does not define finalize() method"}));
        }
        catch (LinkageError e) {
            Verifier.debug(e);
            pass = false;
            this.addErrorDetails(this.result, compName);
            this.result.failed(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.webservices.failed1", "Error: [ {0} ] class used in [ {1} ] class cannot be found.", new Object[]{e.getMessage().replace('/', '.'), this.bean.getName()}));
        }
        if (this.isEjbEndpoint) {
            try {
                if (this.bean.getDeclaredMethod("ejbCreate", new Class[0]) != null) {
                    this.result.addGoodDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                    this.result.passed(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.webservices.passed", "[{0}]", new Object[]{"The Service Impl Bean class defines ejbCreate()"}));
                }
            }
            catch (NoSuchMethodException e) {
                this.result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                this.result.failed(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.webservices.failed", "[{0}]", new Object[]{"The Service Impl Bean class has no ejbCreate()"}));
                pass = false;
            }
            catch (LinkageError e) {
                Verifier.debug(e);
                pass = false;
                this.addErrorDetails(this.result, compName);
                this.result.failed(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.webservices.failed1", "Error: [ {0} ] class used in [ {1} ] class cannot be found.", new Object[]{e.getMessage().replace('/', '.'), this.bean.getName()}));
            }
            try {
                if (this.bean.getDeclaredMethod("ejbRemove", new Class[0]) != null) {
                    this.result.addGoodDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                    this.result.passed(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.webservices.passed", "[{0}]", new Object[]{"The Service Impl Bean class defines ejbRemove()"}));
                }
            }
            catch (NoSuchMethodException e) {
                this.result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                this.result.failed(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.webservices.failed", "[{0}]", new Object[]{"The Service Impl Bean class has no ejbRemove()"}));
                pass = false;
            }
            catch (LinkageError e) {
                Verifier.debug(e);
                pass = false;
                this.addErrorDetails(this.result, compName);
                this.result.failed(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.webservices.failed1", "Error: [ {0} ] class used in [ {1} ] class cannot be found.", new Object[]{e.getMessage().replace('/', '.'), this.bean.getName()}));
            }
        }
        return pass;
    }

    public Vector getSEIMethodsNotImplemented() {
        Vector<String> ret = new Vector<String>();
        Method[] beanPubMethods = this.bean.getMethods();
        Method[] seiMethods = this.sei.getMethods();
        for (int i = 0; i < seiMethods.length; ++i) {
            if (this.hasMatchingMethod(seiMethods[i], beanPubMethods)) continue;
            ret.add(seiMethods[i].toString());
        }
        return ret;
    }

    private boolean hasMatchingMethod(Method meth, Method[] tobeChecked) {
        for (int i = 0; i < tobeChecked.length; ++i) {
            if (!WSTest.matchesSignatureAndReturn(meth, tobeChecked[i])) continue;
            return true;
        }
        return false;
    }
}

