/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.webservices;

import com.sun.enterprise.deployment.WebService;
import com.sun.enterprise.deployment.WebServiceEndpoint;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.webservices.WSCheck;
import com.sun.enterprise.tools.verifier.tests.webservices.WSTest;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;

public class EJBLinkedToOnePortCompCheck
extends WSTest
implements WSCheck {
    public Result check(WebServiceEndpoint descriptor) {
        Result result = this.getInitializedResult();
        ComponentNameConstructor compName = new ComponentNameConstructor(descriptor);
        if (!descriptor.implementedByEjbComponent()) {
            result.addNaDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
            result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notapp", "This is a JAX-RPC Service Endpoint"));
            return result;
        }
        if (this.isLinkedToSinglePortComp(this.getAllEndPointsInApp(descriptor), descriptor.getLinkName())) {
            result.addGoodDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
            result.passed(smh.getLocalString(this.getClass().getName() + ".passed", "The session EJB associated with this end-point is linked to by a single port-component."));
        } else {
            result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
            result.failed(smh.getLocalString(this.getClass().getName() + ".failed", "The session EJB associated with this end-point is linked to by a multiple port-components."));
        }
        return result;
    }

    Collection getAllEndPointsInApp(WebServiceEndpoint desc) {
        Vector endPoints = new Vector();
        Collection allWebServices = desc.getWebService().getWebServicesDescriptor().getWebServices();
        Iterator it = allWebServices.iterator();
        while (it.hasNext()) {
            endPoints.addAll(((WebService)it.next()).getEndpoints());
        }
        return endPoints;
    }

    boolean isLinkedToSinglePortComp(Collection endPoints, String compLink) {
        boolean single = true;
        boolean linkAlreadySeen = false;
        Iterator it = endPoints.iterator();
        while (it.hasNext()) {
            String myCompLink = ((WebServiceEndpoint)it.next()).getLinkName();
            if (!myCompLink.equals(compLink)) continue;
            if (!linkAlreadySeen) {
                linkAlreadySeen = true;
                continue;
            }
            single = false;
            break;
        }
        return single;
    }
}

