/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.web.runtime;

import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.runtime.common.EjbRef;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.WebComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.web.WebCheck;
import com.sun.enterprise.tools.verifier.tests.web.WebTest;

public class ASWebEjbRef
extends WebTest
implements WebCheck {
    public Result check(WebBundleDescriptor descriptor) {
        Result result = this.getInitializedResult();
        WebComponentNameConstructor compName = new WebComponentNameConstructor(descriptor);
        boolean oneFailed = false;
        boolean oneWarning = false;
        try {
            EjbRef[] ejbRefs = descriptor.getSunDescriptor().getEjbRef();
            if (ejbRefs != null && ejbRefs.length > 0) {
                for (int rep = 0; rep < ejbRefs.length; ++rep) {
                    boolean isValidResRefName = false;
                    String jndiName = ejbRefs[rep].getJndiName();
                    String refName = ejbRefs[rep].getEjbRefName();
                    if (this.validEjbRefName(refName, descriptor)) {
                        isValidResRefName = true;
                        this.addGoodDetails(result, compName);
                        result.passed(smh.getLocalString(this.getClass().getName() + ".passed", "PASSED [AS-WEB ejb-ref] ejb-ref-name [ {0} ] properly defined in the war file.", new Object[]{refName}));
                    } else {
                        if (!oneFailed) {
                            oneFailed = true;
                        }
                        this.addErrorDetails(result, compName);
                        result.failed(smh.getLocalString(this.getClass().getName() + ".failed", "FAILED [AS-WEB ejb-ref] ejb-ref-name [ {0} ] is not valid, either empty or not defined in web.xml.", new Object[]{refName}));
                    }
                    if (isValidResRefName && this.validJndiName(jndiName, refName, descriptor)) {
                        if (!jndiName.startsWith("ejb/")) {
                            oneWarning = true;
                            this.addWarningDetails(result, compName);
                            result.warning(smh.getLocalString(this.getClass().getName() + ".warning", "WARNING [AS-WEB ejb-ref] jndi-name [ {0} ] is not starting with \"ejb/\".", new Object[]{jndiName}));
                            continue;
                        }
                        this.addGoodDetails(result, compName);
                        result.passed(smh.getLocalString(this.getClass().getName() + ".passed1", "PASSED [AS-WEB ejb-ref] jndi-name [ {0} ] properly defined in the war file.", new Object[]{jndiName}));
                        continue;
                    }
                    if (!oneFailed) {
                        oneFailed = true;
                    }
                    this.addErrorDetails(result, compName);
                    result.failed(smh.getLocalString(this.getClass().getName() + ".failed1", "FAILED [AS-WEB ejb-ref] jndi-name [ {0} ] is not valid, either empty or null.", new Object[]{jndiName}));
                }
            } else {
                this.addNaDetails(result, compName);
                result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notApplicable", "NOT APPLICABLE [AS-WEB sun-web-app] ejb-ref element(s) not defined in the web archive [ {0} ].", new Object[]{descriptor.getName()}));
                return result;
            }
            if (oneFailed) {
                result.setStatus(1);
            } else if (oneWarning) {
                result.setStatus(2);
            } else {
                this.addGoodDetails(result, compName);
                result.passed(smh.getLocalString(this.getClass().getName() + ".passed2", "PASSED [AS-WEB sun-web-app] ejb-ref element(s) defined are valid within the web archive [ {0} ].", new Object[]{descriptor.getName()}));
            }
        }
        catch (Exception ex) {
            oneFailed = true;
            this.addErrorDetails(result, compName);
            result.failed(smh.getLocalString(this.getClass().getName() + ".failed2", "FAILED [AS-WEB sun-web-app] Could not create the ejb-ref object"));
        }
        return result;
    }

    boolean validEjbRefName(String name, WebBundleDescriptor descriptor) {
        boolean valid = true;
        if (name != null && name.length() != 0) {
            try {
                descriptor.getEjbReferenceByName(name);
            }
            catch (IllegalArgumentException e) {
                valid = false;
            }
        } else {
            valid = false;
        }
        return valid;
    }

    boolean validJndiName(String refJndiName, String refName, WebBundleDescriptor descriptor) {
        boolean valid = true;
        if (refJndiName == null || refJndiName.length() == 0) {
            valid = false;
        }
        return valid;
    }
}

