/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.web.runtime;

import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.runtime.web.LocaleCharsetInfo;
import com.sun.enterprise.deployment.runtime.web.LocaleCharsetMap;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.WebComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.web.WebCheck;
import com.sun.enterprise.tools.verifier.tests.web.WebTest;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Locale;

public class ASLocaleCharsetInfo
extends WebTest
implements WebCheck {
    public Result check(WebBundleDescriptor descriptor) {
        Result result = this.getInitializedResult();
        WebComponentNameConstructor compName = new WebComponentNameConstructor(descriptor);
        boolean oneFailed = false;
        boolean oneWarning = false;
        boolean notApp = false;
        try {
            LocaleCharsetInfo nlsInfo = descriptor.getSunDescriptor().getLocaleCharsetInfo();
            if (nlsInfo != null) {
                Locale[] locales = Locale.getAvailableLocales();
                String defaultLocale = nlsInfo.getAttributeValue("DefaultLocale");
                if (defaultLocale == null || defaultLocale.length() == 0) {
                    oneFailed = true;
                    this.addErrorDetails(result, compName);
                    result.failed(smh.getLocalString(this.getClass().getName() + ".failed", "FAILED [AS-WEB local-charset-info] Empty " + defaultLocale + " [ {0} ] is not valid.", new Object[]{defaultLocale}));
                } else {
                    boolean delocFlag = false;
                    for (int index = 0; index < locales.length; ++index) {
                        if (!defaultLocale.equalsIgnoreCase(locales[index].toString())) continue;
                        delocFlag = true;
                        break;
                    }
                    if (delocFlag) {
                        this.addGoodDetails(result, compName);
                        result.passed(smh.getLocalString(this.getClass().getName() + ".passed", "PASSED [AS-WEB locale-charset-info] Properly " + defaultLocale + "  [ {0} ] defined in the war file.", new Object[]{defaultLocale}));
                    } else {
                        oneWarning = true;
                        this.addWarningDetails(result, compName);
                        result.warning(smh.getLocalString(this.getClass().getName() + ".warning", "WARNING [AS-WEB local-charset-info] attribute default_locale [ {0} ] is not valid.", new Object[]{defaultLocale}));
                    }
                }
                LocaleCharsetMap[] localeCharMaps = nlsInfo.getLocaleCharsetMap();
                for (int rep = 0; rep < localeCharMaps.length; ++rep) {
                    boolean charMapLocFlag = false;
                    String locale = localeCharMaps[rep].getAttributeValue("Locale");
                    if (locale == null || locale.length() == 0) {
                        oneFailed = true;
                        this.addErrorDetails(result, compName);
                        result.failed(smh.getLocalString(this.getClass().getName() + ".failed1", "FAILED [AS-WEB local-charset-map] attribute locale  [ {0} ] must be of finite length.", new Object[]{locale}));
                    } else {
                        for (int index = 0; index < locales.length; ++index) {
                            if (!locale.equalsIgnoreCase(locales[index].toString())) continue;
                            charMapLocFlag = true;
                            break;
                        }
                        if (!charMapLocFlag) {
                            oneWarning = true;
                            this.addWarningDetails(result, compName);
                            result.warning(smh.getLocalString(this.getClass().getName() + ".warning1", "WARNING [AS-WEB local-charset-map] attribute locale  [ {0} ] is not valid.", new Object[]{locale}));
                        } else {
                            this.addGoodDetails(result, compName);
                            result.passed(smh.getLocalString(this.getClass().getName() + ".passed1", "PASSED [AS-WEB locale-charset-map] attribute locale [ {0} ] properly defined.", new Object[]{locale}));
                        }
                    }
                    String charset = localeCharMaps[rep].getAttributeValue("Charset");
                    if (charset == null || charset.length() == 0) {
                        oneFailed = true;
                        this.addErrorDetails(result, compName);
                        result.failed(smh.getLocalString(this.getClass().getName() + ".failed3", "FAILED [AS-WEB local-charset-map] attribute charset [ {0} ] must be of standard format.", new Object[]{charset}));
                        continue;
                    }
                    try {
                        Charset cs = Charset.forName(charset);
                        this.addGoodDetails(result, compName);
                        result.passed(smh.getLocalString(this.getClass().getName() + ".passed2", "PASSED [AS-WEB locale-charset-map] attributes charset [ {0} ] properly defined.", new Object[]{charset}));
                        continue;
                    }
                    catch (UnsupportedCharsetException ex) {
                        oneWarning = true;
                        this.addWarningDetails(result, compName);
                        result.warning(smh.getLocalString(this.getClass().getName() + ".warning2", "WARNING [AS-WEB local-charset-map] attribute charset [ {0} ] is not valid.", new Object[]{charset}));
                        continue;
                    }
                    catch (IllegalCharsetNameException ex) {
                        oneFailed = true;
                        this.addErrorDetails(result, compName);
                        result.failed(smh.getLocalString(this.getClass().getName() + ".failed3", "FAILED [AS-WEB local-charset-map] attribute charset [ {0} ] must be of standard format.", new Object[]{charset}));
                    }
                }
            } else {
                notApp = true;
                this.addNaDetails(result, compName);
                result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notApplicable", "NOT APPLICABLE [AS-WEB sun-web-app] locale-charset-info element not defined in this web archive [ {0} ].", new Object[]{descriptor.getName()}));
            }
            if (oneFailed) {
                result.setStatus(1);
            } else if (oneWarning) {
                result.setStatus(2);
            } else if (notApp) {
                result.setStatus(3);
            } else {
                result.setStatus(0);
                this.addGoodDetails(result, compName);
                result.passed(smh.getLocalString(this.getClass().getName() + ".passed3", "PASSED [AS-WEB sun-web-app] locale-charset-info elements are valid within the web archive [ {0} ] .", new Object[]{descriptor.getName()}));
            }
        }
        catch (Exception ex) {
            oneFailed = true;
            this.addErrorDetails(result, compName);
            result.failed(smh.getLocalString(this.getClass().getName() + ".failed2", "FAILED [AS-WEB sun-web-app] could not create the local-charset-info object"));
        }
        return result;
    }
}

