/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.web.runtime;

import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.runtime.web.CookieProperties;
import com.sun.enterprise.deployment.runtime.web.SessionConfig;
import com.sun.enterprise.deployment.runtime.web.WebProperty;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.WebComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.web.WebCheck;
import com.sun.enterprise.tools.verifier.tests.web.WebTest;
import com.sun.enterprise.tools.verifier.tests.web.runtime.ASWebProperty;

public class ASCookieProperty
extends WebTest
implements WebCheck {
    public Result check(WebBundleDescriptor descriptor) {
        Result result = this.getInitializedResult();
        WebComponentNameConstructor compName = new WebComponentNameConstructor(descriptor);
        boolean oneFailed = false;
        boolean notApp = false;
        try {
            SessionConfig sessionConfig = descriptor.getSunDescriptor().getSessionConfig();
            CookieProperties cookieProp = null;
            WebProperty[] cookieWebProps = null;
            if (sessionConfig != null && (cookieProp = sessionConfig.getCookieProperties()) != null) {
                cookieWebProps = cookieProp.getWebProperty();
            }
            if (sessionConfig != null && cookieProp != null && cookieWebProps != null && cookieWebProps.length != 0) {
                if (ASWebProperty.checkWebProperties(cookieWebProps, result, descriptor, this)) {
                    oneFailed = true;
                    this.addErrorDetails(result, compName);
                    result.failed(smh.getLocalString(this.getClass().getName() + ".failed", "FAILED [AS-WEB session-config] cookie-properties : Atleast one name/value pair is not valid in [ {0} ].", new Object[]{descriptor.getName()}));
                }
            } else {
                notApp = true;
            }
            if (notApp) {
                this.addNaDetails(result, compName);
                result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notApplicable", "NOT APPLICABLE [AS-WEB session-config] cookie-properties element not defined for {0}.", new Object[]{descriptor.getName()}));
            }
            if (oneFailed) {
                result.setStatus(1);
            } else if (notApp) {
                result.setStatus(3);
            } else {
                result.setStatus(0);
                this.addGoodDetails(result, compName);
                result.passed(smh.getLocalString(this.getClass().getName() + ".passed", "PASSED [AS-WEB session-config] cookie-properties are valid within the web archive [ {0} ].", new Object[]{descriptor.getName()}));
            }
        }
        catch (Exception ex) {
            oneFailed = true;
            this.addErrorDetails(result, compName);
            result.failed(smh.getLocalString(this.getClass().getName() + ".failed1", "FAILED [AS-WEB session-config] could not create the session-config object"));
        }
        return result;
    }
}

