/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.web.runtime;

import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.runtime.web.Cache;
import com.sun.enterprise.deployment.runtime.web.CacheHelper;
import com.sun.enterprise.deployment.runtime.web.WebProperty;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.WebComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.web.WebCheck;
import com.sun.enterprise.tools.verifier.tests.web.runtime.ASCache;
import com.sun.enterprise.tools.verifier.tests.web.runtime.ASWebProperty;

public class ASCacheHelperClass
extends ASCache
implements WebCheck {
    public Result check(WebBundleDescriptor descriptor) {
        Result result = this.getInitializedResult();
        WebComponentNameConstructor compName = new WebComponentNameConstructor(descriptor);
        boolean oneFailed = false;
        boolean notApp = false;
        boolean oneWarning = false;
        boolean presentHelper = false;
        try {
            Cache cache = descriptor.getSunDescriptor().getCache();
            CacheHelper[] helperClasses = null;
            CacheHelper helperClass = null;
            String name = null;
            String classname = null;
            String[] names = null;
            if (cache != null) {
                helperClasses = cache.getCacheHelper();
            }
            if (cache != null && helperClasses != null && helperClasses.length > 0) {
                names = new String[helperClasses.length];
                for (int rep = 0; rep < helperClasses.length; ++rep) {
                    helperClass = helperClasses[rep];
                    if (helperClass == null) continue;
                    int i = rep + 1;
                    name = this.getXPathValue("sun-web-app/cache/cache-helper[" + i + "]/@name");
                    classname = this.getXPathValue("sun-web-app/cache/cache-helper[" + i + "]/@class-name");
                    Class hClass = null;
                    names[rep] = name;
                    if (name != null || name.length() != 0 || classname != null || classname.length() != 0) {
                        boolean isDuplicate = false;
                        for (int rep1 = 0; rep1 < rep; ++rep1) {
                            if (!name.equals(names[rep1])) continue;
                            isDuplicate = true;
                            break;
                        }
                        if (isDuplicate) {
                            oneFailed = true;
                            this.addErrorDetails(result, compName);
                            result.failed(smh.getLocalString(this.getClass().getName() + ".failed", "FAILED [AS-WEB cache-helper] name attribute [ {0} ], must be unique in the entire list of cache-helper.", new Object[]{name}));
                        } else {
                            hClass = this.loadClass(result, classname);
                            presentHelper = hClass != null;
                            if (!presentHelper) {
                                this.addWarningDetails(result, compName);
                                result.warning(smh.getLocalString(this.getClass().getName() + ".error", "WARNING [AS-WEB cache-helper] name [ {0} ], class not present in the war file.", new Object[]{name}));
                                oneWarning = true;
                            } else {
                                this.addGoodDetails(result, compName);
                                result.passed(smh.getLocalString(this.getClass().getName() + ".passed", "PASSED [AS-WEB cache-helper] name  [ {0} ], helper class is valid.", new Object[]{name}));
                            }
                        }
                    } else {
                        this.addErrorDetails(result, compName);
                        result.failed(smh.getLocalString(this.getClass().getName() + ".failed1", "FAILED [AS-WEB cache-helper] name [ {0} ], either empty or null.", new Object[]{name}));
                        oneFailed = true;
                    }
                    WebProperty[] webProps = helperClass.getWebProperty();
                    if (!ASWebProperty.checkWebProperties(webProps, result, descriptor, this)) continue;
                    oneFailed = true;
                    this.addErrorDetails(result, compName);
                    result.failed(smh.getLocalString(this.getClass().getName() + ".failed2", "FAILED [AS-WEB cache-helper] Atleast one name/value pair is not valid in helper-class of [ {0} ].", new Object[]{descriptor.getName()}));
                }
            } else {
                notApp = true;
                this.addNaDetails(result, compName);
                result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notApplicable", "NOT APPLICABLE [AS-WEB cache-helper] There is no cache-helper element for the web application", new Object[]{descriptor.getName()}));
            }
            if (oneFailed) {
                result.setStatus(1);
            } else if (oneWarning) {
                result.setStatus(2);
            } else if (notApp) {
                result.setStatus(3);
            } else {
                result.setStatus(0);
            }
        }
        catch (Exception ex) {
            oneFailed = true;
            this.addErrorDetails(result, compName);
            result.failed(smh.getLocalString(this.getClass().getName() + ".failed3", "FAILED [AS-WEB cache-helper] could not create the cache object"));
        }
        return result;
    }
}

