/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.web;

import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.WebComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.web.WebCheck;
import com.sun.enterprise.tools.verifier.tests.web.WebTest;
import java.io.File;
import java.util.Enumeration;
import java.util.Vector;
import java.util.jar.JarEntry;

public class WelcomeFile
extends WebTest
implements WebCheck {
    public Result check(WebBundleDescriptor descriptor) {
        Result result = this.getInitializedResult();
        WebComponentNameConstructor compName = new WebComponentNameConstructor(descriptor);
        if (descriptor.getWelcomeFiles().hasMoreElements()) {
            boolean oneFailed = false;
            boolean foundIt = false;
            Enumeration e = descriptor.getWelcomeFiles();
            while (e.hasMoreElements()) {
                String welcomefile;
                block10: {
                    foundIt = false;
                    welcomefile = (String)e.nextElement();
                    if (welcomefile.startsWith("/") || welcomefile.endsWith("/")) {
                        result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                        result.failed(smh.getLocalString(this.getClass().getName() + ".failed1", "Error : Servlet 2.3 Spec 9.9 Welcome file URL [ {0} ] must be partial URLs with no trailing or leading /", new Object[]{welcomefile, descriptor.getName()}));
                    }
                    try {
                        Enumeration entries = WelcomeFile.getDirEntries(this.getAbstractArchiveUri(descriptor));
                        foundIt = this.foundWelcomeFile(entries, welcomefile);
                    }
                    catch (Exception ex) {
                        if (oneFailed) break block10;
                        oneFailed = true;
                    }
                }
                if (foundIt) {
                    result.addGoodDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                    result.addGoodDetails(smh.getLocalString(this.getClass().getName() + ".passed", "Welcome file [ {0} ] contains the file name to use as a default welcome file within web application [ {1} ]", new Object[]{welcomefile, descriptor.getName()}));
                    continue;
                }
                if (!oneFailed) {
                    oneFailed = true;
                }
                result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                result.addErrorDetails(smh.getLocalString(this.getClass().getName() + ".failed", "Error: Welcome file [ {0} ] is not found within [ {1} ] or does not contain the file name to use as a default welcome file within web application [ {2} ]", new Object[]{welcomefile, descriptor.getModuleDescriptor().getArchiveUri(), descriptor.getName()}));
            }
            if (oneFailed) {
                result.setStatus(1);
            } else {
                result.setStatus(0);
            }
        } else {
            result.addNaDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
            result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notApplicable", "There are no welcome files within the web archive [ {0} ]", new Object[]{descriptor.getName()}));
        }
        return result;
    }

    private boolean foundWelcomeFile(Enumeration entries, String welcomeFile) {
        File f = null;
        JarEntry j = null;
        String name = null;
        while (entries.hasMoreElements()) {
            Object obj = entries.nextElement();
            if (obj instanceof JarEntry) {
                j = (JarEntry)obj;
                name = j.getName();
            } else {
                f = (File)obj;
                name = f.getName();
            }
            if (!name.endsWith(welcomeFile)) continue;
            return true;
        }
        return false;
    }

    private static Enumeration getDirEntries(String dir) {
        Vector v = new Vector();
        WelcomeFile.visitAllDirsAndFiles(new File(dir), v);
        return v.elements();
    }

    private static void visitAllDirsAndFiles(File dir, Vector v) {
        v.add(dir);
        if (dir.isDirectory()) {
            String[] children = dir.list();
            for (int i = 0; i < children.length; ++i) {
                WelcomeFile.visitAllDirsAndFiles(new File(dir, children[i]), v);
            }
        }
    }
}

