/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.web;

import com.sun.enterprise.deployment.SecurityConstraintImpl;
import com.sun.enterprise.deployment.UserDataConstraintImpl;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.WebComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.web.WebCheck;
import com.sun.enterprise.tools.verifier.tests.web.WebTest;
import java.util.Enumeration;

public class TransportGuarantee
extends WebTest
implements WebCheck {
    public Result check(WebBundleDescriptor descriptor) {
        Result result = this.getInitializedResult();
        WebComponentNameConstructor compName = new WebComponentNameConstructor(descriptor);
        if (descriptor.getSecurityConstraints().hasMoreElements()) {
            boolean oneFailed = false;
            boolean foundIt = false;
            int na = 0;
            int noSc = 0;
            Enumeration e = descriptor.getSecurityConstraints();
            while (e.hasMoreElements()) {
                foundIt = false;
                ++noSc;
                SecurityConstraintImpl securityConstraintImpl = (SecurityConstraintImpl)e.nextElement();
                UserDataConstraintImpl userDataConstraint = (UserDataConstraintImpl)securityConstraintImpl.getUserDataConstraint();
                if (userDataConstraint != null) {
                    String transportGuarantee = userDataConstraint.getTransportGuarantee();
                    foundIt = transportGuarantee.length() > 0 ? transportGuarantee.equals("NONE") || transportGuarantee.equals("INTEGRAL") || transportGuarantee.equals("CONFIDENTIAL") : false;
                    if (foundIt) {
                        result.addGoodDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                        result.addGoodDetails(smh.getLocalString(this.getClass().getName() + ".passed", "transport-guarantee [ {0} ] specifies that the communication between client and server should be one of \"SECURE\", \"NONE\", or \"CONFIDENTIAL\" within web application [ {1} ]", new Object[]{transportGuarantee, descriptor.getName()}));
                        continue;
                    }
                    if (!oneFailed) {
                        oneFailed = true;
                    }
                    result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                    result.addErrorDetails(smh.getLocalString(this.getClass().getName() + ".failed", "Error: transport-guarantee [ {0} ] does not specify that the communication between client and server is one of \"SECURE\", \"NONE\", or \"CONFIDENTIAL\" within web application [ {1} ]", new Object[]{transportGuarantee, descriptor.getName()}));
                    continue;
                }
                result.addNaDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                result.addNaDetails(smh.getLocalString(this.getClass().getName() + ".notApplicable1", "There are no transport-guarantee elements within the web application [ {0} ]", new Object[]{descriptor.getName()}));
                ++na;
            }
            if (oneFailed) {
                result.setStatus(1);
            } else if (na == noSc) {
                result.setStatus(3);
            } else {
                result.setStatus(0);
            }
        } else {
            result.addNaDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
            result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notApplicable", "There are no transport-guarantee elements within the web archive [ {0} ]", new Object[]{descriptor.getName()}));
        }
        return result;
    }
}

