/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.web;

import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.WebComponentDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.WebComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.web.WebCheck;
import com.sun.enterprise.tools.verifier.tests.web.WebTest;
import java.util.Iterator;
import java.util.Set;

public class ServletClass
extends WebTest
implements WebCheck {
    final String servletClassPath = "WEB-INF/classes";

    public Result check(WebBundleDescriptor descriptor) {
        Result result = this.getInitializedResult();
        WebComponentNameConstructor compName = new WebComponentNameConstructor(descriptor);
        if (!descriptor.getServletDescriptors().isEmpty()) {
            boolean oneFailed = false;
            boolean foundIt = false;
            Set servlets = descriptor.getServletDescriptors();
            Iterator itr = servlets.iterator();
            result = this.loadWarFile(descriptor);
            while (itr.hasNext()) {
                foundIt = false;
                WebComponentDescriptor servlet = (WebComponentDescriptor)itr.next();
                String servletClassName = servlet.getWebComponentImplementation();
                if (servletClassName.equals(smh.getLocalString("JAXRPCServlet", "com.sun.xml.rpc.server.http.JAXRPCServlet"))) continue;
                Class servletClass = this.loadClass(result, servletClassName);
                if (servletClass != null) {
                    foundIt = true;
                } else {
                    result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                    result.addErrorDetails(smh.getLocalString(this.getClass().getName() + ".ClassNotFoundException", "Error: [ {0} ] class not found.", new Object[]{servletClassName}));
                    oneFailed = true;
                }
                if (foundIt) {
                    result.addGoodDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                    result.addGoodDetails(smh.getLocalString(this.getClass().getName() + ".passed", "Servlet class [ {0} ] resides in the WEB-INF/classes directory.", new Object[]{servletClassName}));
                    continue;
                }
                result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                result.addErrorDetails(smh.getLocalString(this.getClass().getName() + ".failed", "Error: Servlet class [ {0} ] does not reside in the WEB-INF/classes directory.", new Object[]{servletClassName}));
            }
            if (oneFailed) {
                result.setStatus(1);
            } else {
                result.setStatus(0);
            }
        } else {
            result.addNaDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
            result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notApplicable", "There are no servlet components within the web archive [ {0} ]", new Object[]{descriptor.getName()}));
        }
        return result;
    }
}

