/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.web;

import com.sun.enterprise.deployment.ServletFilterDescriptor;
import com.sun.enterprise.deployment.ServletFilterMappingDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.WebComponentDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.WebComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.web.WebTest;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Set;

public class FilterMapping
extends WebTest {
    public Result check(WebBundleDescriptor descriptor) {
        Result result;
        WebComponentNameConstructor compName = new WebComponentNameConstructor(descriptor);
        Enumeration filterEnum = descriptor.getServletFilterDescriptors().elements();
        if (filterEnum.hasMoreElements()) {
            boolean oneFailed = false;
            result = this.loadWarFile(descriptor);
            while (filterEnum.hasMoreElements()) {
                ServletFilterDescriptor filter = (ServletFilterDescriptor)filterEnum.nextElement();
                if (this.hasValidMapping(descriptor, filter.getName())) continue;
                result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                result.failed(smh.getLocalString(this.getClass().getName() + ".failed", "Filter Mapping for [ {0} ] is incorrect", new Object[]{filter.getName()}));
                oneFailed = true;
            }
            if (!oneFailed) {
                result.addGoodDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                result.passed(smh.getLocalString(this.getClass().getName() + ".passed", "All filter mappings are correct"));
            }
        } else {
            result = this.getInitializedResult();
            result.setStatus(3);
            result.addNaDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
            result.notApplicable(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.web.FilterClass.notApplicable", "There are no filter components within the web archive [ {0} ]", new Object[]{descriptor.getName()}));
        }
        return result;
    }

    private boolean hasValidMapping(WebBundleDescriptor descriptor, String filterName) {
        boolean valid = false;
        if (filterName == null) {
            return false;
        }
        Enumeration filtermapperEnum = descriptor.getServletFilterMappingDescriptors().elements();
        if (filtermapperEnum.hasMoreElements()) {
            String filterMapping;
            ServletFilterMappingDescriptor filterMapper = null;
            boolean mappingFound = false;
            while (!(mappingFound = filterName.equals(filterMapping = (filterMapper = (ServletFilterMappingDescriptor)filtermapperEnum.nextElement()).getName())) && filtermapperEnum.hasMoreElements()) {
            }
            if (mappingFound) {
                String target = filterMapper.getTarget();
                String targetType = filterMapper.getTargetType();
                if (targetType.equals("URLPattern")) {
                    if (target != null && (target.startsWith("/") || target.startsWith("/") && target.endsWith("/*") || target.startsWith("*."))) {
                        valid = true;
                    }
                } else if (targetType.equals("Servlet")) {
                    Set servlets = descriptor.getServletDescriptors();
                    Iterator itr = servlets.iterator();
                    while (itr.hasNext()) {
                        WebComponentDescriptor servlet = (WebComponentDescriptor)itr.next();
                        String servletName = servlet.getCanonicalName();
                        if (!target.equals(servletName)) continue;
                        valid = true;
                        break;
                    }
                }
            } else {
                valid = true;
            }
        }
        return valid;
    }
}

