/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.session.stateless;

import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbSessionDescriptor;
import com.sun.enterprise.tools.verifier.Context;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;
import java.lang.reflect.Method;

public class StatelessCreateReturn
extends EjbTest
implements EjbCheck {
    boolean foundAtLeastOneCreate = false;
    Result result = null;
    ComponentNameConstructor compName = null;
    boolean remote_exists = false;
    boolean local_exists = false;

    public Result check(EjbDescriptor descriptor) {
        this.result = this.getInitializedResult();
        this.compName = new ComponentNameConstructor(descriptor);
        String local = null;
        String localHome = null;
        String remote = null;
        String home = null;
        if (descriptor instanceof EjbSessionDescriptor) {
            boolean oneFailed = false;
            String stateType = ((EjbSessionDescriptor)descriptor).getSessionType();
            if ("Stateless".equals(stateType)) {
                if (descriptor.getHomeClassName() != null && !"".equals(descriptor.getHomeClassName()) && descriptor.getRemoteClassName() != null && !"".equals(descriptor.getRemoteClassName())) {
                    this.remote_exists = true;
                    home = descriptor.getHomeClassName();
                    remote = descriptor.getRemoteClassName();
                }
                if (descriptor.getLocalHomeClassName() != null && !"".equals(descriptor.getLocalHomeClassName()) && descriptor.getLocalClassName() != null && !"".equals(descriptor.getLocalClassName())) {
                    this.local_exists = true;
                    localHome = descriptor.getLocalHomeClassName();
                    local = descriptor.getLocalClassName();
                }
                if (home == null && remote == null && localHome == null && local == null && this.implementsEndpoints(descriptor)) {
                    this.result.addNaDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{this.compName.toString()}));
                    this.result.notApplicable(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.ejb.webservice.notapp", "Not Applicable because, EJB [ {0} ] implements a Service Endpoint Interface.", new Object[]{this.compName.toString()}));
                    this.result.setStatus(3);
                    return this.result;
                }
                oneFailed = this.commonToBothInterfaces(remote, home, local, localHome, (EjbSessionDescriptor)descriptor);
                if (!this.foundAtLeastOneCreate) {
                    this.result.addGoodDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{this.compName.toString()}));
                    this.result.addGoodDetails(smh.getLocalString(this.getClass().getName() + ".debug3", "In Home Interface ", new Object[0]));
                    this.result.addGoodDetails(smh.getLocalString(this.getClass().getName() + ".notApplicable1", "No create method was found, test not applicable."));
                    this.result.setStatus(0);
                } else if (oneFailed) {
                    this.result.setStatus(1);
                } else {
                    this.result.setStatus(0);
                }
                return this.result;
            }
            if ("Stateful".equals(stateType)) {
                this.result.addNaDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{this.compName.toString()}));
                this.result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notApplicable1", "[ {0} ] expected {1} Session bean, but called with {2} Session bean.", new Object[]{this.getClass(), "Stateless", stateType}));
                return this.result;
            }
            this.result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{this.compName.toString()}));
            this.result.failed(smh.getLocalString(this.getClass().getName() + ".failed2", "Error: [ {0} ] is not valid stateType within bean [ {1} ].", new Object[]{stateType, descriptor.getName()}));
            return this.result;
        }
        this.result.addNaDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{this.compName.toString()}));
        this.result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notApplicable", "[ {0} ] expected {1} bean, but called with {2} bean.", new Object[]{this.getClass(), "Entity", "Session"}));
        return this.result;
    }

    private boolean commonToBothInterfaces(String remote, String home, String local, String localHome, EjbSessionDescriptor descriptor) {
        boolean oneFailed = false;
        try {
            Context context = this.getVerifierContext();
            ClassLoader jcl = context.getClassLoader();
            if (this.remote_exists) {
                Class<?> c = jcl.loadClass(home);
                Method[] methods = c.getDeclaredMethods();
                oneFailed = this.findReturnType(methods, home, local, remote);
            }
            if (!oneFailed && this.local_exists) {
                Class<?> hc = jcl.loadClass(localHome);
                Method[] localMethods = hc.getDeclaredMethods();
                oneFailed = this.findReturnType(localMethods, localHome, local, remote);
            }
            return oneFailed;
        }
        catch (ClassNotFoundException e) {
            Verifier.debug(e);
            this.result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{this.compName.toString()}));
            this.result.failed(smh.getLocalString(this.getClass().getName() + ".failedException", "Error: Home interface [ {0} ] or [ {1} ]or Component interface [ {2} ] or [ {3} ] does not exist or is not loadable within bean [ {4} ]", new Object[]{home, localHome, remote, local, descriptor.getName()}));
            return false;
        }
    }

    private boolean findReturnType(Method[] methods, String home, String local, String remote) {
        boolean oneFailed = false;
        for (int i = 0; i < methods.length; ++i) {
            boolean validReturn = false;
            if (!methods[i].getName().startsWith("create")) continue;
            Class<?> methodReturnType = methods[i].getReturnType();
            if (this.remote_exists && methodReturnType.getName().equals(remote)) {
                validReturn = true;
                this.result.addGoodDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{this.compName.toString()}));
                this.result.addGoodDetails(smh.getLocalString(this.getClass().getName() + ".debug1", "For Home Interface [ {0} ] Method [ {1} ]", new Object[]{home, methods[i].getName()}));
                this.result.addGoodDetails(smh.getLocalString(this.getClass().getName() + ".passed", "The create method which returns [ {0} ] interface was found.", new Object[]{remote, methods[i].getName()}));
                this.foundAtLeastOneCreate = true;
            }
            if (this.local_exists && methodReturnType.getName().equals(local)) {
                validReturn = true;
                this.result.addGoodDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{this.compName.toString()}));
                this.result.addGoodDetails(smh.getLocalString(this.getClass().getName() + ".debug1", "For Home Interface [ {0} ] Method [ {1} ]", new Object[]{home, methods[i].getName()}));
                this.result.addGoodDetails(smh.getLocalString(this.getClass().getName() + ".passed", "The create method which returns [ {0} ] interface was found.", new Object[]{local, methods[i].getName()}));
                this.foundAtLeastOneCreate = true;
            }
            if (validReturn) continue;
            oneFailed = true;
            this.result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{this.compName.toString()}));
            this.result.addErrorDetails(smh.getLocalString(this.getClass().getName() + ".debug1", "For Home Interface [ {0} ] Method [ {1} ]", new Object[]{home, methods[i].getName()}));
            this.result.addErrorDetails(smh.getLocalString(this.getClass().getName() + ".failed", "Error: A Create method was found, but the return type [ {0} ] was not the Remote/Local interface", new Object[]{methodReturnType.getName()}));
        }
        return oneFailed;
    }
}

