/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.session;

import com.sun.enterprise.deployment.ContainerTransaction;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbSessionDescriptor;
import com.sun.enterprise.deployment.MethodDescriptor;
import com.sun.enterprise.tools.verifier.Context;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;
import com.sun.enterprise.tools.verifier.tests.ejb.MethodUtils;
import java.lang.reflect.Method;
import java.util.Enumeration;

public class TransactionDemarcationHomeInterface
extends EjbTest
implements EjbCheck {
    Result result = null;
    ComponentNameConstructor compName = null;

    public Result check(EjbDescriptor descriptor) {
        this.result = this.getInitializedResult();
        this.compName = new ComponentNameConstructor(descriptor);
        try {
            if (descriptor instanceof EjbSessionDescriptor) {
                String transactionType = descriptor.getTransactionType();
                Context context = this.getVerifierContext();
                ClassLoader jcl = context.getClassLoader();
                if (EjbDescriptor.CONTAINER_TRANSACTION_TYPE.equals(transactionType)) {
                    Class<?> superclass;
                    boolean oneFailed = false;
                    if (descriptor.getHomeClassName() != null && !"".equals(descriptor.getHomeClassName())) {
                        superclass = jcl.loadClass(descriptor.getHomeClassName());
                        while (!(oneFailed = this.commonToBothInterfaces(superclass.getName(), (EjbSessionDescriptor)descriptor, MethodDescriptor.EJB_HOME)) && (superclass = superclass.getSuperclass()) != null) {
                        }
                    }
                    if (descriptor.getLocalHomeClassName() != null && !"".equals(descriptor.getLocalHomeClassName())) {
                        superclass = jcl.loadClass(descriptor.getLocalHomeClassName());
                        while (!(oneFailed = this.commonToBothInterfaces(superclass.getName(), (EjbSessionDescriptor)descriptor, MethodDescriptor.EJB_LOCALHOME)) && (superclass = superclass.getSuperclass()) != null) {
                        }
                    }
                    if (!oneFailed && this.implementsEndpoints(descriptor)) {
                        this.result.addNaDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{this.compName.toString()}));
                        this.result.notApplicable(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.ejb.webservice.notapp", "Not Applicable because, EJB [ {0} ] implements a Service Endpoint Interface.", new Object[]{this.compName.toString()}));
                        this.result.setStatus(3);
                        return this.result;
                    }
                    if (oneFailed) {
                        this.result.setStatus(1);
                    } else {
                        this.result.setStatus(0);
                    }
                    return this.result;
                }
                this.addNaDetails(this.result, this.compName);
                this.result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notApplicable2", "Bean [ {0} ] is not [ {1} ] managed, it is [ {2} ] managed.", new Object[]{descriptor.getName(), EjbDescriptor.CONTAINER_TRANSACTION_TYPE, transactionType}));
                return this.result;
            }
            this.addNaDetails(this.result, this.compName);
            this.result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notApplicable", "{0} expected {1} bean, but called with {2} bean.", new Object[]{this.getClass(), "Session", "Entity"}));
            return this.result;
        }
        catch (Throwable t) {
            this.addErrorDetails(this.result, this.compName);
            this.result.failed(smh.getLocalString(this.getClass().getName() + ".failedException1", "Error: Home interface  does not contain class [ {1} ] within bean [ {2} ]", new Object[]{t.getMessage(), descriptor.getName()}));
            return this.result;
        }
    }

    private boolean commonToBothInterfaces(String home, EjbSessionDescriptor descriptor, String methodIntf) {
        boolean oneFailed = false;
        try {
            Context context = this.getVerifierContext();
            ClassLoader jcl = context.getClassLoader();
            Class<?> c = jcl.loadClass(home);
            Method[] methods = c.getDeclaredMethods();
            boolean lookForIt = false;
            for (int i = 0; i < methods.length; ++i) {
                try {
                    ContainerTransaction containerTransaction = null;
                    boolean resolved = true;
                    if (!descriptor.getMethodContainerTransactions().isEmpty()) {
                        Enumeration ee = descriptor.getMethodContainerTransactions().keys();
                        while (ee.hasMoreElements()) {
                            lookForIt = false;
                            MethodDescriptor methodDescriptor = (MethodDescriptor)ee.nextElement();
                            lookForIt = methodDescriptor.getName().equals(MethodDescriptor.ALL_EJB_METHODS) ? (methodDescriptor.getEjbClassSymbol() == null ? true : (methodDescriptor.getEjbClassSymbol().equals(MethodDescriptor.EJB_HOME) ? true : (methodDescriptor.getEjbClassSymbol().equals("") ? true : (methodDescriptor.getEjbClassSymbol().equals(MethodDescriptor.EJB_REMOTE) ? false : false)))) : (methodDescriptor.getParameterClassNames() == null ? (methodDescriptor.getEjbClassSymbol() == null || methodDescriptor.getEjbClassSymbol().equals("") || methodDescriptor.getEjbClassSymbol().equals(MethodDescriptor.EJB_HOME) || methodDescriptor.getEjbClassSymbol().equals(MethodDescriptor.EJB_LOCALHOME)) && methods[i].getName().equals(methodDescriptor.getName()) : (methodDescriptor.getEjbClassSymbol() == null || methodDescriptor.getEjbClassSymbol().equals("") || methodDescriptor.getEjbClassSymbol().equals(MethodDescriptor.EJB_HOME) || methodDescriptor.getEjbClassSymbol().equals(MethodDescriptor.EJB_LOCALHOME)) && methods[i].getName().equals(methodDescriptor.getName()) && MethodUtils.stringArrayEquals(methodDescriptor.getParameterClassNames(), new MethodDescriptor(methods[i], methodIntf).getParameterClassNames()));
                            if (!lookForIt) continue;
                            containerTransaction = (ContainerTransaction)descriptor.getMethodContainerTransactions().get(methodDescriptor);
                            if (containerTransaction != null) {
                                String transactionAttribute = containerTransaction.getTransactionAttribute();
                                if (ContainerTransaction.NOT_SUPPORTED.equals(transactionAttribute) || ContainerTransaction.SUPPORTS.equals(transactionAttribute) || ContainerTransaction.REQUIRED.equals(transactionAttribute) || ContainerTransaction.REQUIRES_NEW.equals(transactionAttribute) || ContainerTransaction.MANDATORY.equals(transactionAttribute) || ContainerTransaction.NEVER.equals(transactionAttribute) || !transactionAttribute.equals("")) {
                                    if (!methodDescriptor.getEjbClassSymbol().equals(MethodDescriptor.EJB_HOME) && !methodDescriptor.getEjbClassSymbol().equals(MethodDescriptor.EJB_LOCALHOME)) {
                                        this.result.addGoodDetails(smh.getLocalString(this.getClass().getName() + ".passed", "Valid: TransactionAttribute [ {0} ] for method [ {1} ] is not defined for home interface [ {2} ]", new Object[]{transactionAttribute, methods[i].getName(), home}));
                                        continue;
                                    }
                                    oneFailed = true;
                                    this.addErrorDetails(this.result, this.compName);
                                    this.result.addErrorDetails(smh.getLocalString(this.getClass().getName() + ".failed", "Error: TransactionAttribute [ {0} ] for method [ {1} ] is not valid.   Transaction attributes must not be specified for all methods of session bean home interface [ {2} ].", new Object[]{transactionAttribute, methods[i].getName(), home}));
                                    resolved = false;
                                    continue;
                                }
                                this.addGoodDetails(this.result, this.compName);
                                this.result.addGoodDetails(smh.getLocalString(this.getClass().getName() + ".passed", "Valid: TransactionAttribute [ {0} ] for method [ {1} ] is not defined for home interface [ {2} ]", new Object[]{transactionAttribute, methods[i].getName(), home}));
                                continue;
                            }
                            this.addGoodDetails(this.result, this.compName);
                            this.result.addGoodDetails(smh.getLocalString(this.getClass().getName() + ".passedException", "Valid: TransactionAttribute is null for method [ {0} ]", new Object[]{methodDescriptor.getName()}));
                        }
                        if (!resolved) {
                            oneFailed = true;
                            this.addErrorDetails(this.result, this.compName);
                            this.result.addErrorDetails(smh.getLocalString(this.getClass().getName() + ".failed1", "Error: Transaction attributes must not be specified for the methods defined in the session bean home interface [ {0} ].  Method [ {1} ] has transaction attribute defined within this bean [ {2} ].", new Object[]{home, methods[i].getName(), descriptor.getName()}));
                        } else {
                            this.addGoodDetails(this.result, this.compName);
                            this.result.addGoodDetails(smh.getLocalString(this.getClass().getName() + ".passed2", "Valid: Transaction attributes must not be specified for the methods defined in the session bean home interface [ {0} ].  Method [ {1} ] has no transaction attribute defined within this bean [ {2} ].", new Object[]{home, methods[i].getName(), descriptor.getName()}));
                        }
                    } else {
                        this.addGoodDetails(this.result, this.compName);
                        this.result.passed(smh.getLocalString(this.getClass().getName() + ".passed1", "Valid: There are no method permissions within this bean [ {0} ].   Transaction attributes must not be specified for the methods defined in the session bean home interface [ {1} ].  Method [ {2} ] has no transaction attribute defined.", new Object[]{descriptor.getName(), home, methods[i].getName()}));
                    }
                    if (!oneFailed) continue;
                    return oneFailed;
                }
                catch (Exception e) {
                    this.addErrorDetails(this.result, this.compName);
                    this.result.failed(smh.getLocalString(this.getClass().getName() + ".failedException1", "Error: Home interface [ {0} ] does not contain class [ {1} ] within bean [ {2} ]", new Object[]{home, e.getMessage(), descriptor.getName()}));
                    return oneFailed;
                }
            }
            return oneFailed;
        }
        catch (ClassNotFoundException e) {
            Verifier.debug(e);
            this.addErrorDetails(this.result, this.compName);
            this.result.failed(smh.getLocalString(this.getClass().getName() + ".failedException", "Error: Home interface [ {0} ] does not exist or is not loadable within bean [ {1} ]", new Object[]{home, descriptor.getName()}));
            return oneFailed;
        }
    }
}

