/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.session;

import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbSessionDescriptor;
import com.sun.enterprise.tools.verifier.Context;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;
import java.util.logging.Level;

public class SessionSynchronizationInterface
extends EjbTest
implements EjbCheck {
    public Result check(EjbDescriptor descriptor) {
        Result result = this.getInitializedResult();
        ComponentNameConstructor compName = new ComponentNameConstructor(descriptor);
        if (descriptor instanceof EjbSessionDescriptor) {
            String stateType = ((EjbSessionDescriptor)descriptor).getSessionType();
            try {
                Context context = this.getVerifierContext();
                ClassLoader jcl = context.getClassLoader();
                Class<?> c = jcl.loadClass(descriptor.getEjbClassName());
                boolean oneFound = false;
                block2: do {
                    Class<?>[] interfaces = c.getInterfaces();
                    for (int i = 0; i < interfaces.length; ++i) {
                        this.logger.log(Level.FINE, this.getClass().getName() + ".debug1", new Object[]{interfaces[i].getName()});
                        if (!interfaces[i].getName().equals("javax.ejb.SessionSynchronization")) continue;
                        oneFound = true;
                        if ("Stateless".equals(stateType)) {
                            result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                            result.failed(smh.getLocalString(this.getClass().getName() + ".failed", "Error: [ {0} ] does not properly implement the SessionSynchronization interface.  SessionSynchronization interface must not be implemented by a stateless Session Bean. [ {1} ] is not a valid bean.", new Object[]{descriptor.getEjbClassName(), descriptor.getEjbClassName()}));
                            continue block2;
                        }
                        if (!"Stateful".equals(stateType)) continue;
                        String transactionType = descriptor.getTransactionType();
                        if (EjbSessionDescriptor.CONTAINER_TRANSACTION_TYPE.equals(transactionType)) {
                            result.addGoodDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                            result.passed(smh.getLocalString(this.getClass().getName() + ".passed", "[ {0} ] properly implements the SessionSynchronization interface.", new Object[]{descriptor.getEjbClassName()}));
                            continue block2;
                        }
                        if (!EjbSessionDescriptor.BEAN_TRANSACTION_TYPE.equals(transactionType)) continue;
                        result.addGoodDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                        result.failed(smh.getLocalString(this.getClass().getName() + ".failed2", "Error: [ {0} ] does not properly implement the SessionSynchronization interface.  SessionSynchronization interface may be implemented only by a stateful Session Bean using container-managed transactions. [ {1} ] is not a valid bean.", new Object[]{descriptor.getEjbClassName(), descriptor.getEjbClassName()}));
                        continue block2;
                    }
                } while ((c = c.getSuperclass()) != null);
                if (!oneFound) {
                    result.addNaDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                    result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notApplicable1", "Optional interface SessionSynchronization is not implemented by bean [ {0} ]", new Object[]{descriptor.getEjbClassName()}));
                }
            }
            catch (ClassNotFoundException e) {
                Verifier.debug(e);
                result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                result.failed(smh.getLocalString(this.getClass().getName() + ".failedException", "Error: [ {0} ] class not found.", new Object[]{descriptor.getEjbClassName()}));
            }
            return result;
        }
        result.addNaDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
        result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notApplicable", "[ {0} ] expected {1} bean, but called with {2} bean.", new Object[]{this.getClass(), "Session", "Entity"}));
        return result;
    }
}

