/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.runtime.beanpool;

import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbEntityDescriptor;
import com.sun.enterprise.deployment.EjbMessageBeanDescriptor;
import com.sun.enterprise.deployment.EjbSessionDescriptor;
import com.sun.enterprise.deployment.runtime.BeanPoolDescriptor;
import com.sun.enterprise.deployment.runtime.IASEjbExtraDescriptors;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;

public class ASEjbBeanPool
extends EjbTest
implements EjbCheck {
    public BeanPoolDescriptor beanPool;

    public Result check(EjbDescriptor descriptor) {
        Result result = this.getInitializedResult();
        ComponentNameConstructor compName = new ComponentNameConstructor(descriptor);
        IASEjbExtraDescriptors ejbJar = descriptor.getIASEjbExtraDescriptors();
        if (ejbJar != null) {
            try {
                this.beanPool = ejbJar.getBeanPool();
                if (this.beanPool != null) {
                    if (descriptor instanceof EjbSessionDescriptor && ((EjbSessionDescriptor)descriptor).getSessionType().equals("Stateful")) {
                        result.addWarningDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                        result.warning(smh.getLocalString(this.getClass().getName() + ".warning", "WARNING [AS-EJB ejb] : bean-pool should be defined for Stateless Session Beans, Entity Beans or Message Driven Beans"));
                    } else if (descriptor instanceof EjbMessageBeanDescriptor || descriptor instanceof EjbSessionDescriptor && ((EjbSessionDescriptor)descriptor).getSessionType().equals("Stateless") || descriptor instanceof EjbEntityDescriptor) {
                        result.addGoodDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                        result.passed(smh.getLocalString(this.getClass().getName() + ".passed", "PASSED [AS-EJB ejb] : bean-pool is correctly defined"));
                    }
                } else {
                    result.addNaDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                    result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notApplicable", "NOT APPLICABLE [AS-EJB ejb] : bean-pool element not defined"));
                }
                return result;
            }
            catch (Exception ex) {
                result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                result.addErrorDetails(smh.getLocalString(this.getClass().getName() + ".notRun", "NOT RUN [AS-EJB] : Could not create a beanPool object"));
            }
        } else {
            result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
            result.addErrorDetails(smh.getLocalString(this.getClass().getName() + ".notRun", "NOT RUN [AS-EJB] : Could not create an IASEjbExtraDescriptor object"));
        }
        return result;
    }
}

