/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.intf;

import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbEntityDescriptor;
import com.sun.enterprise.deployment.EjbSessionDescriptor;
import com.sun.enterprise.tools.verifier.Context;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;
import java.lang.reflect.Method;
import java.util.Arrays;

public abstract class InterfaceMethodTest
extends EjbTest {
    static String[] EJBObjectMethods = new String[]{"getEJBHome", "getHandle", "getPrimaryKey", "isIdentical", "remove", "getEJBLocalHome"};

    protected abstract String getInterfaceName(EjbDescriptor var1);

    protected abstract String getInterfaceType();

    protected abstract boolean runIndividualMethodTest(EjbDescriptor var1, Method var2, Result var3);

    public Result check(EjbDescriptor descriptor) {
        Result result = this.getInitializedResult();
        ComponentNameConstructor compName = new ComponentNameConstructor(descriptor);
        if (!(descriptor instanceof EjbSessionDescriptor) && !(descriptor instanceof EjbEntityDescriptor)) {
            result.addNaDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
            result.notApplicable(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.ejb.homeintf.HomeMethodTest.notApplicable1", "Test apply only to session or entity beans."));
            return result;
        }
        if (this.getInterfaceName(descriptor) == null || "".equals(this.getInterfaceName(descriptor))) {
            result.addNaDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
            result.notApplicable(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.ejb.localinterfaceonly.notapp", "Not Applicable because, EJB [ {0} ] has Local Interfaces only.", new Object[]{descriptor.getEjbClassName()}));
            return result;
        }
        try {
            Arrays.sort(EJBObjectMethods);
            Context context = this.getVerifierContext();
            ClassLoader jcl = context.getClassLoader();
            Class<?> interfaceClass = jcl.loadClass(this.getClassName(descriptor));
            if (this.studyInterface(descriptor, interfaceClass, result)) {
                result.setStatus(0);
            } else {
                result.setStatus(1);
            }
        }
        catch (ClassNotFoundException e) {
            Verifier.debug(e);
            result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
            result.failed(smh.getLocalString(this.getClass().getName() + ".failedException", "Error: " + this.getInterfaceType() + "interface [ {0} ] does not exist or is not loadable within bean [ {1} ]", new Object[]{this.getClassName(descriptor), descriptor.getName()}));
        }
        return result;
    }

    private boolean studyInterface(EjbDescriptor descriptor, Class clazz, Result result) {
        boolean allGood = true;
        Method[] interfaceMethods = clazz.getDeclaredMethods();
        for (int i = 0; i < interfaceMethods.length; ++i) {
            if (Arrays.binarySearch(EJBObjectMethods, interfaceMethods[i].getName()) >= 0 || this.runIndividualMethodTest(descriptor, interfaceMethods[i], result)) continue;
            allGood = false;
        }
        Class<?>[] interfaces = clazz.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            if (this.studyInterface(descriptor, interfaces[i], result)) continue;
            allGood = false;
        }
        return allGood;
    }

    private String getClassName(EjbDescriptor descriptor) {
        return this.getInterfaceName(descriptor);
    }
}

