/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.businessmethod;

import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbEntityDescriptor;
import com.sun.enterprise.deployment.EjbSessionDescriptor;
import com.sun.enterprise.deployment.MethodDescriptor;
import com.sun.enterprise.tools.verifier.Context;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;
import com.sun.enterprise.tools.verifier.tests.ejb.MethodUtils;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class BusinessMethodMatchesWithDD
extends EjbTest
implements EjbCheck {
    Result result = null;
    int foundAtLeastOne = 0;
    ComponentNameConstructor compName = null;

    public Result check(EjbDescriptor descriptor) {
        this.result = this.getInitializedResult();
        Object rc = null;
        this.compName = new ComponentNameConstructor(descriptor);
        if (descriptor instanceof EjbSessionDescriptor || descriptor instanceof EjbEntityDescriptor) {
            boolean oneFailed = false;
            if (descriptor.getRemoteClassName() != null && !"".equals(descriptor.getRemoteClassName())) {
                oneFailed = this.commonToBothInterfaces(descriptor.getRemoteClassName(), descriptor, MethodDescriptor.EJB_REMOTE);
            }
            if (!oneFailed && descriptor.getLocalClassName() != null && !"".equals(descriptor.getLocalClassName())) {
                oneFailed = this.commonToBothInterfaces(descriptor.getLocalClassName(), descriptor, MethodDescriptor.EJB_LOCAL);
            }
            ClassLoader cl = descriptor.getEjbBundleDescriptor().getClassLoader();
            if (oneFailed) {
                this.result.setStatus(1);
            } else if (this.foundAtLeastOne == 0) {
                this.result.setStatus(3);
            } else {
                this.result.setStatus(0);
            }
            return this.result;
        }
        this.result.addNaDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{this.compName.toString()}));
        this.result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notApplicable", "{0} expected {1} bean or {2} bean, but called with {3}.", new Object[]{this.getClass(), "Session", "Entity", descriptor.getName()}));
        return this.result;
    }

    private boolean commonToBothInterfaces(String remote, EjbDescriptor descriptor, String methodIntf) {
        boolean oneFailed = false;
        try {
            Context context = this.getVerifierContext();
            ClassLoader jcl = context.getClassLoader();
            Class<?> rc = jcl.loadClass(remote);
            boolean found = false;
            HashSet allMethods = new HashSet();
            ClassLoader cl = descriptor.getEjbBundleDescriptor().getClassLoader();
            if (cl != null) {
                do {
                    Set forceConvert = descriptor.getUncheckedMethodDescriptors();
                    Object e = descriptor.getPermissionedMethodsByPermission().values().iterator();
                    while (e.hasNext()) {
                        Set methodDescriptors = (Set)e.next();
                        if (methodDescriptors == null) continue;
                        allMethods.addAll(methodDescriptors);
                    }
                    e = descriptor.getMethodContainerTransactions().keys();
                    while (e.hasMoreElements()) {
                        allMethods.add(e.nextElement());
                    }
                    Iterator methods = null;
                    Method[] remoteMethods = rc.getMethods();
                    if (remoteMethods.length == 0) {
                        this.result.addNaDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{this.compName.toString()}));
                        this.result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notApplicable1", " [ {0} ] does not declare any business methods.", new Object[]{descriptor.getEjbClassName()}));
                    }
                    for (int h = 0; h < remoteMethods.length; ++h) {
                        found = false;
                        if (remoteMethods[h].getDeclaringClass().getName().equals("javax.ejb.EJBObject")) continue;
                        if (!(remoteMethods[h].getName().startsWith("ejb") || remoteMethods[h].getName().equals("class$") || remoteMethods[h].getName().equals("setSessionContext"))) {
                            methods = allMethods.iterator();
                            while (methods.hasNext()) {
                                MethodDescriptor methodDescriptor = (MethodDescriptor)methods.next();
                                if (!methodDescriptor.getName().equals(remoteMethods[h].getName()) || !MethodUtils.stringArrayEquals(methodDescriptor.getParameterClassNames(), new MethodDescriptor(remoteMethods[h], methodIntf).getParameterClassNames())) continue;
                                ++this.foundAtLeastOne;
                                this.result.addGoodDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{this.compName.toString()}));
                                this.result.addGoodDetails(smh.getLocalString(this.getClass().getName() + ".debug1", "For Component Interface [ {0} ]", new Object[]{remote}));
                                this.result.addGoodDetails(smh.getLocalString(this.getClass().getName() + ".passed", "Business method [ {0} ] is properly defined in the deployment descriptor", new Object[]{remoteMethods[h].getName()}));
                                found = true;
                                break;
                            }
                        }
                        if (found) continue;
                        oneFailed = true;
                        this.result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{this.compName.toString()}));
                        this.result.addErrorDetails(smh.getLocalString(this.getClass().getName() + ".debug1", "For Component Interface [ {0} ]", new Object[]{remote}));
                        this.result.addErrorDetails(smh.getLocalString(this.getClass().getName() + ".failed", "Error: Business method [ {0} ] is not defined in the deployment descriptor.", new Object[]{remoteMethods[h].getName()}));
                    }
                } while ((rc = rc.getSuperclass()) != null);
            }
            return oneFailed;
        }
        catch (Exception e) {
            Verifier.debug(e);
            oneFailed = true;
            this.result.addNaDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{this.compName.toString()}));
            this.result.failed(smh.getLocalString(this.getClass().getName() + ".failedException", "Error: Component interface [ {0} ] does not exist or is not loadable within bean [ {1} ].", new Object[]{remote, descriptor.getName()}));
            return oneFailed;
        }
    }
}

