/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb;

import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.WebServicesDescriptor;
import com.sun.enterprise.tools.verifier.Context;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.VerifierCheck;
import com.sun.enterprise.tools.verifier.tests.VerifierTest;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;
import java.io.File;

public abstract class EjbTest
extends VerifierTest
implements VerifierCheck,
EjbCheck {
    public Result check(Descriptor descriptor) {
        try {
            return this.check((EjbDescriptor)descriptor);
        }
        catch (Throwable t) {
            ComponentNameConstructor compName = new ComponentNameConstructor((EjbDescriptor)descriptor);
            Result r = this.getInitializedResult();
            if (t instanceof NoClassDefFoundError) {
                String s = t.toString();
                String className = s.substring(s.indexOf(":"));
                this.addWarningDetails(r, compName);
                r.warning(smh.getLocalString("com.sun.enterprise.tools.verifier.checkinclasspath", "The class [ {0} ] was not found, check manifest classpath, or make sure it is available in classpath at runtime.", new Object[]{className}));
            } else {
                this.addErrorDetails(r, compName);
                r.failed(smh.getLocalString("com.sun.enterprise.tools.verifier.CheckMgr.unexpectedError", "Unexpected error in verifier, check for problems related to: [ {0} ]", new Object[]{t.toString()}));
            }
            return r;
        }
    }

    public abstract Result check(EjbDescriptor var1);

    protected Class loadEjbClass(EjbDescriptor descriptor, Result result) {
        ComponentNameConstructor compName = new ComponentNameConstructor(descriptor);
        try {
            Context context = this.getVerifierContext();
            ClassLoader jcl = context.getClassLoader();
            return jcl.loadClass(descriptor.getEjbClassName());
        }
        catch (ClassNotFoundException e) {
            Verifier.debug(e);
            this.addErrorDetails(result, compName);
            result.failed(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.ejb.EjbTest.failedException", "Error: [ {0} ] class not found.", new Object[]{descriptor.getEjbClassName()}));
            return null;
        }
    }

    protected String getAbstractArchiveUri(EjbDescriptor desc) {
        String archBase = this.getVerifierContext().getAbstractArchive().getArchiveUri();
        if (desc.getEjbBundleDescriptor().getApplication() != null) {
            String moduleName = desc.getEjbBundleDescriptor().getModuleDescriptor().getArchiveUri();
            if (!moduleName.endsWith(".jar")) {
                return archBase;
            }
            String moduleDir = moduleName.replace('.', '_');
            String ret = archBase + File.separator + moduleDir;
            return ret;
        }
        return archBase;
    }

    public boolean implementsEndpoints(EjbDescriptor descriptor) {
        WebServicesDescriptor wdesc;
        EjbBundleDescriptor bdesc = descriptor.getEjbBundleDescriptor();
        return bdesc.hasWebServices() && (wdesc = bdesc.getWebServices()).hasEndpointsImplementedBy(descriptor);
    }

    public String getArchiveURI(EjbDescriptor desc) {
        return this.getAbstractArchiveUri(desc);
    }
}

