/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.connector;

import com.sun.enterprise.deployment.ConnectionDefDescriptor;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.deployment.EnvironmentProperty;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.connector.ConnectorCheck;
import com.sun.enterprise.tools.verifier.tests.connector.ConnectorTest;
import java.util.Iterator;
import java.util.Set;

public class CheckConfigPropertyType
extends ConnectorTest
implements ConnectorCheck {
    private static Class[] allowedTypes = new Class[]{String.class, Boolean.class, Integer.class, Double.class, Byte.class, Short.class, Long.class, Float.class, Character.class};

    public Result check(ConnectorDescriptor descriptor) {
        boolean oneFailed = false;
        Result result = this.getInitializedResult();
        ComponentNameConstructor compName = new ComponentNameConstructor(descriptor);
        ConnectionDefDescriptor desc = descriptor.getConnectionDefinitionByCFType(null, true);
        Set properties = desc.getConfigProperties();
        if (properties.size() != 0) {
            Iterator iterator = properties.iterator();
            while (iterator.hasNext()) {
                EnvironmentProperty ep = (EnvironmentProperty)iterator.next();
                String type = ep.getType();
                if (type == null) {
                    result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                    result.failed(smh.getLocalString(this.getClass().getName() + ".notdefined", "Error: The configuration property named [ {0} ] has no type ", new Object[]{ep.getName()}));
                    return result;
                }
                Class<?> typeClass = null;
                try {
                    typeClass = Class.forName(type);
                }
                catch (Throwable t) {
                    result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                    result.failed(smh.getLocalString(this.getClass().getName() + ".nonexist", "Error: The type [ {0} ] of the configuration property named [ {1} ] cannot be loaded", new Object[]{ep.getType(), ep.getName()}));
                    return result;
                }
                boolean allowedType = false;
                for (int i = 0; i < allowedTypes.length; ++i) {
                    if (!allowedTypes[i].equals(typeClass)) continue;
                    allowedType = true;
                    break;
                }
                if (allowedType) continue;
                oneFailed = true;
                result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                result.failed(smh.getLocalString(this.getClass().getName() + ".failed", "Error: The type [ {0} ] for the configuration property named [ {1} ] is not allowed", new Object[]{ep.getType(), ep.getName()}));
                return result;
            }
            if (!oneFailed) {
                result.addGoodDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                result.passed(smh.getLocalString(this.getClass().getName() + ".passed", "Success: all properties have an allowed type"));
            }
        } else {
            result.addNaDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
            result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notApplicable", "Not Applicable: There are no config-property element defined"));
        }
        return result;
    }
}

