/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.app;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.ApplicationClientDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.app.AppCheck;
import com.sun.enterprise.tools.verifier.tests.app.ApplicationTest;
import java.util.Iterator;

public class AppClientURI
extends ApplicationTest
implements AppCheck {
    public Result check(Application descriptor) {
        Result result = this.getInitializedResult();
        if (descriptor.getApplicationClientDescriptors().size() > 0) {
            boolean oneFailed = false;
            Iterator itr = descriptor.getApplicationClientDescriptors().iterator();
            while (itr.hasNext()) {
                ApplicationClientDescriptor acd = (ApplicationClientDescriptor)itr.next();
                if (!acd.getModuleDescriptor().getArchiveUri().equals("")) {
                    result.passed(smh.getLocalString(this.getClass().getName() + ".passed", "[ {0} ] specifies the URI [ {1} ] of a java application client module, relative to the top level of the application package [ {2} ].", new Object[]{acd.getName(), acd.getModuleDescriptor().getArchiveUri(), descriptor.getName()}));
                    continue;
                }
                if (!oneFailed) {
                    oneFailed = true;
                }
                result.addErrorDetails(smh.getLocalString(this.getClass().getName() + ".failed", "Error: [ {0} ] does not specify the URI [ {1} ] of an ejb-jar, relative to the top level of the application package [ {2} ], or does not end with \".jar\"", new Object[]{acd.getName(), acd.getModuleDescriptor().getArchiveUri(), descriptor.getName()}));
            }
            if (oneFailed) {
                result.setStatus(1);
            } else {
                result.setStatus(0);
            }
        } else {
            result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notApplicable", "There are no java application client modules in application [ {0} ]", new Object[]{descriptor.getName()}));
        }
        return result;
    }
}

