/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.appclient;

import com.sun.enterprise.deployment.ApplicationClientDescriptor;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.tools.verifier.BaseVerifier;
import com.sun.enterprise.tools.verifier.FrameworkContext;
import com.sun.enterprise.tools.verifier.apiscan.classfile.ClassFileLoaderFactory;
import com.sun.enterprise.tools.verifier.apiscan.packaging.ClassPathBuilder;
import com.sun.enterprise.tools.verifier.apiscan.stdapis.AppClientClosureCompiler;
import com.sun.enterprise.tools.verifier.appclient.AppClientCheckMgrImpl;
import com.sun.enterprise.util.JarClassLoader;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class AppClientVerifier
extends BaseVerifier {
    private ApplicationClientDescriptor appclientd = null;
    private String classPath;
    static final /* synthetic */ boolean $assertionsDisabled;

    public AppClientVerifier(FrameworkContext frameworkContext, ApplicationClientDescriptor appClientDescriptor) {
        this.frameworkContext = frameworkContext;
        this.appclientd = appClientDescriptor;
    }

    public void verify() throws Exception {
        if (this.areTestsNotRequired(this.frameworkContext.isEjb())) {
            return;
        }
        this.preVerification();
        this.createClosureCompiler();
        this.verify(this.appclientd, new AppClientCheckMgrImpl(this.frameworkContext));
    }

    public Descriptor getDescriptor() {
        return this.appclientd;
    }

    protected ClassLoader createClassLoader(File explodedArchive) throws IOException {
        JarClassLoader cl = new JarClassLoader();
        StringTokenizer st = new StringTokenizer(this.getClassPath(), File.pathSeparator);
        while (st.hasMoreTokens()) {
            String entry = st.nextToken();
            try {
                cl.appendURL(new File(entry).toURL());
            }
            catch (MalformedURLException e) {
                LogRecord log = new LogRecord(Level.WARNING, "Ignoring " + entry);
                log.setThrown(e);
                this.frameworkContext.getResultManager().log(log);
            }
        }
        this.appclientd.setClassLoader(cl);
        return cl;
    }

    protected String getArchiveUri() {
        return new File(this.appclientd.getModuleDescriptor().getArchiveUri()).getName();
    }

    protected String[] getDDString() {
        String[] dd = new String[]{"META-INF/sun-application-client.xml", "META-INF/application-client.xml"};
        return dd;
    }

    protected String getClassPath() throws IOException {
        String cp;
        if (this.classPath != null) {
            return this.classPath;
        }
        if (!this.appclientd.getModuleDescriptor().isStandalone()) {
            String ear_uri = this.frameworkContext.getExplodedArchivePath();
            File ear = new File(ear_uri);
            if (!$assertionsDisabled && !ear.isDirectory()) {
                throw new AssertionError();
            }
            String earCP = ClassPathBuilder.buildClassPathForEar(ear);
            String module_uri = this.appclientd.getModuleDescriptor().getArchiveUri();
            File module = new File(module_uri);
            if (!($assertionsDisabled || module.isFile() && !module.isAbsolute())) {
                throw new AssertionError();
            }
            File explodedModuleDir = new File(ear_uri, module_uri.replaceAll("\\.", "_"));
            String moduleCP = ClassPathBuilder.buildClassPathForJar(explodedModuleDir);
            cp = moduleCP + File.pathSeparator + earCP;
        } else {
            String module_uri = this.frameworkContext.getExplodedArchivePath();
            File module = new File(module_uri);
            if (!($assertionsDisabled || module.isDirectory() && module.isAbsolute())) {
                throw new AssertionError();
            }
            cp = ClassPathBuilder.buildClassPathForJar(module);
        }
        this.logger.log(Level.INFO, "Using CLASSPATH" + cp);
        this.classPath = cp;
        return this.classPath;
    }

    protected void createClosureCompiler() throws IOException {
        String specVer = this.appclientd.getSpecVersion();
        String cp = this.getClassPath();
        AppClientClosureCompiler cc = new AppClientClosureCompiler(specVer, ClassFileLoaderFactory.newInstance(new Object[]{cp}));
        this.context.setClosureCompiler(cc);
    }

    static {
        $assertionsDisabled = !AppClientVerifier.class.desiredAssertionStatus();
    }
}

