/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.appclient;

import com.sun.enterprise.deployment.ApplicationClientDescriptor;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.RootDeploymentDescriptor;
import com.sun.enterprise.deployment.ServiceReferenceDescriptor;
import com.sun.enterprise.tools.verifier.CheckMgr;
import com.sun.enterprise.tools.verifier.FrameworkContext;
import com.sun.enterprise.tools.verifier.JarCheck;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.wsclient.WebServiceClientCheckMgrImpl;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;

public class AppClientCheckMgrImpl
extends CheckMgr
implements JarCheck {
    private static final String testsListFileName = "TestNamesAppClient.xml";
    private static final String sunONETestsListFileName = AppClientCheckMgrImpl.getSunPrefix().concat("TestNamesAppClient.xml");
    private static Vector test = new Vector();

    public AppClientCheckMgrImpl(FrameworkContext frameworkContext) {
        this.frameworkContext = frameworkContext;
    }

    public void check(Descriptor descriptor) throws Exception {
        super.check(descriptor);
        if (!this.frameworkContext.isPartition() || this.frameworkContext.isWebServicesClient()) {
            WebServiceClientCheckMgrImpl webServiceClientCheckMgr = new WebServiceClientCheckMgrImpl(this.frameworkContext);
            this.checkWebServicesClient(descriptor, webServiceClientCheckMgr);
        }
    }

    protected Vector getTests() {
        return test;
    }

    protected String getTestsListFileName() {
        return testsListFileName;
    }

    protected String getSunONETestsListFileName() {
        return sunONETestsListFileName;
    }

    protected String getSpecVersion(Descriptor descriptor) {
        return ((RootDeploymentDescriptor)descriptor).getSpecVersion();
    }

    protected void setModuleName(Result r) {
        r.setModuleName("appclient");
    }

    protected String getArchiveUri(Descriptor descriptor) {
        return ((ApplicationClientDescriptor)descriptor).getDisplayName();
    }

    protected void checkWebServicesClient(Descriptor descriptor, WebServiceClientCheckMgrImpl webServiceClientCheckMgr) throws Exception {
        ApplicationClientDescriptor desc = (ApplicationClientDescriptor)descriptor;
        if (desc.hasWebServiceClients()) {
            Set serviceRefDescriptors = desc.getServiceReferenceDescriptors();
            Iterator it = serviceRefDescriptors.iterator();
            while (it.hasNext()) {
                webServiceClientCheckMgr.setVerifierContext(this.context);
                webServiceClientCheckMgr.check((ServiceReferenceDescriptor)it.next());
            }
        } else {
            webServiceClientCheckMgr.setVerifierContext(this.context);
        }
    }
}

