/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.apiscan.stdapis;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class APIRepository {
    private static Logger logger;
    private static String myClsName;
    private HashMap apis = new HashMap();
    private static APIRepository me;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static APIRepository Instance() {
        if (!$assertionsDisabled && me == null) {
            throw new AssertionError();
        }
        return me;
    }

    public static synchronized void Initialize(String fileName) throws Exception {
        logger.logp(Level.INFO, myClsName, "Initialize", fileName);
        me = new APIRepository(fileName);
    }

    private APIRepository(String fileName) throws Exception {
        logger.entering(myClsName, "init<>", fileName);
        File file = new File(fileName);
        DocumentBuilderFactory bf = DocumentBuilderFactory.newInstance();
        bf.setValidating(true);
        bf.setIgnoringComments(false);
        bf.setIgnoringElementContentWhitespace(true);
        bf.setCoalescing(true);
        bf.setNamespaceAware(true);
        bf.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
        DocumentBuilder builder = bf.newDocumentBuilder();
        builder.setErrorHandler(new DefaultHandler(){

            public void error(SAXParseException e) throws SAXException {
                throw e;
            }
        });
        Document d = builder.parse(file);
        this.traverseTree(d.getDocumentElement());
    }

    private void traverseTree(Node node) {
        if (node == null) {
            return;
        }
        if (node.getNodeType() == 1) {
            Element e = (Element)node;
            String tagName = e.getTagName();
            if (tagName.equals("api")) {
                API a = new API(e);
                this.apis.put(a.name_version, a);
            }
            NodeList childNodes = node.getChildNodes();
            for (int i = 0; i < childNodes.getLength(); ++i) {
                this.traverseTree(childNodes.item(i));
            }
        }
    }

    public Collection getPackagesFor(String api_name_version) {
        return ((API)this.apis.get(api_name_version)).getPackages();
    }

    public Collection getPatternsFor(String api_name_version) {
        return ((API)this.apis.get(api_name_version)).getPatterns();
    }

    public Collection getClassesFor(String api_name_version) {
        return ((API)this.apis.get(api_name_version)).getClasses();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        Iterator i = this.apis.values().iterator();
        while (i.hasNext()) {
            sb.append("\n").append(i.next().toString());
        }
        return sb.toString();
    }

    public static void main(String[] args) {
        int i;
        if (args.length < 1) {
            System.out.println("Usage: jave " + APIRepository.class.getName() + " <file_name> [api_name_version(s)]");
        }
        Logger logger = Logger.getLogger("apiscan.stdapis");
        logger.setLevel(Level.ALL);
        Handler[] hs = logger.getHandlers();
        for (i = 0; i < hs.length; ++i) {
            hs[i].setLevel(Level.ALL);
        }
        try {
            APIRepository.Initialize(args[0]);
            if (args.length > 1) {
                for (i = 1; i < args.length; ++i) {
                    System.out.println(APIRepository.Instance().apis.get(args[i]));
                }
            } else {
                System.out.println(APIRepository.Instance());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        $assertionsDisabled = !APIRepository.class.desiredAssertionStatus();
        logger = Logger.getLogger("apiscan.stdapis");
        myClsName = "APIRepository";
    }

    class API {
        private String name_version;
        private ArrayList apiRefs = new ArrayList();
        ArrayList packages = new ArrayList();
        ArrayList patterns = new ArrayList();
        ArrayList classes = new ArrayList();

        public API(Element node) {
            if (node.getTagName().equals("api")) {
                this.name_version = node.getAttribute("name_version");
                NodeList refNodes = node.getElementsByTagName("api_ref");
                for (int loopIndex = 0; loopIndex < refNodes.getLength(); ++loopIndex) {
                    this.apiRefs.add(new APIRef((Element)refNodes.item(loopIndex)));
                }
                NodeList pkgsNodes = node.getElementsByTagName("packages");
                for (int i = 0; i < pkgsNodes.getLength(); ++i) {
                    Element pkgsNode = (Element)pkgsNodes.item(i);
                    NodeList children = pkgsNode.getChildNodes();
                    for (int j = 0; j < children.getLength(); ++j) {
                        Node next = children.item(j);
                        if (next.getNodeType() != 3) continue;
                        String names = next.getNodeValue().trim();
                        StringTokenizer st = new StringTokenizer(names);
                        while (st.hasMoreTokens()) {
                            this.packages.add(st.nextToken());
                        }
                    }
                }
                NodeList patternsNodes = node.getElementsByTagName("patterns");
                for (int i = 0; i < patternsNodes.getLength(); ++i) {
                    Element patternsNode = (Element)patternsNodes.item(i);
                    NodeList children = patternsNode.getChildNodes();
                    for (int j = 0; j < children.getLength(); ++j) {
                        Node next = children.item(j);
                        if (next.getNodeType() != 3) continue;
                        String names = next.getNodeValue().trim();
                        StringTokenizer st = new StringTokenizer(names);
                        while (st.hasMoreTokens()) {
                            this.patterns.add(st.nextToken());
                        }
                    }
                }
                NodeList classesNodes = node.getElementsByTagName("classes");
                for (int i = 0; i < classesNodes.getLength(); ++i) {
                    Element classesNode = (Element)classesNodes.item(i);
                    String package_name = classesNode.getAttribute("package").trim();
                    NodeList children = classesNode.getChildNodes();
                    for (int j = 0; j < children.getLength(); ++j) {
                        Node next = children.item(j);
                        if (next.getNodeType() != 3) continue;
                        String names = next.getNodeValue().trim();
                        StringTokenizer st = new StringTokenizer(names);
                        while (st.hasMoreTokens()) {
                            String clsName = package_name + "." + st.nextToken();
                            this.classes.add(clsName);
                        }
                    }
                }
            } else {
                throw new IllegalArgumentException(node.toString());
            }
        }

        public Collection getPackages() {
            ArrayList results = new ArrayList();
            Iterator i = this.apiRefs.iterator();
            while (i.hasNext()) {
                results.addAll(((APIRef)i.next()).deref().getPackages());
            }
            results.addAll(this.packages);
            return results;
        }

        public Collection getPatterns() {
            ArrayList results = new ArrayList();
            Iterator i = this.apiRefs.iterator();
            while (i.hasNext()) {
                results.addAll(((APIRef)i.next()).deref().getPatterns());
            }
            results.addAll(this.patterns);
            return results;
        }

        public Collection getClasses() {
            ArrayList results = new ArrayList();
            Iterator i = this.apiRefs.iterator();
            while (i.hasNext()) {
                results.addAll(((APIRef)i.next()).deref().getClasses());
            }
            results.addAll(this.classes);
            return results;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("<api name_version=\"" + this.name_version + "\">");
            sb.append("\n\t<classes>");
            Iterator i = this.getClasses().iterator();
            while (i.hasNext()) {
                sb.append("\n\t\t").append(i.next().toString());
            }
            sb.append("\n\t</classes>");
            sb.append("\n\t<packages>");
            i = this.getPackages().iterator();
            while (i.hasNext()) {
                sb.append("\n\t\t").append(i.next().toString());
            }
            sb.append("\n\t</packages>");
            sb.append("\n\t<patterns>");
            i = this.getPatterns().iterator();
            while (i.hasNext()) {
                sb.append("\n\t\t").append(i.next().toString());
            }
            sb.append("\n\t</patterns>");
            sb.append("\n</api>");
            return sb.toString();
        }
    }

    class APIRef {
        private String api_name_version;

        public APIRef(Element node) {
            if (!node.getTagName().equals("api_ref")) {
                throw new IllegalArgumentException(node.toString());
            }
            this.api_name_version = node.getAttribute("api_name_version");
        }

        public APIRef(String api_name_version) {
            this.api_name_version = api_name_version;
        }

        public API deref() {
            API result = (API)APIRepository.this.apis.get(this.api_name_version);
            if (result == null) {
                throw new NullPointerException("No API with name_version [" + this.api_name_version + "]");
            }
            return result;
        }
    }
}

